DECLARE @this_schema VARCHAR(256);
BEGIN

  SET @this_schema = SCHEMA_NAME();
  PRINT 'schema name: ' + @this_schema;
  
  IF (NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = @this_schema 
    AND  TABLE_NAME = 'WLS_HVST'))
  BEGIN
    PRINT 'CREATING TABLE WLS_HVST'
    CREATE TABLE "WLS_HVST"
    (	
      "RECORDID" NUMERIC(20,0) IDENTITY(1,1) PRIMARY KEY, 
      "TIMESTAMP" NUMERIC(20,0) DEFAULT NULL, 
      "DOMAIN" VARCHAR(250) DEFAULT NULL, 
      "SERVER" VARCHAR(250) DEFAULT NULL, 
      "TYPE" VARCHAR(250) DEFAULT NULL, 
      "NAME" VARCHAR(250) DEFAULT NULL, 
      "ATTRNAME" VARCHAR(250) DEFAULT NULL, 
      "ATTRTYPE" NUMERIC(10,0) DEFAULT NULL, 
      "ATTRVALUE" VARCHAR(4000) DEFAULT NULL, 
      "WLDFMODULE" VARCHAR(250) DEFAULT NULL
    );  
    CREATE INDEX WLS_HVST_TS_INDEX ON WLS_HVST(TIMESTAMP);
  END;

  IF (NOT EXISTS (
    SELECT COLUMN_NAME  
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE COLUMN_NAME = 'WLDFMODULE' AND TABLE_NAME = 'WLS_HVST' AND TABLE_SCHEMA = @this_schema) )
  BEGIN
    PRINT 'ADDING COLUMN WLDFMODULE TO WLDFMODULE'
    ALTER TABLE WLS_HVST ADD WLDFMODULE VARCHAR(250) NULL;
  END;
  
END;
GO
 
