DECLARE @this_schema VARCHAR(256);
BEGIN

  SET @this_schema = SCHEMA_NAME();
  PRINT 'schema name: ' + @this_schema;

  IF (NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = @this_schema 
    AND  TABLE_NAME = 'WLS_EVENTS'))
  BEGIN
    PRINT 'CREATING TABLE WLS_EVENTS'
    CREATE TABLE "WLS_EVENTS" (
      "RECORDID" NUMERIC(20,0) IDENTITY(1,1) PRIMARY KEY, 
      "TIMESTAMP" NUMERIC(20,0) DEFAULT NULL, 
      "CONTEXTID" VARCHAR(250) DEFAULT NULL, 
      "TXID" VARCHAR(250) DEFAULT NULL, 
      "USERID" VARCHAR(250) DEFAULT NULL, 
      "TYPE" VARCHAR(250) DEFAULT NULL, 
      "DOMAIN" VARCHAR(250) DEFAULT NULL, 
      "SERVER" VARCHAR(250) DEFAULT NULL, 
      "SCOPE" VARCHAR(250) DEFAULT NULL, 
      "MODULE" VARCHAR(250) DEFAULT NULL, 
      "MONITOR" VARCHAR(250) DEFAULT NULL, 
      "FILENAME" VARCHAR(250) DEFAULT NULL, 
      "LINENUM" NUMERIC(10,0) DEFAULT NULL, 
      "CLASSNAME" VARCHAR(250) DEFAULT NULL, 
      "METHODNAME" VARCHAR(250) DEFAULT NULL, 
      "METHODDSC" VARCHAR(4000) DEFAULT NULL, 
      "ARGUMENTS" NVARCHAR(MAX) DEFAULT NULL, 
      "RETVAL" VARCHAR(4000) DEFAULT NULL, 
      "PAYLOAD" VARBINARY(MAX) DEFAULT NULL, 
      "CTXPAYLOAD" VARCHAR(4000) DEFAULT NULL, 
      "DYES" NUMERIC(20,0) DEFAULT NULL, 
      "THREADNAME" VARCHAR(250) DEFAULT NULL
      );

    CREATE INDEX WLS_EVENTS_TS_INDEX ON WLS_EVENTS(TIMESTAMP);
  END;
  
  IF NOT EXISTS (
    SELECT COLUMN_NAME  
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE COLUMN_NAME = 'THREADNAME' AND TABLE_NAME = 'WLS_EVENTS' AND TABLE_SCHEMA = @this_schema) 
  BEGIN
	PRINT 'ADDING COLUMN THREADNAME TO WLS_EVENTS'
    ALTER TABLE WLS_EVENTS ADD THREADNAME VARCHAR(250) NULL
  END;

END;
GO

