SET SERVEROUTPUT ON;

DECLARE
 vCtr     Number;
 vSQL     VARCHAR2(2000);
 vcurrSchema VARCHAR2(256);
BEGIN

  SELECT sys_context( 'userenv', 'current_schema' ) into vcurrSchema from dual;
  dbms_output.put_line('Current Schema: '||vcurrSchema);
	
  SELECT COUNT(*)
  INTO vCtr
  FROM user_tables
  WHERE table_name = 'WLS_EVENTS';
 
  IF vCtr = 0 THEN
    dbms_output.put_line('Creating WLS_EVENTS table');
    vSQL := 'CREATE TABLE "WLS_EVENTS" (
    "RECORDID" NUMBER(20,0) DEFAULT NULL, 
    "TIMESTAMP" NUMBER(20,0) DEFAULT NULL, 
    "CONTEXTID" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "TXID" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "USERID" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "TYPE" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "DOMAIN" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "SERVER" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "SCOPE" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "MODULE" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "MONITOR" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "FILENAME" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "LINENUM" NUMBER(10,0) DEFAULT NULL, 
    "CLASSNAME" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "METHODNAME" VARCHAR2(250 BYTE) DEFAULT NULL, 
    "METHODDSC" VARCHAR2(4000 BYTE) DEFAULT NULL, 
    "ARGUMENTS" CLOB DEFAULT NULL, 
    "RETVAL" VARCHAR2(4000 BYTE) DEFAULT NULL, 
    "PAYLOAD" BLOB DEFAULT NULL, 
    "CTXPAYLOAD" VARCHAR2(4000 BYTE) DEFAULT NULL, 
    "DYES" NUMBER(20,0) DEFAULT NULL, 
    "THREADNAME" VARCHAR2(250 BYTE) DEFAULT NULL
   )';
   EXECUTE IMMEDIATE vSQL;
   vSQL := 'CREATE UNIQUE INDEX WLS_EVENTS_RECORD_IDX ON WLS_EVENTS(RECORDID)';
   EXECUTE IMMEDIATE vSQL;
   vSQL := 'CREATE INDEX WLS_EVENTS_TS_IDX ON WLS_EVENTS(TIMESTAMP)';
   EXECUTE IMMEDIATE vSQL;
  END IF;
  
  SELECT COUNT(*)
  INTO vCtr
  FROM user_tab_columns
  WHERE table_name = 'WLS_EVENTS' AND column_name = 'THREADNAME';
  
  IF vCtr = 0 THEN
    dbms_output.put_line('Creating THREADNAME column in WLS_EVENTS table');
    vSQL := 'ALTER TABLE WLS_EVENTS ADD("THREADNAME" VARCHAR2(250 BYTE) DEFAULT NULL)';
    EXECUTE IMMEDIATE vSQL;  
  END IF;

  SELECT COUNT(*) INTO vCtr FROM user_sequences
  WHERE sequence_name = 'SEQ_WLS_EVENTS_RECORDID';
  
  IF vCtr = 0 THEN
    vSQL := 'CREATE SEQUENCE SEQ_WLS_EVENTS_RECORDID MINVALUE 1 MAXVALUE 99999999999999999999 START WITH 1 INCREMENT BY 1 NOCACHE';
    EXECUTE IMMEDIATE vSQL;
  END IF;

  SELECT COUNT(*) INTO vCtr FROM user_triggers
  WHERE table_name = 'WLS_EVENTS';

  IF vCtr = 0 THEN  
    vSQL := 'CREATE OR REPLACE TRIGGER TRG_WLS_EVENTS_INSERT 
    BEFORE INSERT ON WLS_EVENTS 
    REFERENCING NEW AS newRow 
    FOR EACH ROW 
    BEGIN 
      IF :newRow.RECORDID IS NULL THEN 
        SELECT SEQ_WLS_EVENTS_RECORDID.nextval INTO :newRow.RECORDID FROM DUAL; 
      END IF; 
    END;';
    EXECUTE IMMEDIATE vSQL;    
  END IF;  
  
END;
/
