CREATE TABLE WLS_EVENTS (
    RECORDID DECIMAL(20,0) GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
    TIMESTAMP DECIMAL(20,0) DEFAULT NULL, 
    CONTEXTID VARCHAR(250) DEFAULT NULL, 
    TXID VARCHAR(250) DEFAULT NULL, 
    USERID VARCHAR(250) DEFAULT NULL, 
    TYPE VARCHAR(250) DEFAULT NULL, 
    DOMAIN VARCHAR(250) DEFAULT NULL, 
    SERVER VARCHAR(250) DEFAULT NULL, 
    SCOPE VARCHAR(250) DEFAULT NULL, 
    MODULE VARCHAR(250) DEFAULT NULL, 
    MONITOR VARCHAR(250) DEFAULT NULL, 
    FILENAME VARCHAR(250) DEFAULT NULL, 
    LINENUM DECIMAL(10,0) DEFAULT NULL, 
    CLASSNAME VARCHAR(250) DEFAULT NULL, 
    METHODNAME VARCHAR(250) DEFAULT NULL, 
    METHODDSC VARCHAR(4000) DEFAULT NULL, 
    ARGUMENTS CLOB DEFAULT NULL, 
    RETVAL VARCHAR(4000) DEFAULT NULL, 
    PAYLOAD BLOB DEFAULT NULL, 
    CTXPAYLOAD VARCHAR(4000) DEFAULT NULL, 
    DYES DECIMAL(20,0) DEFAULT NULL, 
    THREADNAME VARCHAR(250) DEFAULT NULL
  )@

ALTER TABLE WLS_EVENTS ADD THREADNAME VARCHAR(250) DEFAULT NULL@

--BEGIN
--
--
--  DECLARE this_schema VARCHAR(250);
--
--  SET this_schema = VALUES CURRENT SCHEMA;
--  
--  BEGIN ATOMIC
--    IF NOT EXISTS(SELECT * FROM SYSCAT.TABLES WHERE TABSCHEMA = this_schema AND TABNAME = 'WLS_EVENTS') THEN
--CREATE TABLE WLS_EVENTS (
--    RECORDID DECIMAL(20,0) GENERATED ALWAYS AS IDENTITY PRIMARY KEY,
--    TIMESTAMP DECIMAL(20,0) DEFAULT NULL, 
--    CONTEXTID VARCHAR(250) DEFAULT NULL, 
--    TXID VARCHAR(250) DEFAULT NULL, 
--    USERID VARCHAR(250) DEFAULT NULL, 
--    TYPE VARCHAR(250) DEFAULT NULL, 
--    DOMAIN VARCHAR(250) DEFAULT NULL, 
--    SERVER VARCHAR(250) DEFAULT NULL, 
--    SCOPE VARCHAR(250) DEFAULT NULL, 
--    MODULE VARCHAR(250) DEFAULT NULL, 
--    MONITOR VARCHAR(250) DEFAULT NULL, 
--    FILENAME VARCHAR(250) DEFAULT NULL, 
--    LINENUM DECIMAL(10,0) DEFAULT NULL, 
--    CLASSNAME VARCHAR(250) DEFAULT NULL, 
--    METHODNAME VARCHAR(250) DEFAULT NULL, 
--    METHODDSC VARCHAR(4000) DEFAULT NULL, 
--    ARGUMENTS CLOB DEFAULT NULL, 
--    RETVAL VARCHAR(4000) DEFAULT NULL, 
--    PAYLOAD BLOB DEFAULT NULL, 
--    CTXPAYLOAD VARCHAR(4000) DEFAULT NULL, 
--    DYES DECIMAL(20,0) DEFAULT NULL, 
--    THREADNAME VARCHAR(250) DEFAULT NULL
--  );
--    END IF;
--  END
--  
--  BEGIN ATOMIC
--    IF NOT EXISTS(SELECT * FROM SYSCAT.COLUMNS WHERE TABSCHEMA = this_schema AND TBNAME = 'WLS_EVENTS' AND NAME ='THREADNAME') THEN
--      ALTER TABLE WLS_EVENTS ADD THREADNAME VARCHAR(250) DEFAULT NULL;
--    END IF;
--  END
--
--END;
