<%@ page language="java"%>
<%@ page import="com.bea.console.utils.MBeanUtils"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/WEB-INF/console-html.tld" prefix="wl"%>
<%
  String contextPath = request.getContextPath();
  MBeanUtils.cacheHost(request.getServerName());
  MBeanUtils.cacheHostIP(request.getLocalAddr());
  MBeanUtils.cacheListenPort(request.getLocalPort());
  MBeanUtils.cacheScheme(request.getScheme());
  String autocomplete = ("https".equals(request.getScheme())) ? "off" : "on";

  response.setHeader("Cache-Control","no-cache"); //HTTP 1.1
  response.setHeader("Pragma","no-cache"); //HTTP 1.0
  response.setDateHeader ("Expires", 0); //prevents caching at the proxy server
  response.setContentType("text/html; charset=UTF-8");
%>

<wl:setBundle basename="global" var="current_bundle" scope="page" />
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" >
<title><fmt:message key="window.title" bundle="${current_bundle}"/></title>
<link rel="stylesheet" type="text/css" href="<%=contextPath%>/framework/skins/EXTENSIONNAME/css/general.css" >
<link rel="stylesheet" type="text/css" href="<%=contextPath%>/framework/skins/EXTENSIONNAME/css/window.css" >
<link rel="stylesheet" type="text/css" href="<%=contextPath%>/css/login.css" >
<script type="text/javascript">
  // Disable frame hijacking  
  if (top != self) top.location.href = location.href;
</script>
<style type="text/css">
html {
    background-color: #001C34;
}
</style>
</head>
<body onload="document.loginData.j_username.focus();">
  <div id="top">
    <div id="login-header">
      <div id="login-logo">
        <fmt:message key="login.wlsident" bundle="${current_bundle}" var="wlsident" scope="page" />
        <img src="<%=contextPath%>/framework/skins/EXTENSIONNAME/images/login_WebLogic_branding.png" alt="${wlsident} ">
      </div>
    </div>
    <div id="content">
      <div id="sidebar">
        <img src="<%=contextPath%>/framework/skins/EXTENSIONNAME/images/login-12c.png" alt="">
      </div>
      <div id="login">
        <div id="title">
          <fmt:message key="login.title" bundle="${current_bundle}"/>
        </div>
        <div id="login-form">

    <form id="loginData" name="loginData" method="post" action="<%=contextPath%>/j_security_check">
      <div class="message-row">
        <noscript><p class="loginFailed"><fmt:message key="javascript.required" bundle="${current_bundle}"/></p></noscript>
        <c:choose>
        <c:when test="${consoleLoginFailed eq 'yes'}">
          <c:remove var="consoleLoginFailed" scope="session"/>
          <p class="loginFailed"><img src="<%=contextPath%>/images/error_status.gif" alt=''>
          <fmt:message key="loginerror.authdenied" bundle="${current_bundle}"/></p>
          <p><fmt:message key="loginerror.passwordrefused" bundle="${current_bundle}"/></p>
        </c:when>
        <c:otherwise>
          <p><fmt:message key="login.welcome2" bundle="${current_bundle}" /></p>
        </c:otherwise>
        </c:choose>
      </div>
      <div class="input-row">
        <label for="j_username">
        <fmt:message key="login.username" bundle="${current_bundle}" /></label>
        <span class="ctrl">
          <input class="textinput" type="text" autocomplete="<%=autocomplete%>" name="j_username" id="j_username">
        </span>
      </div>
      <div class="input-row">
        <label for="j_password">
          <fmt:message key="login.password" bundle="${current_bundle}" /></label>
        <span class="ctrl">
          <input class="textinput" type="password" autocomplete="<%=autocomplete%>" name="j_password" id="j_password">
        </span>
      </div>
      <div class="button-row">
        <span class="ctrl">
          <input class="formButton" type="submit" 
            onclick="form.submit();this.disabled=true;document.body.style.cursor = 'wait'; this.className='formButton-disabled';"
            value='<fmt:message key="login.submit" bundle="${current_bundle}"/>'>
        </span>
        <input type="hidden" name="j_character_encoding" value="UTF-8">
      </div>
    </form>
        </div>
      </div>
    </div>
    <div id="info">
    </div>
  </div>

  <div class="login-footer">
    <div class="info">
      <c:set var="ver" scope="page">
        <jsp:expression>weblogic.version.getReleaseBuildVersion()</jsp:expression>
      </c:set>
      <p id="footerVersion"><fmt:message key='weblogic.version' bundle="${current_bundle}" />: ${ver}</p>
      <p id="copyright"><fmt:message key='console.copyright' bundle="${current_bundle}" /></p>
      <p id="trademark"><fmt:message key='console.trademark' bundle="${current_bundle}" /></p>
    </div>
  </div>
</body>
</html>
