/*!
  Request Performance (Diagnostics) page.
  Copyright (c) 2010 Oracle and/or its affiliates. All rights reserved.
*/
/*global wls,window,jQuery,mvc,getFormattedMethodSignature,sortTable */

(function($) {

  var NODE_LABEL_SLCTR ="span.nodelabel";
  var BUNDLE = "requestperf";
  var MVCCORE_BUNDLE = "mvccore";
  var MISSING_CHILD_NODE = "MISSING-CHILD-NODE";
  var GAP = mvc.getMessage(BUNDLE,"req.perf.gap.node");
  var SORT_ASC_ICON = "sortascicon";
  var SORT_DESC_ICON = "sortdescicon";
  var NS_TO_MS = 1000000; // nanos to millis conversion factor.

  var reqPerfDDHHMMFields = [
    { id: "reqInterDuration",
      prop: "reqInterDuration",
      type: "string",
      formatter: {fn: "deltatime", args: ["m"]},
      constraints: ["required", "deltatime"]
    }
  ];
  var reqPerfDDHHMMObj = {
    reqInterDuration:""
  };
  var reqPerfCustomFields = [
    { id: "reqInterCustomStart",
      prop: "reqInterCustomStart",
      type: "date",
      formatter: "datetime",
      constraints: ["required", "datetime"]
    },
    { id: "reqTimeCustomDuration",
      prop: "reqTimeCustomDuration",
      type: "string",
      formatter: {fn: "deltatime", args: ["m"]},
      constraints: ["required", "deltatime"]
    }
  ];
  var reqPerfCustomObj = {
    reqInterCustomStart:null,
    reqTimeCustomDuration:""
  };

  var rootNodeUrl1 = mvc.uriTemplate("data/servers/{server}/diagnostics/instrumentation/requestInfoTrees?duration={duration}");
  var rootNodeUrl2 = mvc.uriTemplate("data/servers/{server}/diagnostics/instrumentation/requestInfoTrees?duration={duration}&startDate={startDate}&startTime={startTime}");
  var childNodeUrl = mvc.uriTemplate("data/servers/{server}/diagnostics/instrumentation/requestInfoTree/{diagnosticContextId}");

  var timeIntervals = [
    { label: mvc.getMessage(BUNDLE, "req.perf.last.5.mins"), value: "5" },
    { label: mvc.getMessage(BUNDLE, "req.perf.last.15.mins"), value: "15" },
    { label: mvc.getMessage(BUNDLE, "req.perf.last.30.mins"), value: "30" },
    { label: mvc.getMessage(BUNDLE, "req.perf.last.60.mins"), value: "60" },
    { label: mvc.getMessage(BUNDLE, "req.perf.last.ddhhmm"), value: "ddhhmm" },
    { label: mvc.getMessage(BUNDLE, "req.perf.custom.duration"), value: "custom" }
  ];

  var reqNodeNoteAttributes = [
    { label:mvc.getMessage(BUNDLE, "req.perf.tree.note.contextId"), attrName: "contextId" },
    { label:mvc.getMessage(BUNDLE, "req.perf.tree.note.elapsed"), attrName: "elapsedTime" }
  ];

  var reqNodeAttributes = [
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.classname"), attrName: "className" },
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.methodname"), attrName: "methodName" },
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.count"), attrName: "invocationCount" },
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.totaltime"), attrName: "totalElapsedTime" },
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.averagetime"), attrName: "averageTime" },
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.scopename"), attrName: "scope" },
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.modulename"), attrName: "moduleName" },
    { label:mvc.getMessage(BUNDLE, "req.perf.grid.signature"), attrName: "methodSignature" }
  ];

  var methodNodeAttributes = [
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.contextid"), attrName: "contextId" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.transactionid"), attrName: "transactionId" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.user"), attrName: "userId" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.domainname"), attrName: "domainName" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.servername"), attrName: "serverName" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.startTime"), attrName: "startTime" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.elapsed"), attrName: "elapsedTime" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.elapsedPercent"), attrName: "elapsedTimePercent" },      
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.scopename"), attrName: "scopeName" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.modulename"), attrName: "moduleName" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.monitorname"), attrName: "monitorName" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.filename"), attrName: "fileName" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.linenumber"), attrName: "lineNumber" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.classname"), attrName: "className" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.methodname"), attrName: "methodName" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.signature"), attrName: "signature" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.contextpayload"), attrName: "contextPayload" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.dyes"), attrName: "dyes" }
  ];

  var methodGapNodeAttributes = [
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.elapsed"), attrName: "elapsedTime" },
    { label: mvc.getMessage(BUNDLE, "req.perf.grid.elapsedPercent"), attrName: "elapsedTimePercent" }
  ];

  function reqPerfFormErrorHandler(errors, reason) {
    var out = mvc.htmlBuilder();
    var self = this;
    var $firstError;
    if (errors) {
      out.markup("<div class='messagesbox' >");
      out.markup("<div class='tbframeContent' >");
      out.markup("<h1 class='messagestitle'>").content("Messages").markup("</h1>");
      out.markup("<div class='message' >");
      out.markup("<img alt='Message icon - Error' src='images/error_status.gif'>");
      out.markup("<span class='message_ERROR'>").content(mvc.getMessage(MVCCORE_BUNDLE, "validation.dialog.messageTitle")).markup("</span>");
      if (reason) {
        out.markup("<p>").content(reason).markup("</p>");
      }
      out.markup("</div>");  
      out.markup("</div>");
      out.markup("</div>");  
      $("#asyncmessages").html(out.toString()).show();
    } else {
      $("#asyncmessages").html("").hide();
    }
  }
  // request perf. should be displaying status messages in the messages portlet.
  function reqPerfReportStatus(xhrStatus, xhrStatusText, messages) {
    var i, m;
    var out = mvc.htmlBuilder();
    var severityToText = null;
    var severityToIcon = null;
    var severityToClass = null;
    var error = "ERROR";

    function addMessage(severity, message, details) {
      out.markup("<li><div>");
      out.markup("<span class='icon ").attr(severityToIcon[severity]).markup("'></span>")
      .markup("<span class='screenReadersOnly'>").content(severityToText[severity]).markup(" </span>");
      out.markup("<span class='").attr(severityToClass[severity]).markup("'>")
      .content(message).markup("</span></div>");
      if (details) {
       out.markup("<div>").content(mvc.getMessage(MVCCORE_BUNDLE, "message.details") + " ")
       .markup("<span class='").attr(severityToClass[severity]).markup("'>")
       .content(details).markup("</span></div>");
      }
     out.markup("</li>");
    }

    if (severityToText === null) {
      severityToText = {
        "FATAL": mvc.getMessage(MVCCORE_BUNDLE, "message.severity.fatal"),
        "ERROR": mvc.getMessage(MVCCORE_BUNDLE, "message.severity.error"),
        "WARNING": mvc.getMessage(MVCCORE_BUNDLE, "message.severity.warning"),
        "SUCCESS": mvc.getMessage(MVCCORE_BUNDLE, "message.severity.confirmation"),
        "NORMAL": mvc.getMessage(MVCCORE_BUNDLE, "message.severity.information")
      };
    }
    if (severityToIcon === null) {
      severityToIcon = {
        "FATAL": "fatal",
        "ERROR": "error",
        "WARNING": "warn",
        "CONFIRMATION": "confirm",
        "INFORMATION": "info"
      };
    }
    if (severityToClass === null) {
      severityToClass = {
        "FATAL": "message_ERROR",
        "ERROR": "message_ERROR",
        "WARNING": "message_WARNING",
        "SUCCESS": "message_SUCCESS",
        "NORMAL": "message_NORMAL"
      };
    }
    //var self = this;
    out.markup("<div class='messagesbox' >");
    out.markup("<div class='tbframeContent' >");
    out.markup("<h1 class='messagestitle'>").content("Messages").markup("</h1>");
    out.markup("<div class='message' >");
    out.markup("<ul class='messageList'>");

    if (xhrStatus === 0 || xhrStatus == 12029) {
      addMessage(error, mvc.getMessage(MVCCORE_BUNDLE, "message.status.connect"));
    } else if (xhrStatus == 404) {
      addMessage(error, mvc.getMessage(MVCCORE_BUNDLE, "message.status.404"));
    } else if (xhrStatus == 500) {
      addMessage(error, mvc.getMessage(MVCCORE_BUNDLE, "message.status.500"));
    } else if (xhrStatus < 200 || xhrStatus > 299) {
      addMessage(error, mvc.format(MVCCORE_BUNDLE, "message.status.other", xhrStatus, xhrStatusText));
    } else {
      if (messages) {
        for (i = 0; i < messages.length; i++) {
          m = messages[i];
          addMessage(m.severity, m.message, m.details);
        }
      }
    }
    out.markup("</ul>");

    out.markup("</div>");
    out.markup("</div>");
    out.markup("</div>");
    $("#asyncmessages").html(out.toString()).show();
  }

  function isInputValid(formHelperddhhmm, formHelperCustom) {
    var timeInterval = $("#reqTimeIntervals").val();
    if(timeInterval==="ddhhmm") {
      return formHelperddhhmm.store(reqPerfDDHHMMObj);
    } else if(timeInterval==="custom") {
      return formHelperCustom.store(reqPerfCustomObj);
    }
    return true;
  }

  function isGapNode(node) {
    var className = node.className;
    var methodName = node.methodName;
    if(className===null && methodName===MISSING_CHILD_NODE) {
      return true;  
    } else {
      return false;
    }    
  }

  function getIntervals() {
    var args = [];
    var timeInterval = $("#reqTimeIntervals").val();

    if(timeInterval==="ddhhmm") {
      var temp = $("#reqInterDuration").val().trim();
      $("#reqInterDuration").val(temp);  
      var data = temp.split(" ");
      var days = 0;
      if(data.length===2) {
        days = data[0];
        temp = data[1];
      }
      // Split the remainder to get HH & MM  
      data = temp.split(":");

      // Converting it to minutes.  
      args[0] = (parseInt(days, 10) * 24 * 60 +
             parseInt(data[0], 10) * 60 +
             parseInt(data[1], 10)) * 60000;
    } else if(timeInterval==="custom") {
      var startDateTime = reqPerfCustomObj.reqInterCustomStart;
      var startDate = (startDateTime.getUTCMonth() + 1) + "/" + startDateTime.getUTCDate() + "/" + startDateTime.getUTCFullYear();
      var startTime = startDateTime.getUTCHours() + ":" + startDateTime.getUTCMinutes();
  
      var duration = $("#reqTimeCustomDuration").val().trim();
      $("#reqTimeCustomDuration").val(duration);
      var durTemp = duration.split(" ");
      var cusDays = 0;
      if(durTemp.length===2) {
        cusDays = durTemp[0].trim();
        duration = durTemp[1].trim();
      }
      // Split the remainder to get HH & MM  
      var ddhh = duration.split(":");
      var durMins = parseInt(cusDays,10) * 24 * 60 +
                parseInt(ddhh[0],10) * 60 +
                parseInt(ddhh[1],10);
      args[0] = durMins * 60000;
      args[1] = startDate;
      args[2] = startTime;// This needs to be converted to ms or mins.
    } else {
      args[0] = timeInterval * 60000;
    }
    return args;  
  }

  function fetchChildNodes(parentNode, server, widgetCallback, showReqNodeDataGrid) {
    var contextId = parentNode.contextId;
    mvc.ajax("GET", childNodeUrl.expand({server: server, diagnosticContextId:contextId}), function(result) {

      var rnodes = result.body.requestInfoTree.rootNodes; // array nodes
      // parent node is level 1. So, the child nodes start at level 2.  
      getChildNodes(rnodes, 2, parentNode);

      // Get the stats nodes.
      parentNode.stats = result.body.requestInfoTree.requestInfoStatisticsData;
      if(widgetCallback) {
        parentNode.childNodesRendered=true;
        widgetCallback(nodes);
      }
      if(showReqNodeDataGrid){
        parentNode.childNodesRendered=false;
        // Now print the data grid.
        showReqNodeDataGrid(parentNode);
      }
    });
  }

  //recursively gets child nodes.  
  function getChildNodes(cNodes, nodeLevel, parentNode) {
    var childNodes = [];//required to set to the parent
    for(var c=0; c<cNodes.length; c++) {
      childNodes[c] = cNodes[c].requestInfo;
      childNodes[c].nodeLevel=nodeLevel;
      childNodes[c].parentNode=parentNode;

      var ccNodes = cNodes[c].childNodes;
      if(ccNodes){
        getChildNodes(ccNodes, ++nodeLevel, childNodes[c]);
      }
    }
    // save the childNodes ref.  
    parentNode.childNodes = childNodes;  
  }

  function loadRequests(server) {

    var args = getIntervals();
    var url1;
    if(args.length===1) {
      url1 = rootNodeUrl1.expand({server:server, duration: args[0]});
    } else if(args.length===3) {
      url1 = rootNodeUrl2.expand({server:server, duration: args[0], startDate:args[1], startTime:args[2]});
    }

    mvc.ajax("GET", url1, function(result) {
      var RequestInfoTree = result.body;
      RequestInfoTree.nodeLevel=0;
      var cNodes = RequestInfoTree.requestInfoTrees;
      var childNodes = [];
      for(var c=0; c<cNodes.length; c++) {
        childNodes[c] = cNodes[c].rootNodes[0].requestInfo;
        childNodes[c].nodeLevel=1;
        childNodes[c].parentNode=RequestInfoTree;  
      }
      RequestInfoTree.childNodes = childNodes;

      var rootNodesCount = RequestInfoTree.childNodes.length;
      if(rootNodesCount===0) {
        $("#selRequestTree").html(mvc.getMessage(BUNDLE, "req.perf.no.requests.found"));
        return;  
      }
      var maxElapsedTime = 0;
      var tempNode;
      for(var i=0; i<rootNodesCount; i++) {
        tempNode = RequestInfoTree.childNodes[i];  
        if(tempNode.elapsedTime>maxElapsedTime) {
          maxElapsedTime = tempNode.elapsedTime;
        }
      }

      $("#selRequestTree").treeView({expandRoot:true,collapsibleRoot:false, nodeAdapter: {
                     root: function () {
                       //return a collection if multiple rootType, else return just one.  
                       return RequestInfoTree;  
                     },
                     child: function(node, i) {
                       return node.childNodes[i];  
                     },
                     hasChildren: function(node) {
                       if(node.nodeLevel===1) {
                         return true;
                       } else {
                         if(node.childNodes && node.childNodes.length>0) {
                           return true;
                         } else {
                           return false;
                         }
                       }
                     },
                     childCount: function(node) {
                       if(node.childNodes) {
                         return node.childNodes.length;
                       } else {
                         return null;//return null, if child data needs to be lazy loaded.
                       }
                     },
                     renderIcon: function(node, out) {
                       var width, innerClass, outerClass, parentNode;
                       if(node.nodeLevel===0) {
                         return;
                       }
                       if(node.nodeLevel===1){  
                         width = ((node.elapsedTime/maxElapsedTime)*50);
                         innerClass = "innerrootbar";
                         outerClass = "outerrootbar";
                       } else {
                         parentNode = node.parentNode;
                         width = ((node.elapsedTime/parentNode.elapsedTime)*50);
                         innerClass = "innerchildbar";
                         outerClass = "outerchildbar";
                       }
                       out.markup("<span class='" + outerClass + "'><span class='" + innerClass + "' style='width:" + width + "px;'></span></span>&nbsp;");
                     },
                     renderLabel: function(node, out) {
                       if(node.nodeLevel===0) {
                         out.content(mvc.getMessage(BUNDLE,"req.perf.tree.root.label"));
                         return;
                       }
                       //Render the node now.
                       var contextId = node.contextId;
                       var className = node.className;
                       var methodName = node.methodName;
                       var scopeName = node.scopeName;
                       var startTime = node.startTime;  

                       if(node.nodeLevel===1){
                         var idx = contextId.lastIndexOf("-");
                         var uniqueId = contextId.substring(idx+1, contextId.length);
                         var stDate = new Date(startTime);  
                         var startDate = mvc.formatDateTime(stDate, { fullYear: true });
                         out.content(uniqueId + "["+scopeName+"] "+ startDate);  
                       } else {
                         if(isGapNode(node)) {
                           out.content(GAP);  
                         } else {
                           out.content(className + " " + methodName );
                         }
                       }
                     },
                     allowRename: function(n) {
                       return false;
                     },
                     allowDelete: function(n) {
                       return false;
                     },
                     fetchChildNodes: function(node, widgetFun) { 
                       // Return an array of nodes.
                       if(node && node.childNodes) {
                         // ChildNodes already exist, return
                         node.childNodesRendered=true;
                         widgetFun(node.childNodes);
                       } else {
                         var nodeLevel = node.nodeLevel;
                         if(nodeLevel==1){
                           fetchChildNodes(node, server, widgetFun, null);
                         } else {
                           widgetFun(null);
                         }
                       }
                     }
                  }
      });
    });
  }

  function getRunningServers(loadRequestData) {
    mvc.ajax("GET", "data/diagnostics/runningServers", function(result) {
      var servers = [], server, i, currentServer;
      var $selServers = $("#reqServers");
      var out = mvc.htmlBuilder();
      out.markup("<select id='reqServers'>");
      if (result) {
        servers = result.body.servers;
      }
      currentServer = $selServers.val();  
      for (i = 0; i < servers.length; i++) {
        server = servers[i];
        if(currentServer===null) {
          // By Default the admin server is the first one, so select it.  
          out.markup("<option value='").attr(server).markup("'").optionalBoolAttr("selected", i === 0).markup(">");  
        } else {
          out.markup("<option value='").attr(server).markup("'").optionalBoolAttr("selected", server === currentServer).markup(">");
        }
        out.content(server).markup("</option>");
      }
      out.markup("</select>");
      // Replace the select markup that is in the html file.  
      $selServers.replaceWith(out.toString());
      var cServer = $("#reqServers").val();
      if(loadRequestData && cServer.trim().length>0) {
        // now load the requests          
        loadRequests(cServer);
      }
    });
  }

  function displayTimeIntervals() {
    // Display the Time Interval select options
    var $selInterval = $("#reqTimeIntervals");
    var currentInterval = "5";
    var out = mvc.htmlBuilder();
    var item;
    for (var i = 0; i < timeIntervals.length; i++) {
      item = timeIntervals[i];
      if(item){
        out.markup("<option value='").attr(item.value).markup("'").optionalBoolAttr("selected", item.value === currentInterval).markup(">");  
        out.content(item.label).markup("</option>");
      }
    }
    $selInterval.html(out.toString());

    $("#reqTimeInterDuration").hide();
    $("#reqTimeInterCustom").hide();
  }

  function showReqNodeNoteTable(node) {
    var out = mvc.htmlBuilder();
    out.markup("<table summary='"+ mvc.getMessage(BUNDLE, "req.perf.note.table.summary") +"' class='datatable'>");
    //Now loop thru the attribute & values :
    for (var i = 0; i < reqNodeNoteAttributes.length; i++) {
      if(reqNodeNoteAttributes[i]){
        out.markup("<tr class='rowEven'><td>").content(reqNodeNoteAttributes[i].label);
        out.markup("</td><td>");
        if(reqNodeNoteAttributes[i].attrName==="elapsedTime") {
          out.content(node[reqNodeNoteAttributes[i].attrName]/NS_TO_MS);
        } else {
          out.content(node[reqNodeNoteAttributes[i].attrName]);
        }
        out.markup("</td></tr>");
      }
    }
    out.markup("</table>");
    $("#requestNoteData").html(out.toString());
  }

  function writeReqNodeDataGrid(statsArray, sortAttr, sortDir) {
    var out = mvc.htmlBuilder();
    out.markup("<table summary='"+ mvc.getMessage(BUNDLE, "req.perf.table.summary") +"' class='datatable'><tr class='headerRow'>");
    // display header row
    for (var j = 0; j < reqNodeAttributes.length; j++) {
      if(reqNodeAttributes[j]){
        if(reqNodeAttributes[j].attrName===sortAttr) {
          out.markup("<th class='sortable "+ sortDir + "' id='"+ reqNodeAttributes[j].attrName +"' >").
                  content(reqNodeAttributes[j].label).markup("</th>");
        } else {
          out.markup("<th class='sortable sortasc' id='" + reqNodeAttributes[j].attrName +"' >").
                  content(reqNodeAttributes[j].label).markup("</th>");
        }
      }
    }
    out.markup("</tr>");
    //Now Data
    var statsNode, flag=0;
    for(var d=0; d<statsArray.length; d++) {
      statsNode = statsArray[d];
      if(flag === 0){
        out.markup("<tr class='rowEven' >");
        flag=1;
      } else {
        out.markup("<tr class='rowOdd' >");
        flag=0;
      }
      for (var i = 0; i < reqNodeAttributes.length; i++) {
        if(reqNodeAttributes[i]){
          out.markup("<td>");
          out.content(statsNode[reqNodeAttributes[i].attrName]);
          out.markup("</td>");
        }
      }
      out.markup("</tr>");
    }
    out.markup("</table>");
    $("#requestData").html(out.toString());

    $("#requestData .datatable .sortable").click(function() {
      sortTable(statsArray, $(this));
    });

    $("#requestData .datatable .sortable").hover(
            function() {
              if($(this).is(".sortasc")) {
                $(this).addClass(SORT_ASC_ICON);
              } else if($(this).is(".sortdesc")){
                $(this).addClass(SORT_DESC_ICON);
              } else {
                $(this).addClass(SORT_ASC_ICON);
              }
            } ,
            function() {
              $(this).removeClass(SORT_ASC_ICON).removeClass(SORT_DESC_ICON);
            }
    );
  }

  function sortTable(statsArray, $ctrl) {
    var sortAttr = $ctrl.attr("id");
    var sortDir="sortasc"; //default value

    if($ctrl.is(".sortdesc")) {
      statsArray.sort(function (node1, node2) {
        var sa = node1[sortAttr], sb = node2[sortAttr];
        //Sort descending
        return sb > sa ? 1 : sb < sa ? -1 : 0;
      });
      // already sorted, now toggle the class
      sortDir = "sortasc";
    } else {
      statsArray.sort(function (node1, node2) {
        var sa = node1[sortAttr], sb = node2[sortAttr];
        //Sort ascending
        return sa > sb ? 1 : sa < sb ? -1 : 0;
      });
      // already sorted, now toggle the class
      sortDir = "sortdesc";
    }
    //rewrite the table.
    writeReqNodeDataGrid(statsArray, sortAttr, sortDir);
  }

  function showReqNodeDataGrid(fNode) {
    var out = mvc.htmlBuilder();
    var statsArray = fNode.stats;
    //Display the note table
    showReqNodeNoteTable(fNode);

    //Do not display the table, if this is a gap node.
    if(isGapNode(fNode)) {
      $("#requestData").html(""); // get rid of the fetching data text
      return;
    }
    //Now Data
    var statsNode;
    if(!fNode.statsMassaged || fNode.statsMassaged!==true) {
      for(var d=0; d<statsArray.length; d++) {
        statsNode = statsArray[d];
        for (var i = 0; i < reqNodeAttributes.length; i++) {
          if(reqNodeAttributes[i]){
            out.markup("<td>");
            if(reqNodeAttributes[i].attrName==="totalElapsedTime"){
              var totalElapsedTime = parseInt(statsNode.totalElapsedTime,10);
              statsNode[reqNodeAttributes[i].attrName] = (totalElapsedTime/NS_TO_MS);  
            } else if(reqNodeAttributes[i].attrName==="averageTime"){
              var count = statsNode.invocationCount;
              var average = (statsNode.totalElapsedTime)/count;
              statsNode[reqNodeAttributes[i].attrName] = average;
            } else if(reqNodeAttributes[i].attrName==="moduleName"){
              statsNode[reqNodeAttributes[i].attrName] = fNode[reqNodeAttributes[i].attrName];
            } else if(reqNodeAttributes[i].attrName==="methodSignature") {
              statsNode[reqNodeAttributes[i].attrName] = getFormattedMethodSignature(statsNode.methodName, statsNode[reqNodeAttributes[i].attrName]);
            }
          }
        }
      }
      fNode.statsMassaged = true; // Don't have to repeat massaging the stats.
    }

    // Sort the data by className by default.  
    var defaultSortAttr = "className";
    statsArray.sort(function (node1, node2) {
      var sa = node1[defaultSortAttr], sb = node2[defaultSortAttr];
      //Sort ascending
      return sa > sb ? 1 : sa < sb ? -1 : 0;
    });

    //Write the table.  
    writeReqNodeDataGrid(statsArray, defaultSortAttr, "sortdesc");
  }

  //show Child-Node DataGrid
  function showMethodNodeDataGrid(fNode) {
    // There is no Note data table for method nodes.  
    $("#requestNoteData").html("");

    var out = mvc.htmlBuilder();
    out.markup("<table summary='"+mvc.getMessage(BUNDLE, "req.perf.grid.summary")+"' class='datatable'><tr class='headerRow'>");
    out.markup("<th>").content(mvc.getMessage(BUNDLE, "req.perf.grid.attribute")).markup("</th>").
        markup("<th>").content(mvc.getMessage(BUNDLE, "req.perf.grid.value")).markup("</th>");
    out.markup("</tr>");
    //Now loop thru the attribute & values :
    var flag=0,value;  
    for (var i = 0; i < methodNodeAttributes.length; i++) {
      if(methodNodeAttributes[i]){
        if(isGapNode(fNode)) {
          if(methodNodeAttributes[i].attrName!=="elapsedTime" && methodNodeAttributes[i].attrName!=="elapsedTimePercent" ) {
            continue;
          }
        }
        if(flag === 0){
          out.markup("<tr class='rowEven' >");
          flag=1;
        } else {
          out.markup("<tr class='rowOdd' >");
          flag=0;
        }
        out.markup("<td>").content(methodNodeAttributes[i].label);
        out.markup("</td><td>");
        if(methodNodeAttributes[i].attrName==="elapsedTime") {
          out.content(fNode.elapsedTime/NS_TO_MS);
        } else if (methodNodeAttributes[i].attrName==="elapsedTimePercent") {
          var elapsedTime = ((fNode.elapsedTime/fNode.parentNode.elapsedTime)*100);
          var elapsedTimeStr = elapsedTime + "%";
          out.content(elapsedTimeStr);
        } else if (methodNodeAttributes[i].attrName==="signature") {
          out.content(getFormattedMethodSignature(fNode.methodName, fNode[methodNodeAttributes[i].attrName]));  
        } else {
          value = fNode[methodNodeAttributes[i].attrName];
          // display empty string if the value is null.  
          if(value===null){
            out.content("");
          } else {
            out.content(value);
          }
        }
        out.markup("</td></tr>");
      }
    }
    $("#requestData").html(out.toString());
  }

  function displayDataGrid(nodes) {
    //Single selection tree view, the array size is going to be 1.
    var fNode = nodes[0];
    $("#requestNoteData").html("");
    $("#requestData").html("");
    if(!fNode || fNode.nodeLevel===0) {
      return false;
    }
    $("#requestData").html(mvc.getMessage(BUNDLE, "req.perf.grid.fetching.data"));
    var out = mvc.htmlBuilder();
    if(fNode.nodeLevel===1) {
      if(fNode.childNodes) {
        showReqNodeDataGrid(fNode);
      } else {
        fetchChildNodes(fNode, $("#reqServers").val(), null, showReqNodeDataGrid);
      }
    } else {
      showMethodNodeDataGrid(fNode);
    }
  }

  // Do stuff when the browser loads.
  $(document).ready(function() {
    mvc.ajaxOptions({
      processing: function(busy) {
        $("#pageStatus").toggleClass("busy", busy);
        $("body").css("cursor", busy ? "wait" : "auto");
      },
      reportStatus: reqPerfReportStatus,
      sessionExpired: function (){
        window.location.reload();
      }
    });

    // localize static content
    document.title = mvc.getMessage(BUNDLE, "request.performance.title");
    $("a.dol10n, span.dol10n, button.dol10n").each(function() {
      var key = $(this).html();
      if (key && key.indexOf("<") == -1) {
        $(this).html(mvc.getMessage(BUNDLE, key)).removeClass("dol10n");
      }
      key = $(this).attr("title");
      if (key) {
        $(this).attr("title", mvc.getMessage(BUNDLE, key));
      }
    });
    $("label.dol10n").each(function() {
      var key = $(this).html();
      $(this).html(mvc.getMessage(BUNDLE, key) + ":").removeClass("dol10n");
      key = $(this).attr("title");
      if (key) {
        $(this).attr("title", mvc.getMessage(BUNDLE, key));
      }
    });
    $("option.dol10n").each(function() {
      var key = $(this).html();
      $(this).html(mvc.getMessage(BUNDLE, key)).removeClass("dol10n");
    });
    $("img.dol10n").each(function() {
      var key = $(this).attr("alt");
      $(this).attr("alt", mvc.getMessage(BUNDLE, key) + " ").removeClass("dol10n");
    });
    // Display the time intervals select tag
    displayTimeIntervals();
    // Display the running servers and req. per. tree.
    getRunningServers(true);

    var formHelperddhhmm = mvc.formHelper(reqPerfDDHHMMFields, { formErrorHandler: reqPerfFormErrorHandler});
    formHelperddhhmm.load(reqPerfDDHHMMObj);
    var formHelperCustom = mvc.formHelper(reqPerfCustomFields, { formErrorHandler: reqPerfFormErrorHandler});
    formHelperCustom.load(reqPerfCustomObj);

    mvc.ajax("GET", "data/diagnostics/toolbar", function(result) {
      var out = mvc.htmlBuilder();
      if (result) {
        mvc.setLocaleSettings(result.body.localeSettings);
        $("#reqInterCustomStartFormat").text(mvc.getDateTimeDisplayFormat());
      }
    });

    $("#refresh").click(function() {
      if(isInputValid(formHelperddhhmm, formHelperCustom)) {
        $("#selRequestTree").treeView("destroy");
        $("#requestNoteData").html("");  
        $("#requestData").html("");
        $("#selRequestTree").html(mvc.getMessage(BUNDLE, "req.perf.refreshing.requests"));
        loadRequests($("#reqServers").val());
      }
    });
    $("#reload").click(function() {
      getRunningServers(false);
    });

    $("#reqTimeIntervals").change(function() {
      var src = $("option:selected", this).val();  
      if(src==="ddhhmm") {
        //reset reqTimeInterCustom  
        $("#intervalFields").attr("class", 'intervalFieldsShown');
        $("#reqTimeInterCustom").hide();
        $("#reqTimeInterDuration").css({ display:'inline' });
      } else if(src==="custom") {
        //reset reqTimeInterDuration
        $("#intervalFields").attr("class", 'intervalFieldsShown');
        $("#reqTimeInterDuration").hide();
        $("#reqTimeInterCustom").css({ display:'inline' });  
      } else {
        $("#intervalFields").attr("class", 'intervalFieldsHidden');  
        $("#reqTimeInterDuration").hide();
        $("#reqTimeInterCustom").hide();
      }
    });


    $("#selRequestTree").bind("treeViewchange", function() {
      // Display the table
      var nodes = $("#selRequestTree").treeView("selectionNodes");
      displayDataGrid(nodes);
    });

  });

})(jQuery);