/*!
  Method signature util
  Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
*/
/*global window */
(function() {
    
  function parseArgTypes(argSignature) {
    var len = argSignature.length;
    var dims = 0;
    var addComma = false;
    var buf=""; // string buffer  

    for (var index=0; index < len; index++) {
      var ch = argSignature.charAt(index);
      var type = null;

      switch(ch) {
      case '[':
        dims++;
        break;

      case 'L':
        var start = index+1;
        index = argSignature.indexOf(";", start);
        type = argSignature.substring(start, index).replace(/\//g,".");
              
        break;

      case 'B':
        type = "byte";
        break;

      case 'C':
        type = "char";
        break;

      case 'D':
        type = "double";
        break;

      case 'F':
        type = "float";
        break;

      case 'I':
        type = "int";
        break;

      case 'J':
        type = "long";
        break;

      case 'S':
        type = "short";
        break;

      case 'Z':
        type = "boolean";
        break;

      case 'V':
        type = "void";
        break;
      }

      if (type !== null) {
        if (addComma) {
          buf = buf + ", ";
        }
        buf=buf + type;
        for (var i=0; i < dims; i++) {
          buf = buf + "[]";
        }
        dims = 0;
        addComma = true;
      }
    }

    return buf;
  }

  function getArgumentTypes(signature) {
    if(!signature) {
      return "";
    }
    // Method Signature (Ljava/lang/String;JJ)[Lcom/bea/diagnostics/common/RequestInfo;
    var rparenIndex = signature.indexOf(')');
    var argSignature = signature.substring(1, rparenIndex);
    return "(" + parseArgTypes(argSignature) + ")";
  }

  function getReturnType(signature) {
    if(!signature) {
      return "";
    }
    var rparenIndex = signature.indexOf(')');
    var retSignature = signature.substring(rparenIndex+1);
    return parseArgTypes(retSignature);
  }

  // Invoke this method passing in the method name and the java method signature.
  // this is the only public function here. All others are private  
  window.getFormattedMethodSignature = function (methodName, signature) {
    return getReturnType(signature) + " " + methodName + getArgumentTypes(signature);
  };

})();