/*!
  Flot plugin for adjusting the data before ploting bar charts 
  Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
*/
/*
  When a set of data series all have corresponding samples taken for the same X value
  then the bar charts are all on top of one another. This plugin shifts the X data points
  so that each bar can be seen. 

  To use this plugin set series.bars.adjustX to true and add order property to each series. The order
  determines the order left to right that the bar is shown in. The order is a number that ranges from 
  0 to the N-1 where N is the number of series.

  It is best to set the bars.lineWidth to 0. Set the bars.barWidth such that the X samples don't overlap.
*/
/*global jQuery*/
(function ($) {
  var options = {
    series: {
      bars: {
        adjustX: false
      }
    }
  };

  function processDatapoints(plot, series, datapoints) {
    var points;
    var ps, i, offset;

    if (series.bars.adjustX && typeof series.order == "number") {
      points = datapoints.points;
      ps = datapoints.pointsize;
      offset = series.bars.barWidth * series.order - plot.getData().length * series.bars.barWidth;
      for (i = 0; i < points.length; i += ps) {
        points[i] += offset;
      }
    }
  }

  function init(plot) {
    plot.hooks.processDatapoints.push(processDatapoints);
  }

  $.plot.plugins.push({
    init: init,
    options: options,
    name: 'timebars',
    version: '1.0'
  });
})(jQuery);
