<!--
    The titlebar skeleton file renders a HTML <div> element for the titlebar. 
    This <div> element contains up to three additional <div> elements 
    corresponding to the window icon, window title and window buttons.
-->
<jsp:root version="2.0" 
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:c="http://java.sun.com/jsp/jstl/core"
    xmlns:html="http://struts.apache.org/tags-html"
    xmlns:skeleton="http://www.bea.com/servers/portal/tags/netuix/skeleton"
>
    <jsp:directive.page session="false" />
    <jsp:directive.page isELIgnored="false" />

    <!--  Console specific begin -->
    <jsp:directive.page import="com.bea.netuix.servlets.controls.window.TitlebarPresentationContext" />
    <jsp:directive.page import="com.bea.netuix.servlets.controls.window.WindowPresentationContext" />
    <jsp:directive.page import="com.bea.netuix.servlets.controls.page.PagePresentationContext" />
    <!--  Console specific end -->

    <skeleton:context type="titlebarpc">
        <skeleton:control name="div" presentationContext="${titlebarpc}"
            presentationClass="wlsc-titlebar"
        >
          <div class="float-container">
            <!-- Window icon (contained within a <DIV> element) -->
            <c:if test="${not empty titlebarpc.iconUrl}">
                <div class="wlsc-titlebar-window-icon">
                    <html:img src="${titlebarpc.iconUrl}" alt=""/>
                    <!-- Ensures that the height of window-icon is equal to the height of title-panel -->
                    <jsp:text>&amp;#160;</jsp:text>
                </div>
            </c:if>
            <!--  Console specific begin -->
            <jsp:scriptlet>
                  <![CDATA[
                  // find out if this title bar is somewhere under a book/page with
                  // presentationId "console-content-area".
                  TitlebarPresentationContext titlebar = (TitlebarPresentationContext)titlebarpc;
                  WindowPresentationContext winpc = titlebar.getParentWindowPresentationContext();
                  PagePresentationContext curpagepc = winpc.getParentPagePresentationContext();
                  boolean isInContentArea = false;
                  while (curpagepc != null) {
                    String id = curpagepc.getPresentationId();
                    if (id != null && id.equals("console-content-area")) {
                      isInContentArea = true;
                      break;
                    }
                    curpagepc = curpagepc.getParentPagePresentationContext();
                  }
                  ]]>
            </jsp:scriptlet>
            <c:set var="isInContentArea" scope="page"><jsp:expression>isInContentArea</jsp:expression></c:set>
            <!--  Console specific end -->

            <!-- Window title (contained within a <DIV> element) -->
            <div class="wlsc-titlebar-title-panel">
                <!--  Console specific begin -->
                <c:choose>
                <c:when test="${isInContentArea}">
                  <h1><jsp:text>${titlebarpc.parentWindowPresentationContext.title}</jsp:text></h1>
                </c:when>
                <c:otherwise>
                  <h2><jsp:text>${titlebarpc.parentWindowPresentationContext.title}</jsp:text></h2>
                </c:otherwise>
                </c:choose>
                <!--  Console specific end -->
            </div>
            <!-- Window buttons (contained within a <DIV> element) -->
            <div class="wlsc-titlebar-button-panel">
                <!-- Ensures that the height of button-panel is equal to the height of title-panel -->
                <jsp:text>&amp;#160;</jsp:text>
                <c:forEach items="${titlebarpc.buttons}" var="button">
                    <skeleton:child presentationContext="${button}"/>
                </c:forEach>
            </div>
          </div>
        </skeleton:control>
    </skeleton:context>
</jsp:root>