<!--
    The page skeleton file renders a HTML <div> element for the page. 
    The <div> element contains all the children of the page including 
    layouts, portlets, etc.

    Console specific behavior:
    If the user preference to display definition labels is true then
    extra markup is added to show the definition labels in the UI. This 
    is intended to help console extension developers locate extension points.
-->
<jsp:root version="2.0" 
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:c="http://java.sun.com/jsp/jstl/core"
    xmlns:skeleton="http://www.bea.com/servers/portal/tags/netuix/skeleton"
>
    <jsp:directive.page session="false" />
    <jsp:directive.page isELIgnored="false" />
    <jsp:directive.page import="com.bea.console.utils.PortalUtils" />
    <skeleton:context type="pagepc">
        <!--  Console specific begin -->
        <c:set var="includeDefinitionLables" scope="page">
          <jsp:expression>PortalUtils.getDisplayDefinitionLabelsPreference(request)</jsp:expression>
        </c:set>
        <c:if test="${includeDefinitionLables}">
          <c:if test="${pagepc.parentBookPresentationContext.menuPresentationContext != null}">
            <div class="devLabelInfo">
              <p>Page: ${pagepc.definitionLabel}</p>
            </div>
          </c:if>
        </c:if>
        <!--  Console specific end -->
        <skeleton:control name="div" presentationContext="${pagepc}"
            presentationClass="wlsc-page" presentationId="${pagepc.label}"
        >
            <skeleton:children/>
        </skeleton:control>
    </skeleton:context>
</jsp:root>
