<!--
    The header skeleton file renders a HTML <div> element for the header.  
    The children are custom Console markup
-->
<jsp:root version="2.0" 
    xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:skeleton="http://www.bea.com/servers/portal/tags/netuix/skeleton"
    xmlns:c="http://java.sun.com/jsp/jstl/core"
    xmlns:fn="http://java.sun.com/jsp/jstl/functions"
    xmlns:wl="/WEB-INF/console-html.tld"
    xmlns:html="http://struts.apache.org/tags-html"
    xmlns:render="http://www.bea.com/servers/portal/tags/netuix/render"
    xmlns:fmt="http://java.sun.com/jsp/jstl/fmt">
	<jsp:directive.page session="false" />
	<jsp:directive.page isELIgnored="false" />

	<wl:setBundle basename="global" var="current_bundle" scope="page" />

	<skeleton:context type="headerpc">
		<skeleton:control name="div" presentationContext="${headerpc}"
			presentationClass="wlsc-header">
			<div id="console-header-logo">
        <!-- Section 508: Skip repetitive links -->
				<a id="skip-link" href="#mainContentStart"><fmt:message key="sec508.skiplinks" bundle="${current_bundle}"/></a>
        <fmt:message key='logo.alt' bundle="${current_bundle}" var="logoAlt" scope="page"/>
        <div>
          <html:img StyleId="logo" src="framework/skins/EXTENSIONNAME/images/OracleLogo.png" alt="${logoAlt} " />
          <c:choose>
            <c:when test="${not fn:contains(headerpc.presentationClass, 'no-nav')}">
              <render:pageUrl forcedAmpForm='true' pageLabel='HomePage1' var="homeURL" scope="page"/>
              <fmt:message key='toolbar.home' bundle="${current_bundle}" var="homeTitle" scope="page"/>
              <a id="console-title" href="${homeURL}" title="${homeTitle}">
                <span id="product-brand-name"><fmt:message key='product.brand.name' bundle="${current_bundle}"/></span>
                <span id="product-name"><fmt:message key='product.name' bundle="${current_bundle}"/></span>
              </a>
            </c:when>
            <c:otherwise>
              <span id="product-brand-name"><fmt:message key='product.brand.name' bundle="${current_bundle}"/></span>
              <span id="product-name"><fmt:message key='product.name' bundle="${current_bundle}"/></span>
            </c:otherwise>
          </c:choose>
        </div>
		  </div>
      <div id="global-links">
        <fmt:message key="page.status.idle" bundle="${current_bundle}"
          var="statusIdle" scope="page" />
        <fmt:message key="page.status.busy" bundle="${current_bundle}"
          var="statusBusy" scope="page" />
        <span id="pageStatus">
          <html:img styleId="pageIdle" alt="${statusIdle}" title="${statusIdle}" src="framework/skins/EXTENSIONNAME/images/pageIdle.gif"/>
          <html:img styleId="pageBusy" alt="${statusBusy}" title="${statusBusy}" src="framework/skins/EXTENSIONNAME/images/pageBusy.gif"/>
        </span>
      </div>
      <div id="header-trans">
        <html:img alt="" src="framework/skins/EXTENSIONNAME/images/gradient-white-none.png"/>
      </div>
		</skeleton:control>
	</skeleton:context>
</jsp:root>
