<%@ page language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://beehive.apache.org/netui/tags-template-1.0" prefix="beehive-template"%>
<%@ taglib uri="/WEB-INF/console-html.tld" prefix="wl"%>

<wl:setBundle basename="global" var="current_bundle" scope="page" />
<beehive-template:template templatePage="/layouts/standalone_layout.jsp">

  <beehive-template:section name="headMeta"/>

  <beehive-template:section name="headTitle">
    <fmt:message key="window.404title" bundle="${current_bundle}"/>
  </beehive-template:section>

  <beehive-template:section name="headExtra"/>

  <beehive-template:section name="titlebarText">
    <fmt:message key="console.404titlebar" bundle="${current_bundle}"/>
  </beehive-template:section>

  <beehive-template:section name="content">
    <div class="message-row">
        <p><fmt:message key="console.404.notfound" bundle="${current_bundle}"/></p>

        <p><fmt:message key='home.breadcrumb' bundle='${current_bundle}' var="homePage" scope="page"/>
          <c:set var="contextPath" scope="page"><jsp:expression>request.getContextPath()</jsp:expression></c:set>
          <fmt:message key="console.404.options" bundle="${current_bundle}">
            <fmt:param value="<a href='${contextPath}/console.portal'>${homePage}</a>"/>
          </fmt:message>
        </p>
    </div>
  </beehive-template:section>

</beehive-template:template>
