/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider.ec;

import com.rsa.cryptoj.c.pi;
import com.rsa.jsafe.provider.ec.ECPoint;
import com.rsa.jsafe.provider.ec.EllipticCurve;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public class ECParameterSpec
implements AlgorithmParameterSpec {
    private final EllipticCurve a;
    private final ECPoint b;
    private final BigInteger c;
    private final int d;

    public ECParameterSpec(EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, int n2) {
        pi.d();
        if (ellipticCurve == null) {
            throw new NullPointerException("The elliptic curve, curve, is null.");
        }
        if (eCPoint == null) {
            throw new NullPointerException("The base point, g, is null.");
        }
        if (bigInteger == null) {
            throw new NullPointerException("The order, n, is null.");
        }
        if (bigInteger.signum() != 1) {
            throw new IllegalArgumentException("The order, n, is not positive.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("The cofactor, h, is not positive.");
        }
        this.a = ellipticCurve;
        this.b = eCPoint;
        this.c = bigInteger;
        this.d = n2;
    }

    public EllipticCurve getCurve() {
        return this.a;
    }

    public ECPoint getGenerator() {
        return this.b;
    }

    public BigInteger getOrder() {
        return this.c;
    }

    public int getCofactor() {
        return this.d;
    }
}

