/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider.ec;

import com.rsa.cryptoj.c.pi;
import com.rsa.jsafe.provider.ec.ECField;
import java.math.BigInteger;
import java.util.Arrays;

public class ECFieldF2m
implements ECField {
    private int a;
    private int[] b;
    private BigInteger c;

    public ECFieldF2m(int n2) {
        pi.d();
        if (n2 <= 0) {
            throw new IllegalArgumentException("Degree, m, is not positive.");
        }
        this.a = n2;
        this.b = null;
        this.c = null;
    }

    public ECFieldF2m(int n2, BigInteger bigInteger) {
        pi.d();
        if (n2 <= 0) {
            throw new IllegalArgumentException("Degree, m, is not positive.");
        }
        int n3 = bigInteger.bitCount();
        if (!bigInteger.testBit(0) || !bigInteger.testBit(n2) || n3 != 3 && n3 != 5) {
            throw new IllegalArgumentException("Invalid reduction polynomial, rp, does not represent a valid reduction polynomial.");
        }
        this.a = n2;
        this.c = bigInteger;
        BigInteger bigInteger2 = this.c.clearBit(0).clearBit(n2);
        this.b = new int[n3 - 2];
        for (int i2 = this.b.length - 1; i2 >= 0; --i2) {
            int n4;
            this.b[i2] = n4 = bigInteger2.getLowestSetBit();
            bigInteger2 = bigInteger2.clearBit(n4);
        }
    }

    public ECFieldF2m(int n2, int[] nArray) {
        int n3;
        pi.d();
        if (n2 <= 0) {
            throw new IllegalArgumentException("Degree, m, is not positive.");
        }
        if (nArray.length != 1 && nArray.length != 3) {
            throw new IllegalArgumentException("Invalid middle terms, length must be 1 or 3.");
        }
        this.a = n2;
        this.b = (int[])nArray.clone();
        for (n3 = 0; n3 < this.b.length; ++n3) {
            if (this.b[n3] < 1 || this.b[n3] > n2 - 1) {
                throw new IllegalArgumentException("Middle term, ks[" + n3 + "], is out of range.");
            }
            if (n3 == 0 || this.b[n3] < this.b[n3 - 1]) continue;
            throw new IllegalArgumentException("Middle terms, ks, are not in descending order.");
        }
        this.c = BigInteger.ONE;
        this.c = this.c.setBit(n2);
        for (n3 = 0; n3 < this.b.length; ++n3) {
            this.c = this.c.setBit(this.b[n3]);
        }
    }

    public int getFieldSize() {
        return this.a;
    }

    public int getM() {
        return this.a;
    }

    public BigInteger getReductionPolynomial() {
        return this.c;
    }

    public int[] getMidTermsOfReductionPolynomial() {
        return this.b != null ? (int[])this.b.clone() : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ECFieldF2m)) {
            return false;
        }
        ECFieldF2m eCFieldF2m = (ECFieldF2m)object;
        return this.a == eCFieldF2m.a && Arrays.equals(this.b, eCFieldF2m.b);
    }

    public int hashCode() {
        int n2 = this.a * 31;
        return n2 ^= this.c == null ? 0 : this.c.hashCode();
    }
}

