/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider;

import com.rsa.cryptoj.c.dJ;
import com.rsa.cryptoj.c.fB;
import com.rsa.cryptoj.c.fH;
import com.rsa.cryptoj.c.fN;
import com.rsa.cryptoj.c.fW;
import com.rsa.cryptoj.c.lK;
import com.rsa.cryptoj.c.nf;
import com.rsa.cryptoj.c.oO;
import com.rsa.cryptoj.c.pi;
import com.rsa.cryptoj.c.qC;
import com.rsa.cryptoj.c.u;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.X942DHParameterSpec;
import com.rsa.jsafe.security.spec.DSADomainParameterGenerationSpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.SecureRandom;

public final class Assurance {
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final int VERSION_FIPS186_2 = 2;
    public static final int VERSION_FIPS186_3 = 3;

    private Assurance() {
    }

    public static boolean isValidPublicKey(PublicKey publicKey) throws InvalidKeyException {
        return Assurance.isValidPublicKey(publicKey, null, null);
    }

    public static boolean isValidPublicKey(PublicKey publicKey, SecureRandom secureRandom, FIPS140Context fIPS140Context) throws InvalidKeyException {
        pi.d();
        fN fN2 = fIPS140Context == null ? oO.a() : fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue());
        dJ dJ2 = fH.b(publicKey.getAlgorithm(), publicKey, fN2);
        fB fB2 = secureRandom == null ? lK.a() : fW.a(secureRandom, fN2);
        return nf.a(dJ2, fB2);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, null, null);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        boolean bl2;
        pi.d();
        if (string == null || dSADomainParameterGenerationSpec == null) {
            throw new InvalidParameterException("The digest name and parameter spec cannot be null");
        }
        if (string.equals(DIGEST_SHA1) && (bl2 = Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, 2, secureRandom, fIPS140Context))) {
            return bl2;
        }
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, 3, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        fB fB2;
        pi.d();
        if (string == null || dSADomainParameterGenerationSpec == null) {
            throw new InvalidParameterException("The digest name and parameter spec cannot be null");
        }
        byte[] byArray = u.a(dSADomainParameterGenerationSpec.getG());
        byte[] byArray2 = u.a(dSADomainParameterGenerationSpec.getP());
        byte[] byArray3 = u.a(dSADomainParameterGenerationSpec.getQ());
        byte[] byArray4 = dSADomainParameterGenerationSpec.getSeedBytes();
        if (byArray4 == null || byArray == null || byArray3 == null || byArray2 == null) {
            throw new InvalidParameterException("The seed, primeP, primeQ, baseG are required in the DSADomainParameterGenerationSpec.");
        }
        int n3 = dSADomainParameterGenerationSpec.getCounter();
        fN fN2 = fIPS140Context == null ? oO.a() : fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue());
        fB fB3 = fB2 = secureRandom == null ? lK.a() : fW.a(secureRandom, fN2);
        if (n2 == 2) {
            return qC.a(byArray4, byArray2, byArray3, byArray, string, n3, true, fB2, fN2);
        }
        if (n2 == 3) {
            return qC.a(byArray4, byArray2, byArray3, byArray, string, n3, false, fB2, fN2);
        }
        throw new InvalidParameterException("Version has to be VERSION_FIPS186_2 (=2) or VERSION_FIPS186_3 (=3)");
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, n2, null, null);
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        pi.d();
        if (x942DHParameterSpec == null) {
            throw new InvalidParameterException("An X942DHParameter spec must be specified");
        }
        byte[] byArray = x942DHParameterSpec.getSeed();
        byte[] byArray2 = u.a(x942DHParameterSpec.getP());
        byte[] byArray3 = u.a(x942DHParameterSpec.getQ());
        byte[] byArray4 = u.a(x942DHParameterSpec.getG());
        BigInteger bigInteger = x942DHParameterSpec.getPGenCounter();
        if (bigInteger == null) {
            throw new InvalidParameterException("The counter must be specified");
        }
        int n2 = bigInteger.intValue();
        if (byArray == null || byArray2 == null || byArray3 == null || byArray4 == null) {
            throw new InvalidParameterException("The seed, primeP, primeQ, baseG and the expected counter value is required.");
        }
        fN fN2 = fIPS140Context == null ? oO.a() : fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue());
        fB fB2 = secureRandom == null ? lK.a() : fW.a(secureRandom, fN2);
        return qC.a(byArray, byArray2, byArray3, n2, byArray4, fB2, fN2);
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec) {
        return Assurance.verifyX942DHParams(x942DHParameterSpec, null, null);
    }
}

