/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crl;

import com.rsa.cryptoj.c.iQ;
import com.rsa.cryptoj.c.pi;
import com.rsa.jsafe.cert.Version;
import com.rsa.jsafe.crl.RevokedCertificate;
import com.rsa.jsafe.crl.X509CRLExtensionSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLCreationParameterSpec
implements Cloneable {
    private Date a;
    private Date b;
    private List<RevokedCertificate> c;
    private X509CRLExtensionSpec d;
    private Version e = Version.V2;

    public CRLCreationParameterSpec() {
        pi.d();
    }

    public void setVersion(Version version) {
        if (version == null) {
            throw new IllegalArgumentException("Version number is null");
        }
        this.e = version;
    }

    public void setThisDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The issue date is null");
        }
        this.a = new Date(date.getTime());
    }

    public void setNextUpdate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Next update date is null");
        }
        this.b = new Date(date.getTime());
    }

    public void setRevokedCertificates(List<RevokedCertificate> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("Revoked certificates is null or contains null elements");
        }
        ArrayList<RevokedCertificate> arrayList = new ArrayList<RevokedCertificate>(list);
        Collections.sort(arrayList);
        this.c = Collections.unmodifiableList(arrayList);
    }

    public void setExtensions(X509CRLExtensionSpec x509CRLExtensionSpec) {
        if (x509CRLExtensionSpec == null) {
            throw new IllegalArgumentException("Extension is null");
        }
        this.d = (X509CRLExtensionSpec)x509CRLExtensionSpec.clone();
    }

    public Version getVersion() {
        return this.e;
    }

    public Date getThisDate() {
        return this.a == null ? null : new Date(this.a.getTime());
    }

    public Date getNextUpdate() {
        return this.b == null ? null : new Date(this.b.getTime());
    }

    public List<RevokedCertificate> getRevokedCertificates() {
        return this.c;
    }

    public X509CRLExtensionSpec getExtensions() {
        return this.d == null ? null : (X509CRLExtensionSpec)this.d.clone();
    }

    public Object clone() {
        CRLCreationParameterSpec cRLCreationParameterSpec;
        try {
            cRLCreationParameterSpec = (CRLCreationParameterSpec)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone could not be created", cloneNotSupportedException);
        }
        return cRLCreationParameterSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRL Creation Parameter Spec [").append(iQ.a);
        if (this.e != null) {
            stringBuffer.append("   ").append("Version Num [").append(this.e.toString()).append("]").append(iQ.a);
        }
        if (this.a != null) {
            stringBuffer.append("   ").append("Issue Date [").append(this.a.toString()).append("]").append(iQ.a);
        }
        if (this.b != null) {
            stringBuffer.append("   ").append("Next Update Date [").append(this.b.toString()).append("]").append(iQ.a);
        }
        if (this.c != null) {
            stringBuffer.append("   ").append("Revoked Certificates [").append(iQ.a);
            for (RevokedCertificate revokedCertificate : this.c) {
                stringBuffer.append(revokedCertificate.toString());
            }
            stringBuffer.append("   ").append("]").append(iQ.a);
        }
        if (this.d != null) {
            stringBuffer.append("   ").append(this.d.toString());
        }
        stringBuffer.append("]").append(iQ.a);
        return stringBuffer.toString();
    }
}

