/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crl;

import com.rsa.cryptoj.c.eS;
import com.rsa.cryptoj.c.fN;
import com.rsa.cryptoj.c.iW;
import com.rsa.cryptoj.c.il;
import com.rsa.cryptoj.c.oO;
import com.rsa.cryptoj.c.pi;
import com.rsa.cryptoj.c.tA;
import com.rsa.cryptoj.c.va;
import com.rsa.jsafe.cert.IssuerInformation;
import com.rsa.jsafe.crl.CRLCreationException;
import com.rsa.jsafe.crl.CRLCreationParameterSpec;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.security.SecureRandom;
import java.security.cert.X509CRL;

public final class CRLCreationFactory {
    private final iW a;

    private CRLCreationFactory(eS eS2, fN fN2, SecureRandom secureRandom) {
        this.a = new iW(fN2, eS2, secureRandom);
    }

    public static CRLCreationFactory getInstance(String string) {
        pi.d();
        return CRLCreationFactory.a(string, oO.a(), null);
    }

    public static CRLCreationFactory getInstance(String string, FIPS140Context fIPS140Context) {
        pi.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        return CRLCreationFactory.a(string, fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()), null);
    }

    public static CRLCreationFactory getInstance(String string, SecureRandom secureRandom) {
        pi.d();
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CRLCreationFactory.a(string, oO.a(), secureRandom);
    }

    public static CRLCreationFactory getInstance(String string, FIPS140Context fIPS140Context, SecureRandom secureRandom) {
        pi.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CRLCreationFactory.a(string, fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()), secureRandom);
    }

    private static CRLCreationFactory a(String string, fN fN2, SecureRandom secureRandom) {
        if (string == null) {
            throw new IllegalArgumentException("Validation type is null");
        }
        if (string.equalsIgnoreCase("X.509-SuiteB")) {
            return new CRLCreationFactory(new va(), fN2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-Strict") || string.equalsIgnoreCase("X.509")) {
            return new CRLCreationFactory(new il(), fN2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-NoValidation")) {
            return new CRLCreationFactory(new tA(), fN2, secureRandom);
        }
        throw new IllegalArgumentException("Unknown/unsupported validation type");
    }

    public X509CRL generateCRL(IssuerInformation issuerInformation, CRLCreationParameterSpec cRLCreationParameterSpec) throws CRLCreationException {
        return this.a.a(issuerInformation, cRLCreationParameterSpec);
    }
}

