/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert.pkcs10;

import com.rsa.cryptoj.c.iQ;
import com.rsa.cryptoj.c.pi;
import com.rsa.cryptoj.c.qj;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cert.X509ExtensionRequestSpec;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCS10ParameterSpec
implements AlgorithmParameterSpec {
    private static final String a = "Input parameters cannot be null.";
    private X500Principal b;
    private PublicKey c;
    private String d;
    private X509ExtensionRequestSpec e;
    private String f;
    private boolean g = true;
    private List<Attribute> h;

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string) {
        pi.d();
        this.a(x500Principal, publicKey, string, true, null, null, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, X509ExtensionRequestSpec x509ExtensionRequestSpec) {
        pi.d();
        if (x509ExtensionRequestSpec == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, true, x509ExtensionRequestSpec, null, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, String string2) {
        pi.d();
        if (string2 == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, true, null, string2, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, X509ExtensionRequestSpec x509ExtensionRequestSpec, String string2) {
        pi.d();
        if (x509ExtensionRequestSpec == null || string2 == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, true, x509ExtensionRequestSpec, string2, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2) {
        pi.d();
        this.a(x500Principal, publicKey, string, bl2, null, null, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, X509ExtensionRequestSpec x509ExtensionRequestSpec) {
        pi.d();
        if (x509ExtensionRequestSpec == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, bl2, x509ExtensionRequestSpec, null, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, String string2) {
        pi.d();
        if (string2 == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, bl2, null, string2, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, X509ExtensionRequestSpec x509ExtensionRequestSpec, String string2) {
        pi.d();
        if (x509ExtensionRequestSpec == null || string2 == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, bl2, x509ExtensionRequestSpec, string2, null);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, List<Attribute> list) {
        pi.d();
        if (list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, true, null, null, list);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, X509ExtensionRequestSpec x509ExtensionRequestSpec, List<Attribute> list) {
        pi.d();
        if (x509ExtensionRequestSpec == null || list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, true, x509ExtensionRequestSpec, null, list);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, String string2, List<Attribute> list) {
        pi.d();
        if (string2 == null || list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, true, null, string2, list);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, X509ExtensionRequestSpec x509ExtensionRequestSpec, String string2, List<Attribute> list) {
        pi.d();
        if (x509ExtensionRequestSpec == null || string2 == null || list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, true, x509ExtensionRequestSpec, string2, list);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, List<Attribute> list) {
        pi.d();
        if (list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, bl2, null, null, list);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, X509ExtensionRequestSpec x509ExtensionRequestSpec, List<Attribute> list) {
        pi.d();
        if (x509ExtensionRequestSpec == null || list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, bl2, x509ExtensionRequestSpec, null, list);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, String string2, List<Attribute> list) {
        pi.d();
        if (string2 == null || list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, bl2, null, string2, list);
    }

    public PKCS10ParameterSpec(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, X509ExtensionRequestSpec x509ExtensionRequestSpec, String string2, List<Attribute> list) {
        pi.d();
        if (x509ExtensionRequestSpec == null || string2 == null || list == null) {
            throw new IllegalArgumentException(a);
        }
        this.a(x500Principal, publicKey, string, bl2, x509ExtensionRequestSpec, string2, list);
    }

    private void a(X500Principal x500Principal, PublicKey publicKey, String string, boolean bl2, X509ExtensionRequestSpec x509ExtensionRequestSpec, String string2, List<Attribute> list) {
        if (x500Principal == null || publicKey == null || string == null) {
            throw new IllegalArgumentException(a);
        }
        this.b = x500Principal;
        this.c = publicKey;
        this.d = string;
        if (x509ExtensionRequestSpec != null) {
            this.e = (X509ExtensionRequestSpec)x509ExtensionRequestSpec.clone();
        }
        this.f = string2;
        this.g = bl2;
        if (list != null) {
            this.h = Collections.unmodifiableList(new ArrayList<Attribute>(list));
        }
    }

    public boolean isSubjectSerialNumAutoGenEnabled() {
        return this.g;
    }

    public X500Principal getSubject() {
        return this.b;
    }

    public PublicKey getPublicKey() {
        return this.c;
    }

    public String getSignAlg() {
        return this.d;
    }

    public X509ExtensionRequestSpec getExtensions() {
        return this.e == null ? null : (X509ExtensionRequestSpec)this.e.clone();
    }

    public String getChallengePassword() {
        return this.f;
    }

    public List<Attribute> getOtherAttributes() {
        return this.h;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS10ParameterSpec)) {
            return false;
        }
        PKCS10ParameterSpec pKCS10ParameterSpec = (PKCS10ParameterSpec)object;
        return this.g == pKCS10ParameterSpec.g && this.d.equals(pKCS10ParameterSpec.d) && this.c.equals(pKCS10ParameterSpec.c) && this.b.equals(pKCS10ParameterSpec.b) && (this.e == null ? pKCS10ParameterSpec.e == null : this.e.equals(pKCS10ParameterSpec.e)) && (this.f == null ? pKCS10ParameterSpec.f == null : this.f.equals(pKCS10ParameterSpec.f)) && (this.h == null ? pKCS10ParameterSpec.h == null : ((Object)this.h).equals(pKCS10ParameterSpec.h));
    }

    public int hashCode() {
        int n2 = 7;
        n2 = qj.a(n2, this.g);
        n2 = qj.a(n2, this.d);
        n2 = qj.a(n2, this.c);
        n2 = qj.a(n2, this.b);
        n2 = qj.a(n2, this.e);
        n2 = qj.a(n2, this.f);
        n2 = qj.a(n2, this.h);
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS10ParameterSpec: [").append(iQ.a);
        stringBuffer.append("subject: ").append(this.b).append(iQ.a);
        stringBuffer.append(iQ.a).append("autoGenSerialNumRDN: ").append(this.g ? "enabled" : "disabled").append(iQ.a);
        stringBuffer.append("subjectPubKey: ").append(this.c).append(iQ.a);
        stringBuffer.append("signingAlg: ").append(this.d).append(iQ.a);
        if (this.f != null) {
            stringBuffer.append("challengePassword Attribute: ").append(this.f).append(iQ.a);
        }
        if (this.e != null) {
            stringBuffer.append("extensionRequest Attribute: ").append(this.e).append(iQ.a);
        }
        if (this.h != null) {
            stringBuffer.append("other Attributes [").append(iQ.a);
            for (Attribute attribute : this.h) {
                stringBuffer.append(attribute).append(iQ.a);
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

