/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.c.iQ;
import com.rsa.cryptoj.c.qj;
import com.rsa.cryptoj.c.xS;
import com.rsa.jsafe.cert.AccessDescription;
import com.rsa.jsafe.cert.AuthorityKeyIdentifier;
import com.rsa.jsafe.cert.DistributionPoint;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.ObjectID;
import com.rsa.jsafe.cert.X509ExtensionRequestSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509ExtensionSpec
extends X509ExtensionRequestSpec {
    private Set<ObjectID> b = new HashSet<ObjectID>();
    private AuthorityKeyIdentifier c;
    private byte[] d;
    private List<GeneralName> e;
    private List<AccessDescription> f;
    private List<AccessDescription> g;
    private List<DistributionPoint> h;
    private List<DistributionPoint> i;

    public X509ExtensionSpec() {
    }

    public X509ExtensionSpec(X509ExtensionRequestSpec x509ExtensionRequestSpec) {
        if (x509ExtensionRequestSpec == null) {
            throw new IllegalArgumentException("X509ExtensionRequestSpec is null");
        }
        if (x509ExtensionRequestSpec.isBasicConstraintsSpecified()) {
            this.setBasicConstraints(x509ExtensionRequestSpec.getBasicConstraints());
        }
        if (x509ExtensionRequestSpec.getCertificatePolicies() != null) {
            this.setCertificatePolicies(x509ExtensionRequestSpec.getCertificatePolicies());
        }
        if (x509ExtensionRequestSpec.getExtendedKeyUsage() != null) {
            this.setExtendedKeyUsage(x509ExtensionRequestSpec.getExtendedKeyUsage());
        }
        if (x509ExtensionRequestSpec.getInhibitAnyPolicy() >= 0) {
            this.setInhibitAnyPolicy(x509ExtensionRequestSpec.getInhibitAnyPolicy());
        }
        if (x509ExtensionRequestSpec.getKeyUsage() != null) {
            this.setKeyUsage(x509ExtensionRequestSpec.getKeyUsage());
        }
        if (x509ExtensionRequestSpec.getNameConstraintsPermitted() != null) {
            this.setNameConstraints(x509ExtensionRequestSpec.getNameConstraintsPermitted(), x509ExtensionRequestSpec.getNameConstraintsPermitted());
        }
        if (x509ExtensionRequestSpec.getRequireExplicitPolicy() >= 0) {
            this.setPolicyConstraints(x509ExtensionRequestSpec.getRequireExplicitPolicy(), x509ExtensionRequestSpec.getInhibitPolicyMapping());
        }
        if (x509ExtensionRequestSpec.getPolicyMappings() != null) {
            this.setPolicyMappings(x509ExtensionRequestSpec.getPolicyMappings());
        }
        if (x509ExtensionRequestSpec.getSubjectAlternativeNames() != null) {
            this.setSubjectAlternativeNames(x509ExtensionRequestSpec.getSubjectAlternativeNames());
        }
        if (x509ExtensionRequestSpec.getSubjectDirectoryAttributes() != null) {
            this.setSubjectDirectoryAttributes(x509ExtensionRequestSpec.getSubjectDirectoryAttributes());
        }
        if (x509ExtensionRequestSpec.getOtherExtensions() != null) {
            List<byte[]> list = x509ExtensionRequestSpec.getOtherExtensions();
            for (byte[] byArray : list) {
                this.addOtherExtension(byArray);
            }
        }
    }

    public void setAuthorityKeyIdentifier(AuthorityKeyIdentifier authorityKeyIdentifier) {
        if (authorityKeyIdentifier == null) {
            throw new IllegalArgumentException("Authority key identifier is null");
        }
        this.a = false;
        this.c = authorityKeyIdentifier;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Key identifier is null");
        }
        this.a = false;
        this.d = xS.a(byArray);
    }

    public void setSubjectInformationAccess(List<AccessDescription> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("Subject Access Information is null or contains null elements");
        }
        this.a = false;
        this.f = Collections.unmodifiableList(new ArrayList<AccessDescription>(list));
    }

    public void setAuthorityInformationAccess(List<AccessDescription> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("Authority Access Information is null or contains null elements");
        }
        this.a = false;
        this.g = Collections.unmodifiableList(new ArrayList<AccessDescription>(list));
    }

    public void setCRLDistributionPoint(List<DistributionPoint> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("CRL Distribution point is null or contains null elements");
        }
        this.a = false;
        this.h = Collections.unmodifiableList(new ArrayList<DistributionPoint>(list));
    }

    public void setFreshestCRL(List<DistributionPoint> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("freshestCRL distribution point is null or contains null elements");
        }
        this.a = false;
        this.i = Collections.unmodifiableList(new ArrayList<DistributionPoint>(list));
    }

    public void setIssuerAlternativeNames(List<GeneralName> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("names is null or contains null entries.");
        }
        this.a = false;
        this.e = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
    }

    public List<DistributionPoint> getCrlDistributionPoint() {
        return this.h;
    }

    public List<DistributionPoint> getFreshestCRL() {
        return this.i;
    }

    public List<AccessDescription> getSubjectAccessInformation() {
        return this.f;
    }

    public List<AccessDescription> getAuthorityAccessInformation() {
        return this.g;
    }

    public AuthorityKeyIdentifier getAuthorityKeyIdentifier() {
        return this.c;
    }

    public List<GeneralName> getIssuerAlternativeNames() {
        return this.e;
    }

    public byte[] getSubjectKeyIdentifier() {
        return xS.a(this.d);
    }

    public void setCriticalExtnOIDS(Set<ObjectID> set) {
        if (set == null || set.contains(null)) {
            throw new IllegalArgumentException("Critical extension set is null or contains null elements");
        }
        this.b = new HashSet<ObjectID>(set);
    }

    public void addCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.b.add(objectID);
    }

    public void removeCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.b.remove(objectID);
    }

    public Set<ObjectID> getCriticalExtOIDS() {
        return new HashSet<ObjectID>(this.b);
    }

    @Override
    public Object clone() {
        X509ExtensionSpec x509ExtensionSpec = (X509ExtensionSpec)super.clone();
        x509ExtensionSpec.b = new HashSet<ObjectID>(this.b);
        x509ExtensionSpec.d = xS.a(this.d);
        return x509ExtensionSpec;
    }

    public boolean isEmpty() {
        return this.a;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = qj.a(n2, this.b);
        n2 = qj.a(n2, this.c);
        n2 = qj.a(n2, this.d);
        n2 = qj.a(n2, this.e);
        n2 = qj.a(n2, this.f);
        n2 = qj.a(n2, this.g);
        n2 = qj.a(n2, this.h);
        n2 = qj.a(n2, this.i);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X509ExtensionSpec x509ExtensionSpec = (X509ExtensionSpec)object;
        return super.equals(object) && iQ.b(this.b, x509ExtensionSpec.b) && iQ.a(this.c, x509ExtensionSpec.c) && iQ.a((Object)this.d, (Object)x509ExtensionSpec.d) && iQ.b(this.e, x509ExtensionSpec.e) && iQ.b(this.f, x509ExtensionSpec.f) && iQ.b(this.g, x509ExtensionSpec.g) && iQ.b(this.h, x509ExtensionSpec.h) && iQ.b(this.i, x509ExtensionSpec.i);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.c != null) {
            stringBuffer.append("AuthorityKeyIdentifier [");
            stringBuffer.append(iQ.d(this.c.getKeyIdentifier()));
            stringBuffer.append("]").append(iQ.a);
        }
        if (this.d != null) {
            stringBuffer.append("SubjectKeyIdentifier [");
            stringBuffer.append(iQ.d(this.d));
            stringBuffer.append("]").append(iQ.a);
        }
        if (this.g != null) {
            stringBuffer.append("AuthorityAccessInformation [").append(iQ.a);
            for (AccessDescription object : this.g) {
                stringBuffer.append("   ").append(object).append(iQ.a);
            }
            stringBuffer.append("]").append(iQ.a);
        }
        if (this.f != null) {
            stringBuffer.append("SubjectAccessInformation [").append(iQ.a);
            for (AccessDescription accessDescription : this.f) {
                stringBuffer.append("   ").append(accessDescription).append(iQ.a);
            }
            stringBuffer.append("]").append(iQ.a);
        }
        if (this.h != null) {
            stringBuffer.append("CRLDistributionPoint [").append(iQ.a);
            for (DistributionPoint distributionPoint : this.h) {
                stringBuffer.append("   ").append(distributionPoint).append(iQ.a);
            }
            stringBuffer.append("]").append(iQ.a);
        }
        if (this.i != null) {
            stringBuffer.append("FreshestCRL [").append(iQ.a);
            for (DistributionPoint distributionPoint : this.i) {
                stringBuffer.append("   ").append(distributionPoint).append(iQ.a);
            }
            stringBuffer.append("]").append(iQ.a);
        }
        if (this.e != null) {
            stringBuffer.append("IssuerAltName [").append(iQ.a);
            for (GeneralName generalName : this.e) {
                stringBuffer.append("   ").append(generalName).append(iQ.a);
            }
            stringBuffer.append("]").append(iQ.a);
        }
        stringBuffer.append("Critical Extensions [").append(iQ.a);
        for (ObjectID objectID : this.b) {
            stringBuffer.append("   ").append(objectID).append(iQ.a);
        }
        stringBuffer.append("]").append(iQ.a);
        stringBuffer.append("]").append(iQ.a);
        return stringBuffer.toString();
    }
}

