/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.c.iQ;
import com.rsa.cryptoj.c.jG;
import com.rsa.cryptoj.c.pi;
import com.rsa.cryptoj.c.qj;
import com.rsa.cryptoj.c.sX;
import com.rsa.cryptoj.c.xS;
import com.rsa.jsafe.cert.DistributionPointName;
import com.rsa.jsafe.cert.GeneralName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionPoint
implements Cloneable {
    private DistributionPointName a;
    private List<GeneralName> b;
    private boolean[] c;

    public DistributionPoint() {
        pi.d();
    }

    public void setDistributionPointName(DistributionPointName distributionPointName) {
        if (distributionPointName == null) {
            throw new IllegalArgumentException("DistributionPointName is null");
        }
        this.a = distributionPointName;
    }

    public void setCRLIssuer(List<GeneralName> list) {
        if (list == null || list.contains(null) || list.isEmpty()) {
            throw new IllegalArgumentException("cRLIssuer is null or contains null elements");
        }
        this.b = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
    }

    public void setReasonFlags(boolean[] blArray) {
        if (blArray == null || blArray.length == 0) {
            throw new IllegalArgumentException("Reason flags is null or empty");
        }
        if (blArray.length > 9) {
            throw new IllegalArgumentException("Unexpected number of reason flags");
        }
        this.c = xS.a(blArray);
    }

    public DistributionPointName getDistributionPointName() {
        return this.a;
    }

    public List<GeneralName> getCrLIssuer() {
        return this.b;
    }

    public boolean[] getReasonFlags() {
        return xS.a(this.c);
    }

    public byte[] getEncoded() {
        Object[] objectArray;
        jG jG2 = null;
        jG jG3 = null;
        jG jG4 = null;
        if (this.a != null) {
            jG4 = this.a.getASN1Value();
        }
        if (this.b != null) {
            objectArray = new Object[this.b.size()];
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                objectArray[i2] = sX.a("GeneralName", this.b.get(i2).getEncoded(), 0);
            }
            jG3 = sX.a("GeneralNames", (Object)objectArray).d(sX.c(2));
        }
        if (this.c != null) {
            jG2 = sX.a("ReasonFlags", (Object)this.c).d(sX.c(1));
        }
        objectArray = new Object[]{jG4, jG2, jG3};
        jG jG5 = sX.a("DistributionPoint", (Object)objectArray);
        return sX.c(jG5);
    }

    public int hashCode() {
        int n2 = qj.a(7, this.b);
        n2 = qj.a(n2, this.c);
        n2 = qj.a(n2, this.a);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DistributionPoint distributionPoint = (DistributionPoint)object;
        return iQ.a(this.c, distributionPoint.c) && iQ.a(this.b, distributionPoint.b) && iQ.a(this.a, distributionPoint.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Distribution Point [").append(iQ.a);
        if (this.a != null) {
            stringBuffer.append(this.a.toString());
        }
        if (this.b != null) {
            stringBuffer.append("   ").append("CRL Issuer [").append(iQ.a);
            stringBuffer.append("      ");
            for (GeneralName generalName : this.b) {
                stringBuffer.append(generalName).append(iQ.a);
            }
            stringBuffer.append("   ").append("]").append(iQ.a);
        }
        if (this.c != null) {
            stringBuffer.append("   ").append("Reason Flags [").append(iQ.a);
            stringBuffer.append("      ");
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                stringBuffer.append(this.c[i2]).append(", ");
            }
            stringBuffer.append("]").append(iQ.a);
        }
        stringBuffer.append("   ").append("]").append(iQ.a);
        return stringBuffer.toString();
    }

    public Object clone() {
        DistributionPoint distributionPoint;
        try {
            distributionPoint = (DistributionPoint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not clone object");
        }
        distributionPoint.c = xS.a(this.c);
        return distributionPoint;
    }
}

