/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.c.fF;
import com.rsa.cryptoj.c.fN;
import com.rsa.cryptoj.c.kC;
import com.rsa.cryptoj.c.oO;
import com.rsa.cryptoj.c.pi;
import com.rsa.cryptoj.c.xE;
import com.rsa.jsafe.cert.CertRequest;
import com.rsa.jsafe.cert.CertRequestException;
import com.rsa.jsafe.cert.ProofGenerationParameters;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;

public final class CertRequestFactory {
    private final kC a;

    private CertRequestFactory(kC kC2) {
        this.a = kC2;
    }

    public static CertRequestFactory getInstance(String string) throws CertRequestException {
        pi.d();
        return CertRequestFactory.a(string, oO.a());
    }

    public static CertRequestFactory getInstance(String string, FIPS140Context fIPS140Context) throws CertRequestException {
        pi.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context cannot be null");
        }
        return CertRequestFactory.a(string, fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()));
    }

    private static CertRequestFactory a(String string, fN fN2) throws CertRequestException {
        if (string == null) {
            throw new IllegalArgumentException("The requestType cannot be null");
        }
        if (string.equalsIgnoreCase("pkcs10")) {
            return new CertRequestFactory(new fF(fN2));
        }
        if (string.equalsIgnoreCase("crmf")) {
            return new CertRequestFactory(new xE(fN2));
        }
        throw new CertRequestException("Unsupported certificate request " + string);
    }

    public String getType() {
        return this.a.a();
    }

    public CertRequest generateRequest(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, CertRequestException {
        return this.a.a(algorithmParameterSpec);
    }

    public CertRequest generateRequest(AlgorithmParameterSpec algorithmParameterSpec, ProofGenerationParameters proofGenerationParameters) throws InvalidAlgorithmParameterException, CertRequestException {
        return this.a.a(algorithmParameterSpec, proofGenerationParameters);
    }

    public CertRequest loadRequest(InputStream inputStream) throws CertRequestException {
        return this.a.a(inputStream);
    }
}

