/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.c.fN;
import com.rsa.cryptoj.c.jW;
import com.rsa.cryptoj.c.lY;
import com.rsa.cryptoj.c.mz;
import com.rsa.cryptoj.c.oL;
import com.rsa.cryptoj.c.oO;
import com.rsa.cryptoj.c.pi;
import com.rsa.cryptoj.c.tU;
import com.rsa.cryptoj.c.uk;
import com.rsa.jsafe.cert.CertComplianceAdjustment;
import com.rsa.jsafe.cert.CertCreationException;
import com.rsa.jsafe.cert.CertCreationParameterSpec;
import com.rsa.jsafe.cert.IssuerInformation;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

public final class CertCreationFactory {
    private final lY a;

    private CertCreationFactory(oL oL2, fN fN2, SecureRandom secureRandom) {
        this.a = new lY(fN2, secureRandom, oL2);
    }

    public static CertCreationFactory getInstance(String string) {
        pi.d();
        return CertCreationFactory.a(string, oO.a(), null);
    }

    public static CertCreationFactory getInstance(String string, FIPS140Context fIPS140Context) {
        pi.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        return CertCreationFactory.a(string, fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()), null);
    }

    public static CertCreationFactory getInstance(String string, SecureRandom secureRandom) {
        pi.d();
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CertCreationFactory.a(string, oO.a(), secureRandom);
    }

    public static CertCreationFactory getInstance(String string, FIPS140Context fIPS140Context, SecureRandom secureRandom) {
        pi.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CertCreationFactory.a(string, fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()), secureRandom);
    }

    public String getType() {
        return this.a.a();
    }

    private static CertCreationFactory a(String string, fN fN2, SecureRandom secureRandom) {
        if (string == null) {
            throw new IllegalArgumentException("Validation type is null");
        }
        if (string.equalsIgnoreCase("X.509-SuiteB")) {
            return new CertCreationFactory(new uk(), fN2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-Strict")) {
            return new CertCreationFactory(new tU(), fN2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-NoValidation")) {
            return new CertCreationFactory(new mz(), fN2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509")) {
            return new CertCreationFactory(new jW(), fN2, secureRandom);
        }
        throw new IllegalArgumentException("Unknown/unsupported validation type");
    }

    public X509Certificate generateCertificate(IssuerInformation issuerInformation, CertCreationParameterSpec certCreationParameterSpec) throws CertCreationException {
        return this.a.a(issuerInformation, certCreationParameterSpec, new CertComplianceAdjustment());
    }

    public X509Certificate generateCertificate(IssuerInformation issuerInformation, CertCreationParameterSpec certCreationParameterSpec, CertComplianceAdjustment certComplianceAdjustment) throws CertCreationException {
        return this.a.a(issuerInformation, certCreationParameterSpec, certComplianceAdjustment);
    }
}

