/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import com.rsa.cryptoj.c.eR;
import com.rsa.cryptoj.c.fN;
import com.rsa.cryptoj.c.ht;
import com.rsa.cryptoj.c.im;
import com.rsa.cryptoj.c.jG;
import com.rsa.cryptoj.c.lq;
import com.rsa.cryptoj.c.oO;
import com.rsa.cryptoj.c.pH;
import com.rsa.cryptoj.c.pi;
import com.rsa.cryptoj.c.sX;
import com.rsa.cryptoj.c.tb;
import com.rsa.cryptoj.c.vr;
import com.rsa.jcp.FIPS140Mode;
import com.rsa.jcp.OCSPException;
import com.rsa.jcp.OCSPResponderConfig;
import com.rsa.jcp.OCSPStatusType;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCSP {
    private OCSP() {
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        pi.d();
        return OCSP.sendRequest(string, x509Certificate, publicKey, OCSP.createRequestExtensions(new ArrayList<byte[]>()));
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey, byte[] byArray) throws OCSPException {
        ht ht2;
        pi.d();
        fN fN2 = oO.a();
        try {
            ht2 = new ht(fN2, x509Certificate, publicKey, new OCSPResponderConfig(string), byArray);
        }
        catch (pH pH2) {
            throw new OCSPException("Invalid DER-encoded extensions.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException.getMessage());
        }
        lq lq2 = new lq(fN2);
        byte[] byArray2 = lq2.a(ht2, string, null);
        if (byArray2 == null) {
            throw new OCSPException("OCSP request was unsuccessful: " + lq2.a());
        }
        return byArray2;
    }

    public static OCSPStatusType checkRevocationStatus(byte[] byArray, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        tb.a a2;
        pi.d();
        fN fN2 = oO.a();
        tb tb2 = new tb(fN2, byArray);
        if (!tb2.c()) {
            throw new OCSPException(tb2.d());
        }
        try {
            a2 = tb2.a(x509Certificate, publicKey);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException);
        }
        if (a2 == null) {
            throw new OCSPException("Response did not contain status for specified certificate.");
        }
        return OCSPStatusType.a(a2.f());
    }

    public static byte[] createNonceExtension(byte[] byArray) {
        pi.d();
        jG jG2 = eR.a(byArray);
        return sX.c(jG2);
    }

    public static byte[] createRequestExtensions(List<byte[]> list) {
        pi.d();
        boolean bl2 = false;
        ArrayList<jG> arrayList = new ArrayList<jG>();
        for (byte[] byArray : list) {
            try {
                jG jG2 = sX.a("Extension", byArray, 0);
                if (jG2.a("extnID").equals(im.cP.c())) {
                    bl2 = true;
                }
                arrayList.add(jG2);
            }
            catch (pH pH2) {
                throw new InvalidParameterException("Input contained invalid extension encoding.");
            }
        }
        if (!bl2) {
            arrayList.add(eR.a());
        }
        return sX.c(sX.a("Extensions", arrayList));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2, FIPS140Mode fIPS140Mode) {
        pi.d();
        if (!vr.a()) {
            throw new SecurityException("Cannot use this API with non-FIPS 140 toolkit");
        }
        return OCSP.a(x509Certificate, bl2, fN.a(fIPS140Mode.getValue(), 11));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2, FIPS140Context fIPS140Context) {
        pi.d();
        if (!vr.a()) {
            throw new SecurityException("Cannot use this API with non-FIPS 140 toolkit");
        }
        return OCSP.a(x509Certificate, bl2, fN.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2) {
        pi.d();
        return OCSP.a(x509Certificate, bl2, oO.a());
    }

    private static byte[] a(X509Certificate x509Certificate, boolean bl2, fN fN2) {
        if (bl2) {
            jG jG2 = sX.a("Name", x509Certificate.getSubjectX500Principal().getEncoded(), 0);
            return sX.c(jG2.c(sX.c(1)));
        }
        return eR.a(x509Certificate.getPublicKey(), fN2);
    }
}

