/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDList;

public final class OIDContainer
extends ASN1Container {
    public String transformation;
    private int a = -1;

    public OIDContainer(int n2) {
        this(n2, -1);
    }

    public OIDContainer(int n2, int n3) {
        this(n2, true, 0, null, n3);
    }

    public OIDContainer(int n2, boolean bl2, int n3, String string) {
        this(n2, bl2, n3, string, -1);
    }

    public OIDContainer(int n2, boolean bl2, int n3, String string, int n4) {
        super(n2, bl2, n3, 1536);
        this.a = n4;
        if (string == null) {
            return;
        }
        if ((n2 & 0x1000000) == 0) {
            this.data = OIDList.getOID(string, n4);
            this.dataOffset = 0;
            this.dataLen = this.data.length;
            this.transformation = OIDList.getTrans(this.data, this.dataOffset, this.dataLen, n4);
            this.r |= 0x20000;
        }
    }

    public OIDContainer(int n2, boolean bl2, int n3, byte[] byArray, int n4, int n5) throws ASN_Exception {
        this(n2, bl2, n3, byArray, n4, n5, -1);
    }

    public OIDContainer(int n2, boolean bl2, int n3, byte[] byArray, int n4, int n5, int n6) throws ASN_Exception {
        super(n2, bl2, n3, 1536);
        if (byArray != null && bl2) {
            if (n4 < 0 || n4 >= byArray.length) {
                throw new ASN_Exception("OIDContainer.OIDContainer: dataOffset is out of range.");
            }
            if (n5 < 0 || n4 + n5 > byArray.length) {
                throw new ASN_Exception("OIDContainer.OIDContainer: dataLen is out of range.");
            }
        }
        this.data = byArray;
        this.dataOffset = n4;
        this.dataLen = n5;
        if (byArray != null && (n2 & 0x1000000) == 0) {
            this.transformation = OIDList.getTrans(byArray, n4, n5, n6);
        }
        this.r |= 0x20000;
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        if (this.dataPresent && (this.m & 0x1000000) == 0 && this.transformation == null) {
            throw new ASN_Exception("No OID for this transformation.");
        }
        return super.a(aSN1ContainerArray, n2, byArray, n3);
    }

    int c(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        if (this.dataPresent && (this.m & 0x1000000) == 0 && this.transformation == null) {
            throw new ASN_Exception("No OID for this transformation.");
        }
        return super.c(aSN1ContainerArray, n2, byArray, n3);
    }

    void b() {
        super.b();
        this.transformation = null;
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5 = super.a(aSN1Template, n2, byArray, n3, n4);
        if ((this.r & 0x2000000) != 0 && (this.m & 0x1000000) == 0) {
            this.transformation = OIDList.getTrans(this.data, this.dataOffset, this.dataLen, this.a);
        }
        return n5;
    }

    boolean a(ASN1Container aSN1Container) {
        return aSN1Container instanceof OIDContainer;
    }

    ASN1Container a() {
        return new OIDContainer(this.m, true, this.n, null, -1);
    }
}

