/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import java.io.UnsupportedEncodingException;

public abstract class CharacterStringContainer
extends ASN1Container {
    public static final int UNLIMITED_LENGTH = -1;
    protected int a;
    protected boolean b;
    protected int c;
    protected int d;

    protected CharacterStringContainer(int n2, int n3, int n4) throws ASN_Exception {
        this(n2, n3, n4, -1, -1);
    }

    protected CharacterStringContainer(int n2, int n3, int n4, int n5, int n6) throws ASN_Exception {
        this(n2, true, 0, n3, n4, n5, n6);
    }

    private CharacterStringContainer(int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7) throws ASN_Exception {
        super(n2, bl2, n3, n4);
        this.m |= 0x4000000;
        this.a(n5);
        if (n6 < 0) {
            n6 = -1;
        }
        if (n7 < 0) {
            n7 = -1;
        }
        if (n6 != -1 && n7 != -1 && n6 > n7) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: maxLen should be larger than minLen.");
        }
        this.c = n6;
        this.d = n7;
        this.r |= 0x20000;
    }

    protected CharacterStringContainer(int n2, boolean bl2, int n3, int n4, String string, int n5, int n6, int n7) throws ASN_Exception {
        this(n2, bl2, n3, n4, n5, n6, n7);
        if (string == null) {
            return;
        }
        this.data = CharacterStringContainer.a(string, n5);
        this.q = true;
        this.dataLen = this.data.length;
        this.dataOffset = 0;
        this.a(true);
        this.r |= 0x20000;
    }

    protected CharacterStringContainer(int n2, boolean bl2, int n3, int n4, byte[] byArray, int n5, int n6, int n7, int n8, int n9, int n10) throws ASN_Exception {
        this(n2, bl2, n3, n4, n7, n9, n10);
        this.dataLen = n6;
        if (byArray == null) {
            return;
        }
        this.data = byArray;
        if (n5 < 0 || n5 >= byArray.length) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: dataOffset is out of range.");
        }
        this.dataOffset = n5;
        if (n6 < 0 || n5 + n6 > byArray.length) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: dataLen is out of range.");
        }
        if (n8 < 1) {
            throw new ASN_Exception("CharacterStringContainer.CharacterStringContainer: bytesPerCharacter should be a positive integer.");
        }
        this.a(n7, n8);
        this.a(true);
        this.r |= 0x20000;
    }

    protected CharacterStringContainer(int n2, boolean bl2, int n3, int n4, int n5, byte[] byArray, int n6, int n7, int n8, int n9, int n10, int n11) throws ASN_Exception {
        this(n2, bl2, n3, n4, byArray, n6, n7, n8, n9, n10, n11);
        this.F = n5;
    }

    void a(boolean bl2) throws ASN_Exception {
        if (!this.dataPresent) {
            return;
        }
        if (bl2) {
            if (((this.r & 0x2000000) != 0 || (this.r & 0x40000) != 0) && this.c != -1 && this.dataLen < this.c * this.a) {
                throw new ASN_Exception("Invalid String length (too short).");
            }
            if (this.d != -1 && this.dataLen > this.d * this.a) {
                throw new ASN_Exception("Invalid String length (too long).");
            }
        }
    }

    public void addData(byte[] byArray, int n2, int n3, boolean bl2, boolean bl3) throws ASN_Exception {
        super.addData(byArray, n2, n3, bl2, bl3);
        this.a(this.a, 1);
        this.b = false;
        this.a(true);
    }

    public void addData(String string, boolean bl2, boolean bl3) throws ASN_Exception {
        if (string == null) {
            throw new ASN_Exception("CharacterStringContainer.addData: newStringData should not be null.");
        }
        byte[] byArray = CharacterStringContainer.a(string, this.a);
        super.addData(byArray, 0, byArray.length, bl2, bl3);
        this.q = true;
        this.b = false;
        this.a(true);
    }

    public void noMoreData() throws ASN_Exception {
        this.r |= 0x40000;
        this.a(true);
    }

    public String getValueAsString() {
        if (this.data == null || this.dataLen == 0) {
            return "";
        }
        if (this.a == 1) {
            try {
                return new String(this.data, this.dataOffset, this.dataLen, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.data, this.dataOffset, this.dataLen);
            }
        }
        char[] cArray = new char[(this.dataLen + this.a - 1) / this.a];
        int n2 = 0;
        int n3 = this.dataOffset + this.a - 2;
        while (n2 < cArray.length) {
            cArray[n2] = (char)((char)(this.data[n3] << 8) | (char)(this.data[n3 + 1] & 0xFF));
            ++n2;
            n3 += this.a;
        }
        return new String(cArray);
    }

    private static byte[] a(String string, int n2) {
        char[] cArray = string.toCharArray();
        byte[] byArray = null;
        switch (n2) {
            case 1: {
                try {
                    return string.getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return string.getBytes();
                }
            }
            case 2: {
                byArray = new byte[cArray.length * 2];
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    byArray[2 * i2] = (byte)(cArray[i2] >>> 8);
                    byArray[2 * i2 + 1] = (byte)cArray[i2];
                }
                return byArray;
            }
            case 4: {
                byArray = new byte[cArray.length * 4];
                for (int i3 = 0; i3 < cArray.length; ++i3) {
                    byArray[4 * i3 + 2] = (byte)(cArray[i3] >>> 8);
                    byArray[4 * i3 + 3] = (byte)cArray[i3];
                }
                return byArray;
            }
        }
        return byArray;
    }

    private void a(int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = this.dataLen / n3 * n2;
        byte[] byArray = new byte[n4];
        if (n2 < n3) {
            int n5 = 0;
            for (int i2 = 0; i2 < this.dataLen; i2 += n3) {
                System.arraycopy(this.data, i2 + this.dataOffset, byArray, n5, n2);
                n5 += n2;
            }
        } else {
            int n6 = this.dataOffset;
            for (int i3 = 0; i3 < n4; i3 += n2) {
                int n7 = i3 + n2 - n3;
                System.arraycopy(this.data, n6 + this.dataOffset, byArray, n7, n3);
                n6 += n3;
            }
        }
        this.data = byArray;
        this.dataOffset = 0;
        this.dataLen = n4;
        this.q = true;
    }

    void b() {
        super.b();
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5 = super.a(aSN1Template, n2, byArray, n3, n4);
        this.b = false;
        this.a(false);
        return n5;
    }

    private void a(int n2) throws ASN_Exception {
        switch (n2) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new ASN_Exception("CharacterStringContainer.setOctetsPerChar: octetsPerCharacter should be 1, 2, or 4");
            }
        }
        this.a = n2;
    }
}

