/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public final class BitStringContainer
extends ASN1Container {
    public static final boolean NAMED = true;
    public static final boolean UNNAMED = false;
    private static final int a = -1;
    private int b;
    private int c;

    public BitStringContainer(int n2) {
        this(n2, true, 0, 0, 0, false);
    }

    public BitStringContainer(int n2, int n3) {
        this(n2, true, 0, 0, n3, true);
    }

    public BitStringContainer(int n2, boolean bl2, int n3, int n4, byte[] byArray, int n5, int n6) throws ASN_Exception {
        this(n2, bl2, n3, byArray, n5, n6, -1, false);
        this.F = n4;
    }

    public BitStringContainer(int n2, boolean bl2, int n3, int n4, int n5, boolean bl3) {
        super(n2, bl2, n3, 768);
        this.m |= 0x4000000;
        this.b = n5;
        if (this.b > 32) {
            this.b %= 32;
        }
        if (this.b < 0) {
            this.b = 0;
        }
        this.data = new byte[4];
        this.data[0] = (byte)((n4 &= -1 << 32 - this.b) >>> 24);
        this.data[1] = (byte)(n4 >>> 16);
        this.data[2] = (byte)(n4 >>> 8);
        this.data[3] = (byte)n4;
        this.q = true;
        this.dataLen = (n5 + 7) / 8;
        this.dataLen = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, bl3);
        this.c = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, this.b, bl3);
        this.r |= 0x60000;
    }

    public BitStringContainer(int n2, boolean bl2, int n3, byte[] byArray, int n4, int n5) throws ASN_Exception {
        this(n2, bl2, n3, byArray, n4, n5, -1, false);
    }

    public BitStringContainer(int n2, boolean bl2, int n3, int n4, byte[] byArray, int n5, int n6, int n7, boolean bl3) throws ASN_Exception {
        this(n2, bl2, n3, byArray, n5, n6, n7, bl3);
        this.F = n4;
    }

    public BitStringContainer(int n2, boolean bl2, int n3, byte[] byArray, int n4, int n5, int n6, boolean bl3) throws ASN_Exception {
        super(n2, bl2, n3, 768);
        this.m |= 0x4000000;
        this.b = n6;
        this.dataLen = n5;
        if (byArray == null) {
            return;
        }
        this.data = byArray;
        if (n4 < 0 || n4 >= byArray.length) {
            throw new ASN_Exception("BitStringContainer.BitStringContainer: dataOffset is out of range.");
        }
        this.dataOffset = n4;
        if (n5 < 0 || n4 + n5 > byArray.length) {
            throw new ASN_Exception("BitStringContainer.BitStringContainer: dataLen is out of range.");
        }
        if (n6 < 0) {
            n6 = n5 * 8;
        }
        if (n6 < n5 * 8) {
            this.dataLen = (n6 + 7) / 8;
            int n7 = n6 % 8;
            if (n7 != 0) {
                n7 = 255 >>> n7;
            }
            if ((n7 = this.data[this.dataOffset + this.dataLen - 1] & n7) != 0) {
                byte[] byArray2 = new byte[this.dataLen];
                System.arraycopy(this.data, this.dataOffset, byArray2, 0, this.dataLen);
                int n8 = byArray2.length - 1;
                byArray2[n8] = (byte)(byArray2[n8] ^ n7);
                this.data = byArray2;
                this.dataOffset = 0;
                this.q = true;
            }
        }
        this.dataLen = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, bl3);
        this.c = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, n6, bl3);
        this.r |= 0x20000;
        if (bl3) {
            this.r |= 0x40000;
        }
    }

    public int getValueAsInt() throws ASN_Exception {
        if (this.dataLen > 4) {
            throw new ASN_Exception("Cannot represent bit string in 32 bits.");
        }
        int n2 = -1 << this.c;
        int n3 = 0;
        int n4 = 24;
        int n5 = this.dataOffset;
        while (n4 >= 32 - this.dataLen * 8) {
            n3 |= (this.data[n5] & 0xFF) << n4;
            n4 -= 8;
            ++n5;
        }
        return n3 & n2;
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.c();
        this.r |= 0x40000;
        if (!this.dataPresent) {
            return this.a(false, null, 0);
        }
        this.l = this.dataLen;
        if (this.l != 0) {
            ++this.l;
        }
        int n3 = ASN1Lengths.getTagLen(this.h) + this.l + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.f == -1) {
            return n3;
        }
        this.g = n3;
        return ASN1Lengths.getTagLen(this.f) + this.g + ASN1Lengths.getLengthLen(n3);
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        this.r = 0x2000000;
        if (!this.dataPresent) {
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if (this.f != -1) {
            n3 += ASN1Lengths.writeTag(byArray, n3, this.f);
            n3 += ASN1Lengths.writeLength(byArray, n3, this.g);
        }
        n3 += ASN1Lengths.writeTag(byArray, n3, this.h);
        n3 += ASN1Lengths.writeLength(byArray, n3, this.l);
        if (this.l != 0) {
            if (n3 >= byArray.length) {
                throw new ASN_Exception("BitStringContainer.derEncode: not enough room in encoding to put unusedBits");
            }
            byArray[n3++] = (byte)this.c;
        }
        if (this.data != null) {
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("BitStringContainer.derEncode: not enough room in encoding to put data");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        return n3 - n4;
    }

    void b(ASN1Container[] aSN1ContainerArray, int n2) {
        this.c();
        if ((this.r & 0x40000) == 0) {
            this.h |= 0x20;
            this.l = -1;
        } else {
            this.l = this.dataLen;
            if (this.l != 0) {
                ++this.l;
            }
        }
        this.r |= 0x10000;
    }

    int a(byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        n2 += super.a(byArray, n2);
        if (this.l != 0) {
            if (byArray == null) {
                throw new ASN_Exception("BitStringContainer.writeTagBER: encoding should not be null.");
            }
            if (n2 < 0 || n2 >= byArray.length) {
                throw new ASN_Exception("BitStringContainer.writeTagBER: offset is out of range.");
            }
            byArray[n2++] = (byte)this.c;
        }
        return n2 - n3;
    }

    void b() {
        super.b();
        this.c = -1;
        this.b = 0;
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4 = n3;
        if (this.c == -1 && this.l != 0) {
            this.c = byArray[n3++];
            --this.D;
            if (this.l != -1) {
                --this.l;
            }
        }
        if (this.D >= 1) {
            n3 += super.a(aSN1Template, n2, byArray, n3);
        }
        return n3 - n4;
    }

    private static int a(byte[] byArray, int n2, int n3, boolean bl2) {
        if (!bl2) {
            return n3;
        }
        int n4 = n3;
        int n5 = n2 + n3 - 1;
        while (n5 >= n2 && byArray[n5] == 0) {
            --n5;
            --n4;
        }
        return n4;
    }

    private static int a(byte[] byArray, int n2, int n3, int n4, boolean bl2) {
        if (n3 == 0) {
            return 0;
        }
        if (!bl2) {
            int n5 = 8 - n4 % 8;
            if (n5 == 8) {
                n5 = 0;
            }
            return n5;
        }
        int n6 = byArray[n2 + n3 - 1] & 0xFF;
        for (int i2 = 0; i2 < 7; ++i2) {
            int n7 = n6 >>> i2 & 1;
            if (n7 == 0) continue;
            return i2;
        }
        return 7;
    }

    boolean a(ASN1Container aSN1Container) {
        return aSN1Container instanceof BitStringContainer;
    }

    ASN1Container a() {
        try {
            return new BitStringContainer(this.m, true, this.n, null, 0, 0, this.b, false);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

