/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import java.util.Arrays;

public abstract class ASN1Container {
    protected static final String e = "EndContainer is missing.";
    public boolean dataPresent;
    public byte[] data;
    public int dataOffset;
    public int dataLen;
    protected int f = -1;
    protected int g;
    protected int h;
    protected int i = -1;
    protected int j;
    protected int k;
    protected int l;
    protected int m;
    protected int n;
    boolean o;
    boolean p;
    protected boolean q;
    protected int r;
    static final int s = 65535;
    static final int t = 65536;
    static final int u = 131072;
    static final int v = 262144;
    protected static final int w = 0x100000;
    protected static final int x = 0x200000;
    static final int y = 0x400000;
    protected static final int z = 0x1000000;
    protected static final int A = 0x2000000;
    static final int B = 0x10000000;
    static final int C = 0x20000000;
    protected int D;
    protected boolean E;
    protected int F;

    protected ASN1Container() {
    }

    protected ASN1Container(int n2, int n3) {
        this(n2, true, 0, n3);
    }

    protected ASN1Container(int n2, int n3, int n4) {
        this(n2, true, 0, n3, n4);
    }

    protected ASN1Container(int n2, boolean bl2, int n3, int n4) {
        this(n2, bl2, n3, n4, 0);
    }

    protected ASN1Container(int n2, boolean bl2, int n3, int n4, int n5) {
        if (n2 >= 0) {
            this.m = n2;
        }
        this.dataPresent = bl2;
        this.n = n3;
        this.j = n4;
        this.F = n5;
        this.k = 0;
        if ((n4 & 0x2000) != 0) {
            this.o = true;
        }
    }

    public void setExtendedTag(int n2) throws ASN_Exception {
        if (this.i != -1) {
            throw new ASN_Exception("Extended tag already set.");
        }
        if (n2 < 0 || n2 > 0x1FFFFFF) {
            throw new ASN_Exception("Invalid extended tag value.");
        }
        if (n2 < 31) {
            this.m |= n2;
            return;
        }
        this.i = n2;
    }

    public boolean isComplete() {
        return (this.r & 0x2000000) != 0;
    }

    public boolean checkTag() {
        return (this.r & 0x100000) != 0;
    }

    public void addData(byte[] byArray, int n2, int n3, boolean bl2, boolean bl3) throws ASN_Exception {
        if (bl2) {
            if ((this.r & 0x2000000) != 0) {
                this.r ^= 0x2000000;
            }
        } else {
            if ((this.m & 0x4000000) == 0) {
                throw new ASN_Exception("This type is not allowed to accept new data.");
            }
            if ((this.r & 0x2000000) != 0) {
                throw new ASN_Exception("The container cannot accept new data, already encoded.");
            }
        }
        if ((this.r & 0x40000) != 0 && byArray != null) {
            throw new ASN_Exception("The container cannot accept new data any more.");
        }
        this.data = byArray;
        this.r |= 0x20000;
        if (byArray == null) {
            if (!bl3 || (this.m & 0x4000000) == 0) {
                throw new ASN_Exception("Cannot add null newData unless dataComplete is true.");
            }
            this.dataOffset = 0;
            this.dataLen = 0;
            this.r ^= 0x20000;
            this.r |= 0x40000;
            return;
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: offset is out of range.");
        }
        if (n3 < 0 || n2 + n3 > byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: len is out of range.");
        }
        this.dataOffset = n2;
        this.dataLen = n3;
        this.dataPresent = true;
        if (bl3) {
            this.r |= 0x40000;
        }
    }

    public void noMoreData() throws ASN_Exception {
        this.r |= 0x40000;
    }

    void c() {
        if ((this.r & 0x2000000) != 0) {
            this.r &= 0xFDFFFFFF;
            this.r |= 0x20000;
        }
        if ((this.m & 0x20000) != 0) {
            this.n = 0;
        }
        this.h = this.j >>> 8;
        int n2 = this.m & 0xE00000;
        if (n2 == 0) {
            return;
        }
        n2 >>>= 16;
        if (this.o) {
            n2 |= 0x20;
        }
        if (this.i == -1) {
            n2 |= this.m & 0xFF;
        } else {
            n2 |= 0x1F;
            int n3 = this.i;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                int n6 = (n3 & 0x7F) << n5;
                if (n5 != 0) {
                    n6 |= 128 << n5;
                }
                n4 |= n6;
                if ((n3 >>>= 7) == 0) break;
                n5 += 8;
            }
            n2 <<= n5 + 8;
            n2 |= n4;
        }
        if ((this.m & 0x200000) != 0) {
            this.f = n2;
        } else {
            this.h = n2;
        }
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.c();
        this.r |= 0x40000;
        if (!this.dataPresent) {
            return this.a(false, null, 0);
        }
        if (this.p) {
            return this.dataLen;
        }
        this.l = this.dataLen;
        int n3 = ASN1Lengths.getTagLen(this.h) + this.l + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.f == -1) {
            return n3;
        }
        this.g = n3;
        return ASN1Lengths.getTagLen(this.f) + this.g + ASN1Lengths.getLengthLen(n3);
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        this.r = 0x2000000;
        if (!this.dataPresent) {
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if (this.f != -1) {
            n3 += ASN1Lengths.writeTag(byArray, n3, this.f);
            n3 += ASN1Lengths.writeLength(byArray, n3, this.g);
        }
        n3 += ASN1Lengths.writeTag(byArray, n3, this.h);
        n3 += ASN1Lengths.writeLength(byArray, n3, this.l);
        if (this.data != null) {
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.derEncode: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        return n3 - n4;
    }

    int a(boolean bl2, byte[] byArray, int n2) throws ASN_Exception {
        if ((this.m & 0x10000) != 0 && this.n == 5) {
            if (bl2) {
                byArray[n2] = 5;
                byArray[n2 + 1] = 0;
            }
            return 2;
        }
        if ((this.m & 0xF0000) != 0) {
            return 0;
        }
        int n3 = 2;
        if (this.f != -1) {
            if (bl2) {
                byArray[n2] = (byte)this.f;
                byArray[n2 + 1] = 2;
            }
            n3 += 2;
            n2 += 2;
        }
        if (bl2) {
            byArray[n2] = (byte)this.h;
            byArray[n2 + 1] = 0;
        }
        return n3;
    }

    void b(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.c();
        this.l = this.dataLen;
        if ((this.m & 0x4000000) != 0 && (this.r & 0x40000) == 0) {
            this.h |= 0x20;
            this.l = -1;
        } else {
            this.r |= 0x40000;
        }
        this.r |= 0x10000;
    }

    int c(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        if (this.r == 0) {
            throw new ASN_Exception("Cannot continue BER encoding without new data.");
        }
        if ((this.r & 0x2000000) != 0) {
            return 0;
        }
        if (!this.dataPresent) {
            this.r = 0x2000000;
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if ((this.r & 0x10000) != 0) {
            n3 += this.a(byArray, n3);
        }
        if ((this.r & 0x20000) != 0) {
            n3 += this.b(aSN1ContainerArray, n2, byArray, n3);
        }
        if ((this.r & 0x40000) != 0) {
            n3 += this.b(byArray, n3);
        }
        return n3 - n4;
    }

    int a(byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        if (this.f != -1) {
            n2 += ASN1Lengths.writeTag(byArray, n2, this.f);
            byArray[n2++] = -128;
        }
        n2 += ASN1Lengths.writeTag(byArray, n2, this.h);
        if (this.l == -1) {
            byArray[n2++] = -128;
        } else {
            n2 += ASN1Lengths.writeLength(byArray, n2, this.l);
        }
        this.r ^= 0x10000;
        return n2 - n3;
    }

    int b(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4 = n3;
        if (this.data != null && this.dataLen != 0) {
            if (this.l == -1) {
                if (this.j == 7680 || this.j == 5632 || this.j == 4608 || this.j == 4864 || this.j == 5120 || this.j == 7168) {
                    this.k = this.j;
                    this.j = 1024;
                }
                byArray[n3++] = (byte)(this.j >>> 8);
                n3 += ASN1Lengths.writeLength(byArray, n3, this.dataLen);
            }
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.writeDataBER: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        this.r ^= 0x20000;
        return n3 - n4;
    }

    int b(byte[] byArray, int n2) {
        this.r = 0x2000000;
        int n3 = n2;
        if (this.l == -1) {
            byArray[n2] = 0;
            byArray[n2 + 1] = 0;
            n2 += 2;
        }
        if (this.f != -1) {
            byArray[n2] = 0;
            byArray[n2 + 1] = 0;
            n2 += 2;
        }
        if (this.k != 0) {
            this.j = this.k;
            this.h = this.j >>> 8;
        }
        return n2 - n3;
    }

    void d() {
        this.b();
        this.c();
        this.r = 0x100000;
        if (this.f != -1) {
            this.r |= 0x200000;
        }
        this.dataPresent = true;
    }

    void b() {
        this.g = 0;
        this.l = 0;
        this.clearSensitiveData();
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5;
        block3: {
            this.clearSensitiveData();
            n5 = n3;
            this.D = n4 - n3;
            if ((this.r & 0x100000) != 0) {
                int n6 = this.b(aSN1Template, n2, byArray, n3, this.D);
                if ((this.r & 0x1000000) != 0 || (this.r & 0x2000000) != 0) {
                    return n6;
                }
                this.r |= 0x400000;
                n3 += n6;
                this.D -= n6;
            }
            if (this.D < 1 && this.l != 0) break block3;
            do {
                n3 += this.a(aSN1Template, n2, byArray, n3);
            } while ((this.r & 0x1000000) == 0 && (this.r & 0x2000000) == 0 && this.D >= 1);
        }
        return n3 - n5;
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4;
        int n5 = n3;
        if (this.l > 0) {
            n4 = this.l;
            if (this.D < this.l) {
                n4 = this.D;
            }
            if (this.E) {
                this.a(byArray, n3, n4);
            } else {
                if (this.F != 0 && this.F >= n4) {
                    this.data = new byte[this.F];
                    System.arraycopy(byArray, n3, this.data, 0, n4);
                    this.dataOffset = 0;
                } else {
                    this.data = byArray;
                    this.dataOffset = n3;
                }
                this.dataLen = n4;
            }
            this.l -= n4;
            n3 += n4;
            if (this.l > 0) {
                this.r |= 0x1000000;
                return n3 - n5;
            }
            this.D -= n4;
        }
        n4 = this.a(aSN1Template, byArray, n3, this.D);
        n3 += n4;
        this.D -= n4;
        if ((this.r & 0x1000000) != 0 || (this.r & 0x2000000) != 0) {
            return n3 - n5;
        }
        this.r |= 0x100000;
        n4 = this.b(aSN1Template, n2, byArray, n3, this.D);
        n3 += n4;
        if ((this.r & 0x1000000) != 0) {
            return n3 - n5;
        }
        this.D -= n4;
        if (this.D < 1) {
            this.r |= 0x1000000;
        }
        this.E = true;
        return n3 - n5;
    }

    int a(ASN1Template aSN1Template, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = this.r & 0xFFFF;
        if (n4 == 0) {
            this.r = 0x2000000;
            return 0;
        }
        if (n3 < 1) {
            return 0;
        }
        int n5 = n2;
        int n6 = this.b(aSN1Template, byArray, n2, n3);
        n2 += n6;
        if ((this.r & 0x1000000) != 0) {
            return n2 - n5;
        }
        n3 -= n6;
        if (aSN1Template.c[0] == 0) {
            if (aSN1Template.c[1] != 0) {
                throw new ASN_Exception("Improper ending to indefinite length.");
            }
            this.r -= 2;
            aSN1Template.e = 0;
            if ((n4 -= 2) == 0) {
                this.r = 0x2000000;
                if (this.k != 0) {
                    this.j = this.k;
                    this.h = this.j >>> 8;
                }
                return n2 - n5;
            }
            n2 += this.a(aSN1Template, byArray, n2, n3);
            return n2 - n5;
        }
        if (this.g == -1 && n4 == 2) {
            throw new ASN_Exception("Improper ending to indefinite length.");
        }
        return n2 - n5;
    }

    void a(byte[] byArray, int n2, int n3) {
        if (n3 < 1) {
            return;
        }
        if (this.data == null && this.F != 0) {
            this.data = new byte[this.F];
        }
        if (this.data != null && this.data.length > this.dataLen + n3) {
            System.arraycopy(byArray, n2, this.data, this.dataLen, n3);
            this.dataLen += n3;
            return;
        }
        byte[] byArray2 = new byte[this.dataLen + n3];
        if (this.data != null) {
            System.arraycopy(this.data, this.dataOffset, byArray2, 0, this.dataLen);
        }
        System.arraycopy(byArray, n2, byArray2, this.dataLen, n3);
        if (this.q) {
            this.clearSensitiveData();
        }
        this.data = byArray2;
        this.dataOffset = 0;
        this.dataLen = byArray2.length;
        this.q = true;
    }

    int b(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5 = n3;
        int n6 = this.b(aSN1Template, byArray, n3, n4);
        if ((this.r & 0x1000000) != 0) {
            return n6;
        }
        n3 += n6;
        n4 -= n6;
        if ((this.r & 0x200000) != 0) {
            if (!this.a(aSN1Template, this.f)) {
                this.b(aSN1Template, n2);
                return n3 - n5;
            }
            this.r ^= 0x200000;
            this.g = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.g == -1) {
                this.r += 2;
            }
            aSN1Template.e = 0;
            n6 = this.b(aSN1Template, byArray, n3, n4);
            n3 += n6;
            n4 -= n6;
            if ((this.r & 0x1000000) != 0) {
                return n3 - n5;
            }
        }
        if (this.a(aSN1Template, this.h)) {
            this.l = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.l == -1) {
                if ((aSN1Template.c[0] & 0x20) == 0) {
                    throw new ASN_Exception("Invalid indefinite length octet.");
                }
                this.r += 2;
            }
            this.r ^= 0x100000;
            aSN1Template.e = 0;
            return n3 - n5;
        }
        int n7 = 32;
        n7 <<= (aSN1Template.d - 1) * 8;
        if ((this.m & 0x4000000) != 0 && this.a(aSN1Template, n7 |= this.h)) {
            this.l = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.l != -1) {
                throw new ASN_Exception("Primitive promoted to constructed must be indefinite length.");
            }
            this.r ^= 0x100000;
            this.r += 2;
            if (this.j == 7680 || this.j == 5632 || this.j == 4608 || this.j == 4864 || this.j == 5120 || this.j == 7168) {
                this.k = this.j;
                this.j = 1024;
            }
            this.h = this.j >>> 8;
            aSN1Template.e = 0;
            return n3 - n5;
        }
        if (this.f != -1) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        if ((this.m & 0x4000000) != 0 && n4 > 1 && byArray[n5] == 0 && byArray[n5 + 1] == 0) {
            this.r = 0x2000000;
            if (this.k != 0) {
                this.j = this.k;
                this.h = this.j >>> 8;
            }
            n3 = n5 + 2;
            return n3 - n5;
        }
        this.b(aSN1Template, n2);
        return n3 - n5;
    }

    int b(ASN1Template aSN1Template, byte[] byArray, int n2, int n3) throws ASN_Exception {
        this.r |= 0x1000000;
        int n4 = n2;
        int n5 = this.a(aSN1Template);
        while (n5 > 0 && n3 >= 1) {
            if (aSN1Template.e >= aSN1Template.c.length) {
                throw new ASN_Exception("Tag and len len is too large.");
            }
            aSN1Template.c[aSN1Template.e] = byArray[n2];
            --n3;
            ++aSN1Template.e;
            ++n2;
            if (--n5 >= 1) continue;
            n5 = this.a(aSN1Template);
        }
        if (n5 < 1) {
            this.r ^= 0x1000000;
        }
        return n2 - n4;
    }

    int a(ASN1Template aSN1Template) throws ASN_Exception {
        int n2;
        if (aSN1Template.e == 0) {
            return 1;
        }
        aSN1Template.d = 1;
        if ((aSN1Template.c[0] & 0x1F) == 31) {
            for (n2 = 1; n2 < aSN1Template.e && (aSN1Template.c[n2] & 0x80) != 0; ++n2) {
            }
            if (n2 >= aSN1Template.e) {
                return 1;
            }
            aSN1Template.d = ++n2;
        }
        if (n2 >= aSN1Template.e) {
            return 1;
        }
        int n3 = n2;
        return (n3 += ASN1Lengths.determineLengthLen(aSN1Template.c, n2)) - aSN1Template.e;
    }

    boolean a(ASN1Template aSN1Template, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < aSN1Template.d; ++i2) {
            n3 = n3 << 8 | aSN1Template.c[i2] & 0xFF;
        }
        return n3 == n2;
    }

    void b(ASN1Template aSN1Template, int n2) throws ASN_Exception {
        if ((this.r & 0x400000) != 0) {
            throw new ASN_Exception("Invalid encoding: expected tag or data not there.");
        }
        if ((this.m & 0x10000) != 0 && aSN1Template.e > 0 && aSN1Template.c[0] == 5) {
            this.dataPresent = false;
            this.n = 5;
            if (aSN1Template.c[1] != 0) {
                throw new ASN_Exception("Length after NULL not zero.");
            }
            this.r |= 0x2000000;
            aSN1Template.e = 0;
            return;
        }
        if ((this.m & 0xF0000) == 0) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        this.dataPresent = false;
        this.r |= 0x2000000;
    }

    boolean a(int n2, ASN1Container[] aSN1ContainerArray, int n3) throws ASN_Exception {
        if ((this.r & 0x2000000) != 0) {
            return false;
        }
        if (n2 == 5 && (this.m & 0x10000) != 0) {
            return true;
        }
        if (this.f != -1) {
            return n2 == this.f;
        }
        if (n2 == this.h) {
            return true;
        }
        return (this.m & 0x4000000) != 0 && n2 == (this.h | 0x20);
    }

    boolean a(ASN1Container aSN1Container) {
        return false;
    }

    abstract ASN1Container a();

    public void clearSensitiveData() {
        if (this.data != null && this.q) {
            Arrays.fill(this.data, (byte)0);
        }
        this.data = null;
        this.dataOffset = 0;
        this.dataLen = 0;
        this.q = false;
    }
}

