/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider;

import com.rsa.cryptoj.f.dy;
import com.rsa.cryptoj.f.fl;
import com.rsa.cryptoj.f.fr;
import com.rsa.cryptoj.f.fx;
import com.rsa.cryptoj.f.kv;
import com.rsa.cryptoj.f.ll;
import com.rsa.cryptoj.f.mA;
import com.rsa.cryptoj.f.oe;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.pP;
import com.rsa.cryptoj.f.u;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.X942DHParameterSpec;
import com.rsa.jsafe.security.spec.DSADomainParameterGenerationSpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.SecureRandom;

public final class Assurance {
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final int VERSION_FIPS186_2 = 2;
    public static final int VERSION_FIPS186_3 = 3;

    private Assurance() {
    }

    public static boolean isValidPublicKey(PublicKey publicKey) throws InvalidKeyException {
        return Assurance.isValidPublicKey(publicKey, null, null);
    }

    public static boolean isValidPublicKey(PublicKey publicKey, SecureRandom secureRandom, FIPS140Context fIPS140Context) throws InvalidKeyException {
        ox.d();
        fx fx2 = fIPS140Context == null ? oe.a() : fx.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue());
        dy dy2 = fr.b(publicKey.getAlgorithm(), publicKey, fx2);
        fl fl2 = secureRandom == null ? ll.a() : kv.a(secureRandom, fx2);
        return mA.a(dy2, fl2);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, null, null);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        boolean bl2;
        ox.d();
        if (string == null || dSADomainParameterGenerationSpec == null) {
            throw new InvalidParameterException("The digest name and parameter spec cannot be null");
        }
        if (string.equals(DIGEST_SHA1) && (bl2 = Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, 2, secureRandom, fIPS140Context))) {
            return bl2;
        }
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, 3, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        fl fl2;
        ox.d();
        if (string == null || dSADomainParameterGenerationSpec == null) {
            throw new InvalidParameterException("The digest name and parameter spec cannot be null");
        }
        byte[] byArray = u.a(dSADomainParameterGenerationSpec.getG());
        byte[] byArray2 = u.a(dSADomainParameterGenerationSpec.getP());
        byte[] byArray3 = u.a(dSADomainParameterGenerationSpec.getQ());
        byte[] byArray4 = dSADomainParameterGenerationSpec.getSeedBytes();
        if (byArray4 == null || byArray == null || byArray3 == null || byArray2 == null) {
            throw new InvalidParameterException("The seed, primeP, primeQ, baseG are required in the DSADomainParameterGenerationSpec.");
        }
        int n3 = dSADomainParameterGenerationSpec.getCounter();
        fx fx2 = fIPS140Context == null ? oe.a() : fx.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue());
        fl fl3 = fl2 = secureRandom == null ? ll.a() : kv.a(secureRandom, fx2);
        if (n2 == 2) {
            return pP.a(byArray4, byArray2, byArray3, byArray, string, n3, true, fl2, fx2);
        }
        if (n2 == 3) {
            return pP.a(byArray4, byArray2, byArray3, byArray, string, n3, false, fl2, fx2);
        }
        throw new InvalidParameterException("Version has to be VERSION_FIPS186_2 (=2) or VERSION_FIPS186_3 (=3)");
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n2) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, n2, null, null);
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        ox.d();
        if (x942DHParameterSpec == null) {
            throw new InvalidParameterException("An X942DHParameter spec must be specified");
        }
        byte[] byArray = x942DHParameterSpec.getSeed();
        byte[] byArray2 = u.a(x942DHParameterSpec.getP());
        byte[] byArray3 = u.a(x942DHParameterSpec.getQ());
        byte[] byArray4 = u.a(x942DHParameterSpec.getG());
        BigInteger bigInteger = x942DHParameterSpec.getPGenCounter();
        if (bigInteger == null) {
            throw new InvalidParameterException("The counter must be specified");
        }
        int n2 = bigInteger.intValue();
        if (byArray == null || byArray2 == null || byArray3 == null || byArray4 == null) {
            throw new InvalidParameterException("The seed, primeP, primeQ, baseG and the expected counter value is required.");
        }
        fx fx2 = fIPS140Context == null ? oe.a() : fx.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue());
        fl fl2 = secureRandom == null ? ll.a() : kv.a(secureRandom, fx2);
        return pP.a(byArray, byArray2, byArray3, n2, byArray4, fl2, fx2);
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec) {
        return Assurance.verifyX942DHParams(x942DHParameterSpec, null, null);
    }
}

