/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crl;

import com.rsa.cryptoj.f.eD;
import com.rsa.cryptoj.f.fx;
import com.rsa.cryptoj.f.hR;
import com.rsa.cryptoj.f.iC;
import com.rsa.cryptoj.f.oe;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.sH;
import com.rsa.cryptoj.f.uf;
import com.rsa.jsafe.cert.IssuerInformation;
import com.rsa.jsafe.crl.CRLCreationException;
import com.rsa.jsafe.crl.CRLCreationParameterSpec;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.security.SecureRandom;
import java.security.cert.X509CRL;

public final class CRLCreationFactory {
    private final iC a;

    private CRLCreationFactory(eD eD2, fx fx2, SecureRandom secureRandom) {
        this.a = new iC(fx2, eD2, secureRandom);
    }

    public static CRLCreationFactory getInstance(String string) {
        ox.d();
        return CRLCreationFactory.a(string, oe.a(), null);
    }

    public static CRLCreationFactory getInstance(String string, FIPS140Context fIPS140Context) {
        ox.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        return CRLCreationFactory.a(string, fx.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()), null);
    }

    public static CRLCreationFactory getInstance(String string, SecureRandom secureRandom) {
        ox.d();
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CRLCreationFactory.a(string, oe.a(), secureRandom);
    }

    public static CRLCreationFactory getInstance(String string, FIPS140Context fIPS140Context, SecureRandom secureRandom) {
        ox.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CRLCreationFactory.a(string, fx.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()), secureRandom);
    }

    private static CRLCreationFactory a(String string, fx fx2, SecureRandom secureRandom) {
        if (string == null) {
            throw new IllegalArgumentException("Validation type is null");
        }
        if (string.equalsIgnoreCase("X.509-SuiteB")) {
            return new CRLCreationFactory(new uf(), fx2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-Strict") || string.equalsIgnoreCase("X.509")) {
            return new CRLCreationFactory(new hR(), fx2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-NoValidation")) {
            return new CRLCreationFactory(new sH(), fx2, secureRandom);
        }
        throw new IllegalArgumentException("Unknown/unsupported validation type");
    }

    public X509CRL generateCRL(IssuerInformation issuerInformation, CRLCreationParameterSpec cRLCreationParameterSpec) throws CRLCreationException {
        return this.a.a(issuerInformation, cRLCreationParameterSpec);
    }
}

