/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cms;

import com.rsa.cryptoj.f.hf;
import com.rsa.jsafe.cert.Attribute;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public abstract class SignerInfo {
    protected final hf a;
    protected final List<Attribute> b;
    private final List<Attribute> c;

    public SignerInfo(X509Certificate x509Certificate, Attribute[] attributeArray, Attribute[] attributeArray2) {
        this.a(x509Certificate, attributeArray, attributeArray2);
        this.a = new hf(x509Certificate.getIssuerX500Principal(), x509Certificate.getSerialNumber());
        this.b = attributeArray != null ? Arrays.asList(attributeArray) : null;
        this.c = attributeArray2 != null ? Arrays.asList(attributeArray2) : new ArrayList<Attribute>();
    }

    protected SignerInfo(hf hf2, Attribute[] attributeArray, Attribute[] attributeArray2) {
        this.a = hf2;
        this.b = attributeArray != null ? Arrays.asList(attributeArray) : null;
        this.c = attributeArray2 != null ? Arrays.asList(attributeArray2) : new ArrayList<Attribute>();
    }

    private void a(X509Certificate x509Certificate, Attribute[] attributeArray, Attribute[] attributeArray2) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("No input argument can be null.");
        }
        if (attributeArray != null) {
            for (Attribute attribute : attributeArray) {
                if ("1.2.840.113549.1.9.3".equals(attribute.getAttributeType().toString())) {
                    throw new IllegalArgumentException("ContentType attribute not allowed.");
                }
                if ("1.2.840.113549.1.9.4".equals(attribute.getAttributeType().toString())) {
                    throw new IllegalArgumentException("MessageDigest attribute not allowed.");
                }
                if (!"1.2.840.113549.1.9.6".equals(attribute.getAttributeType().toString())) continue;
                throw new IllegalArgumentException("CounterSignature attribute not allowed in signed attributes.");
            }
        }
        if (attributeArray2 != null) {
            for (Attribute attribute : attributeArray2) {
                if (!"1.2.840.113549.1.9.5".equals(attribute.getAttributeType().toString())) continue;
                throw new IllegalArgumentException("SigningTime attribute not allowed in unsigned attributes.");
            }
        }
    }

    public Attribute[] getSignedAttributes() {
        if (this.b == null) {
            return new Attribute[0];
        }
        return this.b.toArray(new Attribute[this.b.size()]);
    }

    public Attribute[] getUnsignedAttributes() {
        return this.c.toArray(new Attribute[this.c.size()]);
    }

    public X500Principal getIssuer() {
        return this.a.d();
    }

    public BigInteger getSerialNumber() {
        return this.a.c();
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.a.b();
    }
}

