/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cms;

import com.rsa.cryptoj.f.hr;
import com.rsa.cryptoj.f.jb;
import com.rsa.cryptoj.f.lH;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.sg;
import com.rsa.cryptoj.f.tK;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cms.CMSException;
import com.rsa.jsafe.cms.KekRecipientInfo;
import com.rsa.jsafe.cms.KeyAgreeRecipientInfo;
import com.rsa.jsafe.cms.KeyTransRecipientInfo;
import com.rsa.jsafe.cms.PasswordRecipientInfo;
import com.rsa.jsafe.cms.SignerInfo;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.SecretKey;

public final class InfoObjectFactory {
    public static final String ENCRYPTION_RSA = "RSA";
    public static final String KDF_PBKDF2WITHSHA1 = "PBKDF2withSHA1";
    public static final String KDF_PBKDF2WITHSHA224 = "PBKDF2withSHA224";
    public static final String KDF_PBKDF2WITHSHA256 = "PBKDF2withSHA256";
    public static final String KDF_PBKDF2WITHSHA384 = "PBKDF2withSHA384";
    public static final String KDF_PBKDF2WITHSHA512 = "PBKDF2withSHA512";
    public static final String KEYAGREE_ECDH = "ECDH";
    public static final String KEYAGREE_DH = "DH";
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";

    private InfoObjectFactory() {
    }

    public static KeyTransRecipientInfo newKeyTransRecipientInfo(X509Certificate x509Certificate, String string) throws CMSException {
        ox.d();
        return new hr(x509Certificate, string);
    }

    public static PasswordRecipientInfo newPasswordRecipientInfo(char[] cArray) throws CMSException {
        ox.d();
        return new tK(cArray, KDF_PBKDF2WITHSHA256, 100000);
    }

    public static PasswordRecipientInfo newPasswordRecipientInfo(char[] cArray, String string, int n2) throws CMSException {
        ox.d();
        return new tK(cArray, string, n2);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] byArray, SecretKey secretKey) throws CMSException {
        ox.d();
        return new lH(byArray, secretKey);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] byArray, SecretKey secretKey, Date date) throws CMSException {
        ox.d();
        return new lH(byArray, secretKey, date);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] byArray, SecretKey secretKey, Date date, String string, byte[] byArray2) throws CMSException {
        ox.d();
        return new lH(byArray, secretKey, date, string, byArray2);
    }

    public static KeyAgreeRecipientInfo newKeyAgreeRecipientInfo(X509Certificate x509Certificate, PrivateKey privateKey, X509Certificate x509Certificate2) throws CMSException {
        ox.d();
        return new sg(x509Certificate, privateKey, x509Certificate2);
    }

    public static KeyAgreeRecipientInfo newKeyAgreeRecipientInfo(PublicKey publicKey, PrivateKey privateKey, X509Certificate x509Certificate) throws CMSException {
        ox.d();
        return new sg(publicKey, privateKey, x509Certificate);
    }

    public static SignerInfo newSignerInfo(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws CMSException {
        ox.d();
        return new jb(privateKey, x509Certificate, string, null, null);
    }

    public static SignerInfo newSignerInfo(PrivateKey privateKey, X509Certificate x509Certificate, String string, Attribute[] attributeArray, Attribute[] attributeArray2) throws CMSException {
        ox.d();
        return new jb(privateKey, x509Certificate, string, attributeArray, attributeArray2);
    }
}

