/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.f.iw;
import com.rsa.cryptoj.f.jm;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.pv;
import com.rsa.cryptoj.f.sf;
import com.rsa.cryptoj.f.wT;
import com.rsa.jsafe.cert.DistributionPointName;
import com.rsa.jsafe.cert.GeneralName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionPoint
implements Cloneable {
    private DistributionPointName a;
    private List<GeneralName> b;
    private boolean[] c;

    public DistributionPoint() {
        ox.d();
    }

    public void setDistributionPointName(DistributionPointName distributionPointName) {
        if (distributionPointName == null) {
            throw new IllegalArgumentException("DistributionPointName is null");
        }
        this.a = distributionPointName;
    }

    public void setCRLIssuer(List<GeneralName> list) {
        if (list == null || list.contains(null) || list.isEmpty()) {
            throw new IllegalArgumentException("cRLIssuer is null or contains null elements");
        }
        this.b = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
    }

    public void setReasonFlags(boolean[] blArray) {
        if (blArray == null || blArray.length == 0) {
            throw new IllegalArgumentException("Reason flags is null or empty");
        }
        if (blArray.length > 9) {
            throw new IllegalArgumentException("Unexpected number of reason flags");
        }
        this.c = wT.a(blArray);
    }

    public DistributionPointName getDistributionPointName() {
        return this.a;
    }

    public List<GeneralName> getCrLIssuer() {
        return this.b;
    }

    public boolean[] getReasonFlags() {
        return wT.a(this.c);
    }

    public byte[] getEncoded() {
        Object[] objectArray;
        jm jm2 = null;
        jm jm3 = null;
        jm jm4 = null;
        if (this.a != null) {
            jm4 = this.a.getASN1Value();
        }
        if (this.b != null) {
            objectArray = new Object[this.b.size()];
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                objectArray[i2] = sf.a("GeneralName", this.b.get(i2).getEncoded(), 0);
            }
            jm3 = sf.a("GeneralNames", (Object)objectArray).d(sf.c(2));
        }
        if (this.c != null) {
            jm2 = sf.a("ReasonFlags", (Object)this.c).d(sf.c(1));
        }
        objectArray = new Object[]{jm4, jm2, jm3};
        jm jm5 = sf.a("DistributionPoint", (Object)objectArray);
        return sf.c(jm5);
    }

    public int hashCode() {
        int n2 = pv.a(7, this.b);
        n2 = pv.a(n2, this.c);
        n2 = pv.a(n2, this.a);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DistributionPoint distributionPoint = (DistributionPoint)object;
        return iw.a(this.c, distributionPoint.c) && iw.a(this.b, distributionPoint.b) && iw.a(this.a, distributionPoint.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Distribution Point [").append(iw.a);
        if (this.a != null) {
            stringBuffer.append(this.a.toString());
        }
        if (this.b != null) {
            stringBuffer.append("   ").append("CRL Issuer [").append(iw.a);
            stringBuffer.append("      ");
            for (GeneralName generalName : this.b) {
                stringBuffer.append(generalName).append(iw.a);
            }
            stringBuffer.append("   ").append("]").append(iw.a);
        }
        if (this.c != null) {
            stringBuffer.append("   ").append("Reason Flags [").append(iw.a);
            stringBuffer.append("      ");
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                stringBuffer.append(this.c[i2]).append(", ");
            }
            stringBuffer.append("]").append(iw.a);
        }
        stringBuffer.append("   ").append("]").append(iw.a);
        return stringBuffer.toString();
    }

    public Object clone() {
        DistributionPoint distributionPoint;
        try {
            distributionPoint = (DistributionPoint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not clone object");
        }
        distributionPoint.c = wT.a(this.c);
        return distributionPoint;
    }
}

