/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.f.fp;
import com.rsa.cryptoj.f.fx;
import com.rsa.cryptoj.f.kg;
import com.rsa.cryptoj.f.oe;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.wF;
import com.rsa.jsafe.cert.CertRequest;
import com.rsa.jsafe.cert.CertRequestException;
import com.rsa.jsafe.cert.ProofGenerationParameters;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;

public final class CertRequestFactory {
    private final kg a;

    private CertRequestFactory(kg kg2) {
        this.a = kg2;
    }

    public static CertRequestFactory getInstance(String string) throws CertRequestException {
        ox.d();
        return CertRequestFactory.a(string, oe.a());
    }

    public static CertRequestFactory getInstance(String string, FIPS140Context fIPS140Context) throws CertRequestException {
        ox.d();
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context cannot be null");
        }
        return CertRequestFactory.a(string, fx.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()));
    }

    private static CertRequestFactory a(String string, fx fx2) throws CertRequestException {
        if (string == null) {
            throw new IllegalArgumentException("The requestType cannot be null");
        }
        if (string.equalsIgnoreCase("pkcs10")) {
            return new CertRequestFactory(new fp(fx2));
        }
        if (string.equalsIgnoreCase("crmf")) {
            return new CertRequestFactory(new wF(fx2));
        }
        throw new CertRequestException("Unsupported certificate request " + string);
    }

    public String getType() {
        return this.a.a();
    }

    public CertRequest generateRequest(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, CertRequestException {
        return this.a.a(algorithmParameterSpec);
    }

    public CertRequest generateRequest(AlgorithmParameterSpec algorithmParameterSpec, ProofGenerationParameters proofGenerationParameters) throws InvalidAlgorithmParameterException, CertRequestException {
        return this.a.a(algorithmParameterSpec, proofGenerationParameters);
    }

    public CertRequest loadRequest(InputStream inputStream) throws CertRequestException {
        return this.a.a(inputStream);
    }
}

