/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.f.ej;
import com.rsa.cryptoj.f.iw;
import com.rsa.cryptoj.f.jm;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.pv;
import com.rsa.cryptoj.f.sf;
import com.rsa.cryptoj.f.uL;
import com.rsa.cryptoj.f.wT;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.ObjectID;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityKeyIdentifier {
    private byte[] a;
    private List<GeneralName> b;
    private BigInteger c;
    private jm d;
    private byte[] e;

    public AuthorityKeyIdentifier(X509Certificate x509Certificate) {
        ox.d();
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Issuer certificate is null");
        }
        this.a = x509Certificate.getExtensionValue(ObjectID.SUBJECT_KEY_ID_EXTN.toString());
        if (this.a == null) {
            throw new IllegalArgumentException("Subject key identifier extension not present in the certificate, " + x509Certificate.getSubjectX500Principal());
        }
        this.a = ((uL)sf.a(ej.a, this.a, 0)).d();
        this.a = ((uL)sf.a(ej.a, this.a, 0)).d();
        this.c = x509Certificate.getSerialNumber();
        this.b = new ArrayList<GeneralName>();
        this.b.add(new GeneralName(x509Certificate.getSubjectX500Principal()));
        this.a();
    }

    public AuthorityKeyIdentifier(byte[] byArray) {
        ox.d();
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Key identifier is null or empty");
        }
        this.a = wT.a(byArray);
        this.a();
    }

    public AuthorityKeyIdentifier(byte[] byArray, List<GeneralName> list, BigInteger bigInteger) {
        ox.d();
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Key identifier is null or empty");
        }
        if (list == null || list.contains(null) || list.isEmpty()) {
            throw new IllegalArgumentException("Issuer name cannot be null or empty");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Issuer serial number cannot be null");
        }
        this.a = wT.a(byArray);
        this.b = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
        this.c = bigInteger;
        this.a();
    }

    private void a() {
        boolean bl2 = this.b != null && !this.b.isEmpty();
        Object[] objectArray = null;
        if (bl2) {
            objectArray = new Object[this.b.size()];
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                objectArray[i2] = sf.a("GeneralName", this.b.get(i2).getEncoded(), 0);
            }
        }
        this.d = sf.a("AuthorityKeyIdentifier", (Object)new Object[]{this.a, objectArray, bl2 ? this.c : null});
        this.e = sf.c(this.d);
    }

    public byte[] getKeyIdentifier() {
        return wT.a(this.a);
    }

    public List<GeneralName> getIssuerName() {
        return this.b;
    }

    public BigInteger getIssuerSerialNum() {
        return this.c;
    }

    public jm getASN1Value() {
        return this.d;
    }

    public int hashCode() {
        return pv.a(7, this.e);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.e, ((AuthorityKeyIdentifier)object).e);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Authority Key Identifier [").append(iw.a);
        if (this.a != null) {
            stringBuffer.append("      ").append("Key Identifier [");
            stringBuffer.append(iw.a(this.a));
            stringBuffer.append("]").append(iw.a);
        }
        if (this.b != null) {
            stringBuffer.append("      ").append("Issuer Name [").append(iw.a);
            for (GeneralName generalName : this.b) {
                stringBuffer.append("      ").append(generalName).append(iw.a);
            }
            stringBuffer.append("   ").append("]").append(iw.a);
        }
        if (this.c != null) {
            stringBuffer.append("   ").append("Issuer Serial Num [").append(iw.a);
            stringBuffer.append("      ").append(this.c.toString());
            stringBuffer.append("   ").append("]").append(iw.a);
        }
        stringBuffer.append("   ").append("]").append(iw.a);
        return stringBuffer.toString();
    }
}

