/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.cryptoj.f.ge;
import com.rsa.cryptoj.f.jn;
import com.rsa.cryptoj.f.oe;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.pP;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_SecureRandom;

public final class JSAFE_VerifyPQG {
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final int VERSION_FIPS186_2 = 2;
    public static final int VERSION_FIPS186_3 = 3;

    private JSAFE_VerifyPQG() {
        ox.d();
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3) {
        ox.d();
        return pP.a(byArray, byArray2, byArray3, byArray4, DIGEST_SHA1, n3, true, null, oe.a());
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3, FIPS140Context fIPS140Context) {
        ox.d();
        return pP.a(byArray, byArray2, byArray3, byArray4, DIGEST_SHA1, n3, true, null, fIPS140Context == null ? oe.a() : fIPS140Context.a());
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string) throws JSAFE_InvalidParameterException {
        return JSAFE_VerifyPQG.verifyPQGParams(byArray, byArray2, byArray3, byArray4, n2, string, null, null);
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string, JSAFE_SecureRandom jSAFE_SecureRandom, FIPS140Context fIPS140Context) throws JSAFE_InvalidParameterException {
        boolean bl2;
        ox.d();
        if (jn.b() && fIPS140Context.a().c() == ge.d) {
            throw new SecurityException("For FIPS140 Security Level 2 context must be in user role.");
        }
        if (string == null || byArray == null || byArray2 == null || byArray3 == null || byArray4 == null) {
            throw new JSAFE_InvalidParameterException("digest name, the seed, and the parameters cannot be null");
        }
        if (string.equals(DIGEST_SHA1) && (bl2 = pP.a(byArray, byArray2, byArray3, byArray4, string, n2, true, jSAFE_SecureRandom == null ? null : jSAFE_SecureRandom.a(), fIPS140Context == null ? oe.a() : fIPS140Context.a()))) {
            return bl2;
        }
        return pP.a(byArray, byArray2, byArray3, byArray4, string, n2, false, jSAFE_SecureRandom == null ? null : jSAFE_SecureRandom.a(), fIPS140Context == null ? oe.a() : fIPS140Context.a());
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string, int n3) throws JSAFE_InvalidParameterException {
        return JSAFE_VerifyPQG.verifyPQGParams(byArray, byArray2, byArray3, byArray4, n2, string, n3, null, null);
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string, int n3, JSAFE_SecureRandom jSAFE_SecureRandom, FIPS140Context fIPS140Context) throws JSAFE_InvalidParameterException {
        ox.d();
        if (string == null || byArray == null || byArray2 == null || byArray3 == null || byArray4 == null) {
            throw new JSAFE_InvalidParameterException("digest name, the seed, and the parameters cannot be null");
        }
        if (n3 == 2) {
            return pP.a(byArray, byArray2, byArray3, byArray4, string, n2, true, jSAFE_SecureRandom == null ? null : jSAFE_SecureRandom.a(), fIPS140Context == null ? oe.a() : fIPS140Context.a());
        }
        if (n3 == 3) {
            return pP.a(byArray, byArray2, byArray3, byArray4, string, n2, false, jSAFE_SecureRandom == null ? null : jSAFE_SecureRandom.a(), fIPS140Context == null ? oe.a() : fIPS140Context.a());
        }
        throw new JSAFE_InvalidParameterException("Version has to be VERSION_FIPS186_2 (=2) or VERSION_FIPS186_3 (=3)");
    }

    public static boolean verifyX942DHParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, JSAFE_SecureRandom jSAFE_SecureRandom, FIPS140Context fIPS140Context) throws JSAFE_InvalidParameterException {
        ox.d();
        if (byArray == null || byArray2 == null || byArray3 == null || byArray4 == null) {
            throw new JSAFE_InvalidParameterException("The seed, primeP, primeQ, baseG and the expected counter value is required.");
        }
        if (fIPS140Context == null) {
            throw new JSAFE_InvalidParameterException("The FIPS140Context was null.");
        }
        return pP.a(byArray, byArray2, byArray3, n2, byArray4, jSAFE_SecureRandom == null ? null : jSAFE_SecureRandom.a(), fIPS140Context.a());
    }

    public static boolean verifyX942DHParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2) throws JSAFE_InvalidParameterException {
        ox.d();
        if (byArray == null || byArray2 == null || byArray3 == null || byArray4 == null) {
            throw new JSAFE_InvalidParameterException("The seed, primeP, primeQ, baseG and the expected counter value is required.");
        }
        return pP.a(byArray, byArray2, byArray3, n2, byArray4, null, oe.a());
    }
}

