/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import com.rsa.cryptoj.f.eC;
import com.rsa.cryptoj.f.fx;
import com.rsa.cryptoj.f.hS;
import com.rsa.cryptoj.f.hb;
import com.rsa.cryptoj.f.jm;
import com.rsa.cryptoj.f.kT;
import com.rsa.cryptoj.f.oU;
import com.rsa.cryptoj.f.oe;
import com.rsa.cryptoj.f.ox;
import com.rsa.cryptoj.f.sf;
import com.rsa.cryptoj.f.sj;
import com.rsa.cryptoj.f.uw;
import com.rsa.jcp.FIPS140Mode;
import com.rsa.jcp.OCSPException;
import com.rsa.jcp.OCSPResponderConfig;
import com.rsa.jcp.OCSPStatusType;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCSP {
    private OCSP() {
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        ox.d();
        return OCSP.sendRequest(string, x509Certificate, publicKey, OCSP.createRequestExtensions(new ArrayList<byte[]>()));
    }

    public static byte[] sendRequest(String string, X509Certificate x509Certificate, PublicKey publicKey, byte[] byArray) throws OCSPException {
        hb hb2;
        ox.d();
        fx fx2 = oe.a();
        try {
            hb2 = new hb(fx2, x509Certificate, publicKey, new OCSPResponderConfig(string), byArray);
        }
        catch (oU oU2) {
            throw new OCSPException("Invalid DER-encoded extensions.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException.getMessage());
        }
        kT kT2 = new kT(fx2);
        byte[] byArray2 = kT2.a(hb2, string, null);
        if (byArray2 == null) {
            throw new OCSPException("OCSP request was unsuccessful: " + kT2.a());
        }
        return byArray2;
    }

    public static OCSPStatusType checkRevocationStatus(byte[] byArray, X509Certificate x509Certificate, PublicKey publicKey) throws OCSPException {
        sj.a a2;
        ox.d();
        fx fx2 = oe.a();
        sj sj2 = new sj(fx2, byArray);
        if (!sj2.c()) {
            throw new OCSPException(sj2.d());
        }
        try {
            a2 = sj2.a(x509Certificate, publicKey);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new OCSPException(invalidAlgorithmParameterException);
        }
        if (a2 == null) {
            throw new OCSPException("Response did not contain status for specified certificate.");
        }
        return OCSPStatusType.a(a2.f());
    }

    public static byte[] createNonceExtension(byte[] byArray) {
        ox.d();
        jm jm2 = eC.a(byArray);
        return sf.c(jm2);
    }

    public static byte[] createRequestExtensions(List<byte[]> list) {
        ox.d();
        boolean bl2 = false;
        ArrayList<jm> arrayList = new ArrayList<jm>();
        for (byte[] byArray : list) {
            try {
                jm jm2 = sf.a("Extension", byArray, 0);
                if (jm2.a("extnID").equals(hS.cP.c())) {
                    bl2 = true;
                }
                arrayList.add(jm2);
            }
            catch (oU oU2) {
                throw new InvalidParameterException("Input contained invalid extension encoding.");
            }
        }
        if (!bl2) {
            arrayList.add(eC.a());
        }
        return sf.c(sf.a("Extensions", arrayList));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2, FIPS140Mode fIPS140Mode) {
        ox.d();
        if (!uw.a()) {
            throw new SecurityException("Cannot use this API with non-FIPS 140 toolkit");
        }
        return OCSP.a(x509Certificate, bl2, fx.a(fIPS140Mode.getValue(), 11));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2, FIPS140Context fIPS140Context) {
        ox.d();
        if (!uw.a()) {
            throw new SecurityException("Cannot use this API with non-FIPS 140 toolkit");
        }
        return OCSP.a(x509Certificate, bl2, fx.a(fIPS140Context.getModeValue(), fIPS140Context.getRoleValue()));
    }

    public static byte[] createResponderIDBytes(X509Certificate x509Certificate, boolean bl2) {
        ox.d();
        return OCSP.a(x509Certificate, bl2, oe.a());
    }

    private static byte[] a(X509Certificate x509Certificate, boolean bl2, fx fx2) {
        if (bl2) {
            jm jm2 = sf.a("Name", x509Certificate.getSubjectX500Principal().getEncoded(), 0);
            return sf.c(jm2.c(sf.c(1)));
        }
        return eC.a(x509Certificate.getPublicKey(), fx2);
    }
}

