/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.keywordNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDListModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.keywordNavigator.KeywordIndexItemAdapter;
import oracle.help.navigator.keywordNavigator.KeywordModelAdapter;

public class KeywordNavigator
extends LazyNavigator
implements ListSelectionListener,
DocumentListener,
ActionListener {
    private static int BORDER_SIZE = 8;
    private static int SPACE_SIZE = BORDER_SIZE / 2;
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static String TYPE_KEYWORD_NAVIGATOR = "oracle.help.navigator.keywordNavigator.KeywordNavigator";
    private static String DEFAULT_LABEL_ID = "navigator.keywordNavigator.default_label";
    private static String LABEL_INSTRUCTION = "navigator.keywordNavigator.instruct";
    private static String LABEL_SELECT = "navigator.keywordNavigator.select";
    private static String BUTTON_OPEN = "navigator.keywordNavigator.open";
    private static String PROTOTYPE_CELL = "This is a long index item";
    private JTextField _typeField;
    private JList _topicList;
    private JButton _openButton;
    private KeywordModelAdapter _keywordAdapter;
    private int _syncingListWithText;
    private int _syncingTextWithList;
    private KeywordIndexItemAdapter _currentIndexItem = new KeywordIndexItemAdapter();
    private SpreadTable _entryTable;
    private EntryTableSelectionListener _selectionListener;
    private static String WORD_LIST_SEPARATOR = "navigator.keywordNavigator.wordListSeparator";
    private boolean _showOpenButton = true;

    public Topic getCurrentSelection() {
        if (this._selectionListener != null) {
            return this._selectionListener.getSelectedTopic();
        }
        return null;
    }

    public String getDefaultLabel() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String string = resourceBundle.getString(DEFAULT_LABEL_ID);
        return string;
    }

    public void showOpenButton(boolean bl) {
        this._showOpenButton = bl;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this._syncingTextWithList == 0) {
            this._syncListWithTextField();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this._syncingTextWithList == 0) {
            this._syncListWithTextField();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this._syncingTextWithList == 0) {
            this._syncListWithTextField();
        }
    }

    private void _syncListWithTextField() {
        int n;
        ++this._syncingListWithText;
        String string = this._typeField.getText();
        if (string != null && this._keywordAdapter.getItemCount() > 0 && (n = this._keywordAdapter.findClosestKeywordIndexItem(string)) != -1) {
            int n2 = this._topicList.getLastVisibleIndex() - this._topicList.getFirstVisibleIndex();
            this._topicList.ensureIndexIsVisible(n + n2 - 1);
            this._topicList.ensureIndexIsVisible(n);
            this._topicList.setSelectedIndex(n);
            this._currentIndexItem.setCurrentKeywordIndexItem(this._keywordAdapter.getKeywordIndexItemForIndex(n));
        }
        --this._syncingListWithText;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._syncingListWithText == 0) {
            ++this._syncingTextWithList;
            int n = this._topicList.getSelectedIndex();
            this._currentIndexItem.setCurrentKeywordIndexItem(this._keywordAdapter.getKeywordIndexItemForIndex(n));
            this._typeField.setText(this._currentIndexItem.getKeywordIndexItem().getSortingText());
            --this._syncingTextWithList;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Topic topic;
        if (actionEvent != null && actionEvent.getSource() == this._openButton && (topic = this._selectionListener.getSelectedTopic()) != null) {
            this._fireTopicActivated(topic);
        }
    }

    protected void addViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_KEYWORD_NAVIGATOR)) {
            this._keywordAdapter.addView(view);
        }
    }

    protected void removeViewNow(View view) {
        if (view != null && view.getType().equals(TYPE_KEYWORD_NAVIGATOR)) {
            this._keywordAdapter.removeView(view);
            this._currentIndexItem.setCurrentKeywordIndexItem(null);
        }
    }

    protected void doInitializationNow() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String string = resourceBundle.getString(WORD_LIST_SEPARATOR);
        this._keywordAdapter = new KeywordModelAdapter(this.getInitialViewsArray(), string);
        this._currentIndexItem.addModelListener((TwoDModelListener)new EntryTableDataListener());
        this.setLayout(new BorderLayout(0, 8));
        this.setBorder(new EmptyBorder(BORDER_SIZE, BORDER_SIZE, BORDER_SIZE, BORDER_SIZE));
        this._typeField = new JTextField();
        this._typeField.getDocument().addDocumentListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 0, SPACE_SIZE));
        JLabel jLabel = MnemonicUtils.createLabel(resourceBundle.getString(LABEL_INSTRUCTION), this._typeField);
        jPanel.add((Component)jLabel, (Object)this._typeField);
        jPanel.add(this._typeField);
        this.add((Component)jPanel, "North");
        this._topicList = new JList(new OneDListModel((OneDModel)this._keywordAdapter));
        this._topicList.getAccessibleContext().setAccessibleName(this.getDefaultLabel());
        this._topicList.setPrototypeCellValue(PROTOTYPE_CELL);
        this._topicList.addListSelectionListener(this);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() > 1 && (n = KeywordNavigator.this._topicList.locationToIndex(mouseEvent.getPoint())) != -1) {
                    KeywordNavigator.this._topicList.setSelectedIndex(n);
                    Topic topic = KeywordNavigator.this._currentIndexItem.getKeywordIndexItem().getTopic();
                    if (topic != null) {
                        KeywordNavigator.this._fireTopicActivated(topic);
                    }
                }
            }
        };
        this._topicList.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this._topicList);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JComponent jComponent = this._createEntryTableComponent(resourceBundle);
        jPanel2.setLayout(new BorderLayout(0, BORDER_SIZE));
        jPanel2.add((Component)MnemonicUtils.createLabel(resourceBundle.getString(LABEL_SELECT), (Component)this._entryTable), "North");
        jPanel2.add((Component)jComponent, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this._openButton = MnemonicUtils.createButton(resourceBundle.getString(BUTTON_OPEN));
        this._openButton.addActionListener(this);
        this._openButton.setEnabled(false);
        if (this._showOpenButton) {
            jPanel3.add((Component)this._openButton, "East");
        }
        jPanel2.add((Component)jPanel3, "South");
        this.add((Component)jPanel2, "South");
        this._syncingListWithText = 0;
        this._syncingTextWithList = 0;
        this.validate();
    }

    private JComponent _createEntryTableComponent(ResourceBundle resourceBundle) {
        Object[] objectArray = new String[]{resourceBundle.getString("navigator.keywordNavigator.topictitle"), resourceBundle.getString("navigator.keywordNavigator.source")};
        ArrayOneDModel arrayOneDModel = new ArrayOneDModel(objectArray);
        this._entryTable = new SpreadTable((TwoDModel)this._currentIndexItem, (OneDModel)arrayOneDModel, null);
        this._entryTable.setHorizontalSeparatorsVisible(false);
        this._entryTable.setVerticalSeparatorsVisible(false);
        this._entryTable.setScrollByRow(true);
        Header header = this._entryTable.getColumnHeader();
        header.setCanMoveItems(false);
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setItemInputHandler((HeaderItemInputHandler)this._currentIndexItem);
        Grid grid = this._entryTable.getGrid();
        grid.setGridSelectionManager(GeneralGridSelectionManager.createSingleRowSelectionManager());
        grid.setPreferredRowsOnScreen(3);
        grid.setColumnPainter(0, (Painter)new TextPainter());
        grid.setColumnPainter(1, (Painter)new TextPainter());
        grid.setDefaultInputHandler((CellInputHandler)new EntryTableInputHandler());
        TableResizer tableResizer = new TableResizer();
        this._entryTable.addResizeListener((TableResizeListener)tableResizer);
        this._entryTable.setColumnWidth(0, 250);
        this._entryTable.setColumnWidth(1, 100);
        this._selectionListener = new EntryTableSelectionListener();
        this._entryTable.addPropertyChangeListener((PropertyChangeListener)this._selectionListener);
        JScrollPane jScrollPane = new JScrollPane((Component)this._entryTable, 22, 31);
        jScrollPane.addComponentListener(tableResizer);
        return jScrollPane;
    }

    private void _fireTopicActivated(Topic topic) {
        NavigatorEvent navigatorEvent = new NavigatorEvent(this, 2001, topic, 1);
        this.fireNavigatorEvent(navigatorEvent);
    }

    private void _fireTopicSelected(Topic topic) {
        NavigatorEvent navigatorEvent = new NavigatorEvent(this, 2000, topic);
        this.fireNavigatorEvent(navigatorEvent);
    }

    private class EntryTableInputHandler
    extends CellInputHandler {
        public void mouseClicked(MouseEvent mouseEvent, Grid grid, int n, int n2) {
            if (mouseEvent.getClickCount() > 1) {
                ActionEvent actionEvent = new ActionEvent(KeywordNavigator.this._openButton, 1001, "");
                KeywordNavigator.this.actionPerformed(actionEvent);
            }
            super.mouseClicked(mouseEvent, grid, n, n2);
        }

        public void keyPressed(KeyEvent keyEvent, Grid grid, int n, int n2) {
            if (keyEvent != null) {
                if (keyEvent.getKeyCode() == 10) {
                    ActionEvent actionEvent = new ActionEvent(KeywordNavigator.this._openButton, 1001, "");
                    KeywordNavigator.this.actionPerformed(actionEvent);
                    keyEvent.consume();
                }
                super.keyPressed(keyEvent, grid, n, n2);
            }
        }
    }

    private class EntryTableDataListener
    extends TwoDModelAdapter {
        private EntryTableDataListener() {
        }

        public void rowsRemoved(TwoDModelEvent twoDModelEvent) {
            if (twoDModelEvent != null) {
                int n = KeywordNavigator.this._selectionListener.getSelectedRowIndex();
                int n2 = twoDModelEvent.getRowStartIndex();
                int n3 = twoDModelEvent.getRowCount();
                if (n2 <= n && n2 + n3 > n) {
                    KeywordNavigator.this._selectionListener.clearSelection();
                }
            }
        }
    }

    private class EntryTableSelectionListener
    implements PropertyChangeListener {
        private int _selectedRow = -1;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() == "selection") {
                TwoDSelection twoDSelection = KeywordNavigator.this._entryTable.getSelection();
                this._selectedRow = twoDSelection != null ? twoDSelection.getSingleRow() : -1;
                if (this._selectedRow != -1) {
                    KeywordNavigator.this._openButton.setEnabled(true);
                } else {
                    KeywordNavigator.this._openButton.setEnabled(false);
                }
                KeywordNavigator.this._fireTopicSelected(KeywordNavigator.this.getCurrentSelection());
            }
        }

        public Topic getSelectedTopic() {
            List list;
            if (this._selectedRow != -1 && this._selectedRow < (list = KeywordNavigator.this._currentIndexItem.getEntries()).size()) {
                return ((TopicBaseBean)list.get(this._selectedRow)).getTopic();
            }
            return null;
        }

        public int getSelectedRowIndex() {
            return this._selectedRow;
        }

        public void clearSelection() {
            KeywordNavigator.this._openButton.setEnabled(false);
            this._selectedRow = -1;
            KeywordNavigator.this._fireTopicSelected(null);
        }
    }

    private class TableResizer
    extends ComponentAdapter
    implements TableResizeListener {
        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = KeywordNavigator.this._entryTable.getParent().getSize();
            int n = (int)(0.7 * (double)dimension.width);
            int n2 = (int)(0.3 * (double)dimension.width);
            KeywordNavigator.this._entryTable.setColumnWidth(0, n);
            KeywordNavigator.this._entryTable.setColumnWidth(1, n2);
        }

        public void columnResizing(TableEvent tableEvent) {
        }

        public void columnResized(TableEvent tableEvent) {
            if (tableEvent != null) {
                Dimension dimension = KeywordNavigator.this._entryTable.getSize();
                int n = KeywordNavigator.this._entryTable.getColumnWidth(0);
                int n2 = dimension.width - n;
                KeywordNavigator.this._entryTable.setColumnWidth(1, n2);
            }
        }

        public void rowResizing(TableEvent tableEvent) {
        }

        public void rowResized(TableEvent tableEvent) {
        }
    }
}

