/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.keywordNavigator;

import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Collections;
import java.util.List;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.StringComparator;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.KeywordIndexItem;
import oracle.help.common.navigator.keywordNavigator.TopicBaseBean;
import oracle.help.common.util.java.StaticLocaleContext;

public class KeywordIndexItemAdapter
extends SortableTwoDModel
implements HeaderItemInputHandler {
    private int lastColumnClicked = -1;
    private boolean invertSort = false;
    private KeywordIndexItem _indexItem = null;
    public static final int COLUMN_TITLE = 0;
    public static final int COLUMN_SOURCE = 1;

    public KeywordIndexItemAdapter() {
        super(2, 0);
        super.setColumnComparator(0, (Comparator)new EntryTitleComparator());
        super.setColumnComparator(1, (Comparator)new EntryViewComparator());
    }

    public void setCurrentKeywordIndexItem(KeywordIndexItem keywordIndexItem) {
        int n;
        if (keywordIndexItem == this._indexItem) {
            return;
        }
        if (this._indexItem != null) {
            this._indexItem.clearEntries();
        }
        if ((n = super.getRowCount()) > 0) {
            super.removeRows(0, n);
        }
        this._indexItem = keywordIndexItem;
        if (this._indexItem != null) {
            List list = this._indexItem.getEntries();
            int n2 = super.getRowCount();
            super.addRows(n2, list.size());
            for (TopicBaseBean topicBaseBean : list) {
                super.setData(0, n2, (Object)topicBaseBean.getTopic());
                super.setData(1, n2++, (Object)topicBaseBean.getTopicTreeNode().getView());
            }
        }
    }

    public KeywordIndexItem getKeywordIndexItem() {
        return this._indexItem;
    }

    public List getEntries() {
        if (this._indexItem == null) {
            return Collections.EMPTY_LIST;
        }
        return this._indexItem.getEntries();
    }

    public Object getData(int n, int n2) {
        Object object = super.getData(n, n2);
        if (object != null) {
            if (n == 0) {
                Topic topic = (Topic)object;
                return topic.getLabel();
            }
            if (n == 1) {
                View view = (View)object;
                String string = view.getTitle();
                if (string == null) {
                    string = new String("");
                }
                return string;
            }
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
        this.invertSort = n == this.lastColumnClicked ? !this.invertSort : false;
        this.lastColumnClicked = n;
        this.sort(n, !this.invertSort);
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
    }

    class EntryViewComparator
    extends StringComparator {
        EntryViewComparator() {
            super(Collator.getInstance(StaticLocaleContext.getLocale()));
        }

        public int compare(Object object, Object object2) {
            View view = (View)object;
            View view2 = (View)object2;
            return super.compare((Object)view.getTitle(), (Object)view2.getTitle());
        }
    }

    class EntryTitleComparator
    extends StringComparator {
        EntryTitleComparator() {
            super(Collator.getInstance(StaticLocaleContext.getLocale()));
        }

        public int compare(Object object, Object object2) {
            Topic topic = (Topic)object;
            Topic topic2 = (Topic)object2;
            String string = topic.getLabel();
            String string2 = topic2.getLabel();
            return super.compare((Object)string, (Object)string2);
        }
    }
}

