/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.ResourceBundle;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.OneDModelListenerWrapperImpl;
import oracle.help.library.Book;
import oracle.help.library.Library;

public abstract class FavoritesModel {
    public static final String FAVORITES_NAME = "favorites";
    public static final String FAVORITE_ITEM_NAME = "favoriteitem";
    public static final String TEXT_ATTR_NAME = "text";
    public static final String TARGET_ATTR_NAME = "target";
    public static final String HSTITLE_ATTR_NAME = "hstitle";
    public static final String URL_ATTR_NAME = "url";
    private boolean _initialized = false;
    private ResourceBundle _miscBundle;
    private URL _location;
    private Library _library;
    private TopicTreeNode _favoritesNode;

    public FavoritesModel(URL uRL, Library library) {
        this._location = uRL;
        this._library = library;
        this._miscBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle", StaticLocaleContext.getLocale());
        this._favoritesNode = new TopicTreeNode(null, (Topic)new SimpleTopic(this._miscBundle.getString("addfavoriteitem.favorites")));
        TopicTreeNode topicTreeNode = new TopicTreeNode(null, null);
        topicTreeNode.addChild(this._favoritesNode);
    }

    public void addFavoriteItem(String string, String string2, String string3, String string4, TopicTreeNode topicTreeNode) {
        int n;
        TopicTreeNode topicTreeNode2;
        if (topicTreeNode == null) {
            topicTreeNode = this._favoritesNode;
        }
        FavoriteItemTopicTreeNode favoriteItemTopicTreeNode = new FavoriteItemTopicTreeNode(string, string2, string3, string4);
        topicTreeNode.addChild((TopicTreeNode)favoriteItemTopicTreeNode);
        int n2 = topicTreeNode.getNumChildren() - 1;
        Enumeration enumeration = topicTreeNode.getListenerManager().getListeners();
        if (enumeration != null) {
            this._fireAddEvent(enumeration, n2);
        }
        if ((topicTreeNode2 = topicTreeNode.getParent()) != null && (n = topicTreeNode2.getChildren().indexOf(topicTreeNode)) != -1 && (enumeration = topicTreeNode2.getListenerManager().getListeners()) != null) {
            this._fireInvalidateEvent(enumeration, n);
        }
        this.saveFavorites();
    }

    public void renameFavoriteItem(TopicTreeNode topicTreeNode, String string) {
        if (topicTreeNode != null && string != null) {
            Enumeration enumeration;
            int n;
            SimpleTopic simpleTopic;
            Topic topic = topicTreeNode.getTopic();
            if (topic instanceof SimpleTopic) {
                simpleTopic = (SimpleTopic)topic;
                simpleTopic.setLabel(string);
            }
            if ((n = (simpleTopic = topicTreeNode.getParent()).getChildren().indexOf(topicTreeNode)) != -1 && (enumeration = simpleTopic.getListenerManager().getListeners()) != null) {
                this._fireItemTextChangedEvent(enumeration, n);
            }
            this.saveFavorites();
        }
    }

    public void removeFavoriteItem(TopicTreeNode topicTreeNode) {
        if (topicTreeNode != null) {
            int n;
            Object object;
            TopicTreeNode topicTreeNode2 = topicTreeNode.getParent();
            int n2 = topicTreeNode2.removeChild(topicTreeNode);
            Enumeration enumeration = topicTreeNode2.getListenerManager().getListeners();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    object = (EventListener)enumeration.nextElement();
                    if (!(object instanceof OneDModelListenerWrapperImpl)) continue;
                    ((OneDModelListenerWrapperImpl)object).itemRemoved(n2);
                }
            }
            if (topicTreeNode2.getNumChildren() == 0 && (object = topicTreeNode2.getParent()) != null && (n = object.getChildren().indexOf(topicTreeNode2)) != -1 && (enumeration = object.getListenerManager().getListeners()) != null) {
                this._fireInvalidateEvent(enumeration, n);
            }
            this.saveFavorites();
        }
    }

    public TopicTreeNode getFavoritesRoot() {
        if (!this._initialized) {
            this._initialized = true;
            this.restoreFavorites();
        }
        return this._favoritesNode;
    }

    protected abstract void saveFavorites();

    protected abstract void restoreFavorites();

    protected URL getLocation() {
        return this._location;
    }

    private void _fireAddEvent(Enumeration enumeration, int n) {
        while (enumeration.hasMoreElements()) {
            EventListener eventListener = (EventListener)enumeration.nextElement();
            if (!(eventListener instanceof OneDModelListenerWrapperImpl)) continue;
            ((OneDModelListenerWrapperImpl)((Object)eventListener)).itemAdded(n);
        }
    }

    private void _fireInvalidateEvent(Enumeration enumeration, int n) {
        while (enumeration.hasMoreElements()) {
            EventListener eventListener = (EventListener)enumeration.nextElement();
            if (!(eventListener instanceof OneDModelListenerWrapperImpl)) continue;
            ((OneDModelListenerWrapperImpl)((Object)eventListener)).itemInvalidated(n);
        }
    }

    private void _fireItemTextChangedEvent(Enumeration enumeration, int n) {
        while (enumeration.hasMoreElements()) {
            EventListener eventListener = (EventListener)enumeration.nextElement();
            if (!(eventListener instanceof OneDModelListenerWrapperImpl)) continue;
            ((OneDModelListenerWrapperImpl)((Object)eventListener)).itemTextChanged(n);
        }
    }

    private Topic _createTopic(String string, String string2, String string3, String string4) {
        URL uRL;
        Book book = this._library.getBookByName(string3);
        IndirectTarget indirectTarget = null;
        if (string2 != null && book != null) {
            indirectTarget = new IndirectTarget(book, string2);
        } else {
            if (string4 == null) {
                if (string2 == null) {
                    return new SimpleTopic(string);
                }
                uRL = this._library.mapIDToURL(string2);
                if (uRL != null) {
                    string4 = uRL.toString();
                }
            }
            if (string4 != null) {
                indirectTarget = new SimpleURLTarget(null, string4);
            }
        }
        uRL = new SimpleTopic(string, (Target)indirectTarget);
        return uRL;
    }

    protected class FavoriteItemTopicTreeNode
    extends TopicTreeNode {
        public String target;
        public String hstitle;
        public String url;

        public FavoriteItemTopicTreeNode(String string, String string2, String string3, String string4) {
            super(null, FavoritesModel.this._createTopic(string, string2, string3, string4));
            this.target = string2;
            this.hstitle = string3;
            this.url = string4;
        }
    }
}

