/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.favoritesNavigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.util.MnemonicUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesNavigator;
import oracle.help.topicDisplay.TopicDisplay;

public class FavoritesActionUtils {
    private static final String _RENAME = "addfavoriteitem.rename";
    private static final String _TOPIC_NAME = "addfavoriteitem.topicname";
    private static final String _NEW_FOLDER = "addfavoriteitem.newfolder";
    private static final String _FOLDER_NAME = "addfavoriteitem.foldername";

    private FavoritesActionUtils() {
    }

    public static void addFavoriteItem(FavoritesModel favoritesModel, TopicDisplay topicDisplay, Frame frame) {
        String string = topicDisplay.getCurrentPageTitle();
        String string2 = null;
        String string3 = null;
        String string4 = topicDisplay.getCurrentURL().toString();
        new AddFavoriteItemDialog(frame, favoritesModel, string, string2, string3, string4);
    }

    public static void renameFavoriteItem(Component component, TopicTreeNode topicTreeNode, FavoritesModel favoritesModel) {
        if (topicTreeNode != null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle");
            String string = resourceBundle.getString(_RENAME);
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)string, (int)3);
            JPanel jPanel = new JPanel();
            Topic topic = topicTreeNode.getTopic();
            String string2 = topic == null ? "" : topic.getLabel();
            JTextField jTextField = new JTextField(string2, 20);
            jTextField.requestFocus();
            jTextField.getDocument().addDocumentListener(FavoritesActionUtils._getDocumentListenerForRenameTextField(jTextField, jEWTDialog, string2));
            JLabel jLabel = MnemonicUtils.createLabel(resourceBundle.getString(_TOPIC_NAME), jTextField);
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(5));
            jPanel.add(jTextField);
            jEWTDialog.setContent((Component)jPanel);
            jEWTDialog.setResizable(true);
            jEWTDialog.setInitialFocus((Component)jTextField);
            jEWTDialog.setOKButtonEnabled(false);
            if (jEWTDialog.runDialog()) {
                favoritesModel.renameFavoriteItem(topicTreeNode, jTextField.getText().trim());
            }
        }
    }

    public static void createNewFolder(Component component, TopicTreeNode topicTreeNode, FavoritesModel favoritesModel) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle");
        String string = resourceBundle.getString(_NEW_FOLDER);
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)string, (int)3);
        JPanel jPanel = new JPanel();
        JTextField jTextField = new JTextField(StringUtils.stripMnemonic((String)string), 20);
        jTextField.requestFocus();
        JLabel jLabel = MnemonicUtils.createLabel(resourceBundle.getString(_FOLDER_NAME), jTextField);
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jTextField);
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.setResizable(true);
        jEWTDialog.setInitialFocus((Component)jTextField);
        if (jEWTDialog.runDialog()) {
            favoritesModel.addFavoriteItem(jTextField.getText(), null, null, null, topicTreeNode);
        }
    }

    private static DocumentListener _getDocumentListenerForRenameTextField(final JTextField jTextField, final JEWTDialog jEWTDialog, final String string) {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this._updateOKButtonStatus();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this._updateOKButtonStatus();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this._updateOKButtonStatus();
            }

            private void _updateOKButtonStatus() {
                String string2 = jTextField.getText().trim();
                boolean bl = !string2.isEmpty() && !string.equals(string2);
                jEWTDialog.setOKButtonEnabled(bl);
            }
        };
        return documentListener;
    }

    private static class AddFavoriteItemDialog
    extends JDialog
    implements ActionListener {
        private static final String _MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";
        private static final String _CANCEL = "cancel";
        private static final String _KEY_CLOSE = "CLOSE";
        private static final String _ADD_TO_FAVORITES = "addfavoriteitem.addtofavorites";
        private static final String _TOPIC_NAME = "addfavoriteitem.topicname";
        private static final String _CREATE_IN = "addfavoriteitem.createin";
        private static final String _DELETE = "addfavoriteitem.delete";
        private static final String _NEW_FOLDER_DOT = "addfavoriteitem.newfolderdot";
        private static final String _RENAME_DOT = "addfavoriteitem.renamedot";
        private ResourceBundle _miscBundle = null;
        private FavoritesModel _model;
        private JTextField _text;
        private String _target;
        private String _hstitle;
        private String _url;
        private FavoritesNavigator _favoritesNav;
        private JButton _add;
        private JButton _close;
        private JButton _newFolder;
        private JButton _rename;
        private JButton _delete;

        public AddFavoriteItemDialog(Frame frame, FavoritesModel favoritesModel, String string, String string2, String string3, String string4) {
            super(frame, true);
            this._model = favoritesModel;
            this._target = string2;
            this._hstitle = string3;
            this._url = string4;
            this._text = new JTextField(string, 30);
            this._miscBundle = ResourceBundle.getBundle(_MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
            this._buildUI(frame);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._close || _KEY_CLOSE.equals(actionEvent.getActionCommand())) {
                this.setVisible(false);
                this.dispose();
            } else if (object == this._add) {
                this._model.addFavoriteItem(this._text.getText(), this._target, this._hstitle, this._url, this._favoritesNav.getCurrentSelectionNode());
                this.setVisible(false);
                this.dispose();
            } else if (object == this._newFolder) {
                FavoritesActionUtils.createNewFolder(this, this._favoritesNav.getCurrentSelectionNode(), this._model);
            } else if (object == this._rename) {
                FavoritesActionUtils.renameFavoriteItem(this, this._favoritesNav.getCurrentSelectionNode(), this._model);
            } else if (object == this._delete) {
                this._model.removeFavoriteItem(this._favoritesNav.getCurrentSelectionNode());
            }
        }

        private void _buildUI(Frame frame) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel.setLayout(new BorderLayout(10, 15));
            this.getContentPane().add(jPanel);
            Box box = Box.createHorizontalBox();
            JLabel jLabel = MnemonicUtils.createLabel(this._miscBundle.getString("addfavoriteitem.topicname"), this._text);
            box.add(jLabel);
            box.add(Box.createHorizontalStrut(5));
            box.add(this._text);
            this._favoritesNav = new FavoritesNavigator();
            this._favoritesNav.setFavoritesModel(this._model);
            this._favoritesNav.initializeLazyNavigator();
            this._favoritesNav.addTopicTreeListener(new FavoritesListener());
            Box box2 = Box.createHorizontalBox();
            Box box3 = Box.createVerticalBox();
            JLabel jLabel2 = MnemonicUtils.createLabel(this._miscBundle.getString(_CREATE_IN), this._favoritesNav);
            box3.add(jLabel2);
            box2.add(box3);
            box2.add(Box.createHorizontalStrut(20));
            box2.add(this._favoritesNav);
            Box box4 = Box.createVerticalBox();
            box4.add(box);
            box4.add(box2);
            jPanel.add((Component)box4, "Center");
            String string = this._miscBundle.getString(_ADD_TO_FAVORITES);
            this.setTitle(StringUtils.stripMnemonic((String)string));
            this._add = MnemonicUtils.createButton(string);
            this._add.addActionListener(this);
            this._add.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(this._add);
            String string2 = this._miscBundle.getString(_NEW_FOLDER_DOT);
            this._newFolder = MnemonicUtils.createButton(string2);
            this._newFolder.addActionListener(this);
            String string3 = this._miscBundle.getString(_RENAME_DOT);
            this._rename = MnemonicUtils.createButton(string3);
            this._rename.addActionListener(this);
            String string4 = this._miscBundle.getString(_DELETE);
            this._delete = MnemonicUtils.createButton(string4);
            this._delete.addActionListener(this);
            this._close = MnemonicUtils.createButton(this._miscBundle.getString(_CANCEL));
            this._close.addActionListener(this);
            Box box5 = Box.createVerticalBox();
            box5.add(Box.createVerticalStrut(20));
            box5.add(this._add);
            box5.add(Box.createVerticalStrut(5));
            box5.add(this._close);
            box5.add(Box.createVerticalStrut(25));
            box5.add(this._newFolder);
            box5.add(Box.createVerticalStrut(5));
            box5.add(this._newFolder);
            box5.add(Box.createVerticalStrut(5));
            box5.add(this._rename);
            box5.add(Box.createVerticalStrut(5));
            box5.add(this._delete);
            jPanel.add((Component)box5, "East");
            this.addWindowListener(WindowUtils.getWindowCloser());
            JRootPane jRootPane = this.getRootPane();
            jRootPane.registerKeyboardAction(this, _KEY_CLOSE, KeyStroke.getKeyStroke(27, 0), 1);
            this.pack();
            WindowUtils.centerWindow((Window)this, (Component)frame);
            this.setVisible(true);
            this._add.grabFocus();
        }

        private class FavoritesListener
        implements TopicTreeListener {
            private FavoritesListener() {
            }

            public void topicActivated(TopicTreeItem topicTreeItem, boolean bl) {
            }

            public void topicSelected(TopicTreeItem topicTreeItem) {
                if (topicTreeItem == null || topicTreeItem != null && topicTreeItem.getTopicTreeNode() == AddFavoriteItemDialog.this._model.getFavoritesRoot()) {
                    AddFavoriteItemDialog.this._rename.setEnabled(false);
                    AddFavoriteItemDialog.this._delete.setEnabled(false);
                } else {
                    AddFavoriteItemDialog.this._rename.setEnabled(true);
                    AddFavoriteItemDialog.this._delete.setEnabled(true);
                }
            }

            public void popupDisplayed(TopicTreeItem topicTreeItem, JPopupMenu jPopupMenu) {
            }
        }
    }
}

