/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.tree;

import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dTree.DTreeActivateListener;
import oracle.bali.ewt.dTree.DTreeItemEvent;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeEvent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TreeComponentPopupListener;

public class TopicTreePane
extends JScrollPane {
    private TopicTreeComponent _tree;
    private ListenerManager _listeners;

    public TopicTreePane(TopicTreeComponent topicTreeComponent) {
        super((Component)((Object)topicTreeComponent), 20, 30);
        this._tree = topicTreeComponent;
        TreeListener treeListener = new TreeListener();
        topicTreeComponent.addActivateListener(treeListener);
        topicTreeComponent.addPropertyChangeListener(treeListener);
        topicTreeComponent.addPopupRequestListener(treeListener);
        this._listeners = new ListenerManager();
    }

    public TopicTreeComponent getTopicTreeComponent() {
        return this._tree;
    }

    public TopicTreeItem getSelectedItem() {
        return (TopicTreeItem)this._tree.getSelection().getFirstItem();
    }

    public boolean selectTopicTreeNode(TopicTreeNode topicTreeNode) {
        boolean bl = false;
        if (this._tree != null) {
            bl = this._tree.selectTopicTreeNode(topicTreeNode);
        }
        return bl;
    }

    public void addTopicTreeListener(TopicTreeListener topicTreeListener) {
        this._listeners.addListener((EventListener)topicTreeListener);
    }

    public void removeTopicTreeListener(TopicTreeListener topicTreeListener) {
        this._listeners.removeListener((EventListener)topicTreeListener);
    }

    private class TreeListener
    implements DTreeActivateListener,
    PropertyChangeListener,
    TreeComponentPopupListener {
        private boolean _popupActive = false;

        private TreeListener() {
        }

        public void dTreeItemActivate(DTreeItemEvent dTreeItemEvent) {
            if (dTreeItemEvent.getID() == 2004) {
                this._fireTopicActivated((TopicTreeItem)dTreeItemEvent.getItem(), false);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TopicTreeItem topicTreeItem = (TopicTreeItem)TopicTreePane.this._tree.getSelection().getFirstItem();
            Enumeration enumeration = TopicTreePane.this._listeners.getListeners();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    ((TopicTreeListener)enumeration.nextElement()).topicSelected(topicTreeItem);
                }
            }
        }

        public void popupRequested(TopicTreeEvent topicTreeEvent, Point point) {
            if (!this._popupActive) {
                if (topicTreeEvent != null && topicTreeEvent.getID() == 2002) {
                    Point point2 = TopicTreePane.this.getViewport().getViewPosition();
                    TopicTreeItem topicTreeItem = topicTreeEvent.getTopicTreeItem();
                    TreePanePopup treePanePopup = new TreePanePopup();
                    Enumeration enumeration = TopicTreePane.this._listeners.getListeners();
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            TopicTreeListener topicTreeListener = (TopicTreeListener)enumeration.nextElement();
                            topicTreeListener.popupDisplayed(topicTreeItem, treePanePopup);
                        }
                    }
                    if (treePanePopup.getSubElements().length > 0) {
                        MenuUtils.showPopupMenu((JPopupMenu)treePanePopup, (Component)((Object)TopicTreePane.this._tree), (int)(point.x - point2.x), (int)(point.y - point2.y));
                        this._popupActive = true;
                    }
                } else {
                    this._popupActive = false;
                }
            }
        }

        private void _fireTopicActivated(TopicTreeItem topicTreeItem, boolean bl) {
            Enumeration enumeration = TopicTreePane.this._listeners.getListeners();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TopicTreeListener topicTreeListener = (TopicTreeListener)enumeration.nextElement();
                    topicTreeListener.topicActivated(topicTreeItem, bl);
                }
            }
        }

        private class TreePanePopup
        extends JPopupMenu {
            private TreePanePopup() {
            }

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (!bl) {
                    TreeListener.this._popupActive = false;
                }
            }
        }
    }
}

