/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.tree;

import java.awt.Point;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeEvent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeModel;
import oracle.help.java.tree.TreeComponentPopupListener;

public class TopicTreeComponent
extends DTree {
    private TopicTreeNode _rootTopicTreeNode;
    private DTreeDeferringRoot _root;
    private ListenerManager _listeners;
    private TopicTreeNode _queuedSelection;

    public TopicTreeComponent(TopicTreeNode topicTreeNode, DTreeItemFactory dTreeItemFactory) {
        this._rootTopicTreeNode = topicTreeNode;
        this._listeners = new ListenerManager();
        this._queuedSelection = null;
        this._root = new DTreeDeferringRoot(null, null, (OneDModel)new TopicTreeModel(topicTreeNode), dTreeItemFactory);
        this.setRoot((DTreeRootItem)this._root);
    }

    public boolean selectTopicTreeNode(TopicTreeNode topicTreeNode) {
        boolean bl = false;
        if (this.isVisible()) {
            if (topicTreeNode != null) {
                this._selectNode(topicTreeNode);
                bl = true;
            } else {
                this._deselectAll();
            }
        } else {
            this._queuedSelection = topicTreeNode;
        }
        return bl;
    }

    public void addPopupRequestListener(TreeComponentPopupListener treeComponentPopupListener) {
        if (treeComponentPopupListener != null) {
            this._listeners.addListener((EventListener)treeComponentPopupListener);
        }
    }

    public void removePopupRequestListener(TreeComponentPopupListener treeComponentPopupListener) {
        if (treeComponentPopupListener != null) {
            this._listeners.removeListener((EventListener)treeComponentPopupListener);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            super.setVisible(true);
            if (this._queuedSelection == null) {
                this._deselectAll();
            } else {
                this._selectNode(this._queuedSelection);
            }
        } else {
            this._queuedSelection = this._getCurrentSelection();
            super.setVisible(false);
        }
    }

    public void firePopupRequested(TopicTreeEvent topicTreeEvent, Point point) {
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreeComponentPopupListener treeComponentPopupListener = (TreeComponentPopupListener)enumeration.nextElement();
                treeComponentPopupListener.popupRequested(topicTreeEvent, point);
            }
        }
    }

    private void _deselectAll() {
        try {
            this.setSelection(new DTreeSelection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TopicTreeNode _getCurrentSelection() {
        TopicTreeNode topicTreeNode = null;
        if (this.isVisible()) {
            DTreeSelection dTreeSelection = this.getSelection();
            if (dTreeSelection.getCount() != 0) {
                TopicTreeItem topicTreeItem = (TopicTreeItem)dTreeSelection.getFirstItem();
                topicTreeNode = topicTreeItem.getTopicTreeNode();
            }
        } else {
            topicTreeNode = this._queuedSelection;
        }
        return topicTreeNode;
    }

    private synchronized void _selectNode(TopicTreeNode topicTreeNode) {
        if (topicTreeNode != null) {
            this._recursiveExpansion(topicTreeNode.getParent());
            DTreeItem dTreeItem = (DTreeItem)topicTreeNode.getClientData();
            if (dTreeItem != null) {
                this.makeVisible(dTreeItem);
                try {
                    this.getSelectionManager().selectItem(dTreeItem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void _recursiveExpansion(TopicTreeNode topicTreeNode) {
        if (topicTreeNode != null) {
            this._recursiveExpansion(topicTreeNode.getParent());
            DTreeItem dTreeItem = (DTreeItem)topicTreeNode.getClientData();
            if (dTreeItem != null) {
                dTreeItem.setExpanded(true);
                int n = dTreeItem.getItemCount();
                for (int i = 0; i < n; ++i) {
                    DTreeItem dTreeItem2 = dTreeItem.getItem(i);
                }
            }
        }
    }
}

