/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.protocol;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import oracle.help.CustomProtocolHandler;
import oracle.help.common.util.java.StaticLocaleContext;

public class DefaultExternalProtocolHandler
implements CustomProtocolHandler {
    private static final String EXTERNAL_ERROR_MESSAGE = "external.errormessage";
    private static final String EXTERNAL_ERROR_DIALOG_TITLE = "external.errordialogtitle";
    private static final String MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";

    public void handleValue(String string) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                URI uRI = null;
                try {
                    uRI = new URI(string);
                    desktop.browse(uRI);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            } else {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
                JOptionPane.showMessageDialog(new JFrame(), resourceBundle.getString(EXTERNAL_ERROR_MESSAGE), resourceBundle.getString(EXTERNAL_ERROR_DIALOG_TITLE), 1);
            }
        }
    }
}

