/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.CustomProtocolHandler;
import oracle.help.DefaultNavigatorPanel;
import oracle.help.DefaultTopicPanel;
import oracle.help.WindowManager;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.WindowType;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.java.protocol.DefaultExternalProtocolHandler;
import oracle.help.library.Library;
import oracle.help.library.helpset.HelpSet;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.CustomProtocolRegistry;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class DefaultWindowManager
implements WindowManager,
TopicDisplayListener {
    private static final String _EWT_WINDOWUTILS = "oracle.ewt.util.WindowUtils";
    private static final String _GET_ACTIVE_WINDOW_METHOD = "getActiveWindow";
    private static Method _ewtActiveWindowMethod = null;
    private DefaultTopicPanel _activePanel;
    private DefaultTopicPanel _dockedPanel;
    private DefaultNavigatorPanel _navigatorPanel;
    private Library _library;
    private HelpWindowTracker _windowTracker;
    private Dialog _modalOwner = null;
    private boolean _standAloneMode;
    private boolean _modalMode;
    private boolean _silentMode;
    private boolean _dockedByDefault = false;
    private boolean _dockOnNextShow = false;
    private boolean _homeIDDisplayAlreadyChecked = false;
    private boolean _shouldTryLoadingEwtWindowUtils = true;
    private Vector _workingPanels;
    private Vector _cachedPanels;
    private Class _htmlBrowserClass;
    private Rectangle _bounds = null;
    private CustomProtocolRegistry _cpr;
    private FavoritesModel _favoritesModel;

    public DefaultWindowManager(Class clazz, DefaultNavigatorPanel defaultNavigatorPanel, Library library) {
        this(clazz, defaultNavigatorPanel, library, false, false);
    }

    public DefaultWindowManager(Class clazz, DefaultNavigatorPanel defaultNavigatorPanel, Library library, boolean bl, boolean bl2) {
        this._standAloneMode = bl;
        this._dockedByDefault = bl2;
        this._workingPanels = new Vector();
        this._cachedPanels = new Vector();
        this._activePanel = null;
        this._htmlBrowserClass = clazz;
        this._navigatorPanel = defaultNavigatorPanel;
        this._navigatorPanel.setWindowManager(this);
        this._library = library;
        this._windowTracker = new HelpWindowTracker();
        this._modalMode = false;
        if (this._dockedByDefault) {
            this._dockOnNextShow = true;
        }
        this._cpr = new CustomProtocolRegistry();
    }

    public void displayTopic(Topic topic, boolean bl, Point point, Dimension dimension) throws TopicDisplayException {
        DefaultTopicPanel defaultTopicPanel = this._setupTopicWindow(bl);
        Window window = defaultTopicPanel.getCurrentTopicWindow();
        try {
            if (topic.hasTarget()) {
                URL uRL = topic.getTarget().getURL();
                String string = this._library.mapURLToWindowTypeName(uRL);
                WindowType windowType = this._library.getWindowType(string);
                if ("external".equals(string) && windowType == null) {
                    CustomProtocolHandler customProtocolHandler = this._cpr.getCustomProtocolHandler("external");
                    if (customProtocolHandler == null) {
                        customProtocolHandler = new DefaultExternalProtocolHandler();
                    }
                    customProtocolHandler.handleValue(uRL.toExternalForm());
                    return;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this._dockedPanel == null && this._dockOnNextShow) {
            this._dockOnNextShow = false;
            this._silentMode = true;
            defaultTopicPanel.dockTopicPanel();
            this._silentMode = false;
            window = null;
        }
        defaultTopicPanel.displayTopic(topic);
        if (defaultTopicPanel == this._dockedPanel) {
            this.showNavigatorWindow();
        }
        if (window != null) {
            if (point != null) {
                window.setLocation(point);
            }
            if (dimension != null) {
                window.setSize(dimension);
            }
            if (!window.isVisible() && !this._silentMode) {
                window.setVisible(true);
            }
            if (window.isVisible()) {
                this._ensureNotMinimized(window);
                window.toFront();
            }
        }
    }

    public Class getHTMLBrowser() {
        return this._htmlBrowserClass;
    }

    public DefaultTopicPanel getActivePanel() {
        if (this._activePanel == null) {
            this._activePanel = this._dockedPanel != null ? this._dockedPanel : (this._workingPanels.size() != 0 ? (DefaultTopicPanel)this._workingPanels.lastElement() : this.createTopicPanel());
        }
        return this._activePanel;
    }

    public synchronized DefaultTopicPanel createTopicPanel() {
        DefaultTopicPanel defaultTopicPanel = null;
        if (this._cachedPanels.size() != 0) {
            defaultTopicPanel = (DefaultTopicPanel)this._cachedPanels.lastElement();
            this._cachedPanels.removeElement(defaultTopicPanel);
            this._workingPanels.addElement(defaultTopicPanel);
        } else {
            HTMLBrowser hTMLBrowser = null;
            try {
                hTMLBrowser = (HTMLBrowser)this._htmlBrowserClass.newInstance();
                hTMLBrowser.setLocale(StaticLocaleContext.getLocale());
                if (StaticLocaleContext.getEncoding() != null) {
                    hTMLBrowser.setCharset(StaticLocaleContext.getEncoding());
                }
                this._cpr.attachBrowser(hTMLBrowser);
            }
            catch (Exception exception) {
                System.err.println("Failed to create instance of " + this._htmlBrowserClass);
                System.err.println("Cannot create Topic Display");
                return null;
            }
            BrowserTopicDisplay browserTopicDisplay = new BrowserTopicDisplay(hTMLBrowser, this._library);
            defaultTopicPanel = new DefaultTopicPanel(browserTopicDisplay, this);
            this._workingPanels.addElement(defaultTopicPanel);
        }
        defaultTopicPanel.addDisplayListener(this);
        return defaultTopicPanel;
    }

    public void showNavigatorWindow() {
        Window window = this._setupNavigatorWindow();
        if (this._dockedPanel == null && this._dockOnNextShow) {
            DefaultTopicPanel defaultTopicPanel = this._setupTopicWindow(false);
            this._silentMode = true;
            defaultTopicPanel.dockTopicPanel();
            this._silentMode = false;
            this._dockOnNextShow = false;
            this._checkDisplayHomeIDPage();
        }
        if (!window.isVisible() && !this._silentMode) {
            window.setVisible(true);
        }
        if (window.isVisible() && !this._modalMode) {
            this._ensureNotMinimized(window);
            window.toFront();
        }
    }

    public void hideNavigatorWindow() {
        Window window = this._navigatorPanel.getCurrentNavigatorWindow();
        if (window != null && window.isVisible()) {
            window.setVisible(false);
        }
        if (window instanceof Dialog && !this._javaVersionEqualOrGreater(1, 4, 1)) {
            this._windowTracker.unregisterWindow(window);
            this._navigatorPanel.disposeNavigatorDialog();
        }
        this._checkStandAloneExit();
    }

    public void hideAllWindows() {
        this.hideNavigatorWindow();
        for (int i = this._workingPanels.size() - 1; i >= 0; --i) {
            DefaultTopicPanel defaultTopicPanel = (DefaultTopicPanel)this._workingPanels.elementAt(i);
            defaultTopicPanel.reclaimTopicPanel();
        }
    }

    public void dockTopicPanel(DefaultTopicPanel defaultTopicPanel) {
        if (defaultTopicPanel != null) {
            Window window = this._setupNavigatorWindow();
            if (this._dockedPanel != null) {
                this._dockedPanel.undockTopicPanel();
            }
            this._workingPanels.removeElement(defaultTopicPanel);
            Window window2 = defaultTopicPanel.getCurrentTopicWindow();
            if (window2 != null) {
                this._windowTracker.unregisterWindow(window2);
                if (window2 instanceof Dialog) {
                    defaultTopicPanel.disposeTopicDialog();
                } else {
                    defaultTopicPanel.disposeTopicFrame();
                }
            }
            this._navigatorPanel.dockTopicPanel(defaultTopicPanel);
            this._windowTracker.registerWindow(window, defaultTopicPanel);
            this._dockedPanel = defaultTopicPanel;
            this._activePanel = defaultTopicPanel;
            if (!this._silentMode) {
                this.showNavigatorWindow();
            }
        }
    }

    public void undockTopicPanel() {
        if (this._dockedPanel != null) {
            Dimension dimension = this._dockedPanel.getSize();
            this._navigatorPanel.undockTopicPanel();
            Window window = this._navigatorPanel.getCurrentNavigatorWindow();
            if (window != null && window.isVisible()) {
                this._workingPanels.addElement(this._dockedPanel);
                Dimension dimension2 = window.getSize();
                Dimension dimension3 = this._navigatorPanel.getSize();
                Window window2 = null;
                window2 = window instanceof Dialog ? this._dockedPanel.createTopicWindowDialog(this._getActiveModalOwnerDialog()) : this._dockedPanel.createTopicWindowFrame();
                this._windowTracker.unregisterWindow(window);
                this._windowTracker.registerWindow(window2, this._dockedPanel);
                int n = dimension.width + (dimension2.width - dimension3.width);
                int n2 = dimension.height + (dimension2.height - dimension3.height);
                window2.setSize(n, n2);
                window2.setLocation(window.getLocation().x + dimension2.width + 20, window.getLocation().y);
                if (!this._silentMode) {
                    window2.setVisible(true);
                }
            } else {
                this._dockedPanel.reclaimTopicPanel();
            }
            this._dockedPanel = null;
        }
    }

    public void topicDisplayChanged(TopicDisplayEvent topicDisplayEvent) {
        if (topicDisplayEvent != null && topicDisplayEvent.getID() == 2000 && topicDisplayEvent.getChangeType() == 0) {
            this._synchronizeNavigators(topicDisplayEvent.getURL());
        }
    }

    public synchronized void dispose() {
        DefaultTopicPanel defaultTopicPanel;
        int n;
        if (this._dockedPanel != null) {
            this._dockedPanel.undockTopicPanel();
        }
        this._navigatorPanel.dispose();
        for (n = 0; n < this._workingPanels.size(); ++n) {
            defaultTopicPanel = (DefaultTopicPanel)this._workingPanels.elementAt(n);
            defaultTopicPanel.dispose();
        }
        for (n = 0; n < this._cachedPanels.size(); ++n) {
            defaultTopicPanel = (DefaultTopicPanel)this._cachedPanels.elementAt(n);
            defaultTopicPanel.dispose();
        }
        this._cachedPanels.removeAllElements();
        this._workingPanels.removeAllElements();
        this._activePanel = null;
        this._htmlBrowserClass = null;
        this._library = null;
        this._navigatorPanel = null;
        this._windowTracker = null;
    }

    public boolean isNewWindowSupported() {
        return true;
    }

    public boolean isPrintingSupported() {
        return true;
    }

    public void printTopics(Topic[] topicArray) {
        if (topicArray != null) {
            HTMLBrowser hTMLBrowser = null;
            try {
                hTMLBrowser = (HTMLBrowser)this._htmlBrowserClass.newInstance();
                hTMLBrowser.setLocale(StaticLocaleContext.getLocale());
                if (StaticLocaleContext.getEncoding() != null) {
                    hTMLBrowser.setCharset(StaticLocaleContext.getEncoding());
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to create instance of " + this._htmlBrowserClass);
                System.err.println("Cannot create Topic Display");
                return;
            }
            BrowserTopicDisplay browserTopicDisplay = new BrowserTopicDisplay(hTMLBrowser, this._library);
            TopicPrintJob topicPrintJob = browserTopicDisplay.getTopicPrintJob();
            if (topicPrintJob != null) {
                topicPrintJob.printTopics(topicArray);
            }
        }
    }

    public synchronized void reclaimTopicPanel(DefaultTopicPanel defaultTopicPanel) {
        Window window = defaultTopicPanel.getCurrentTopicWindow();
        if (window != null) {
            this._bounds = window.getBounds();
        }
        if (this._activePanel == defaultTopicPanel) {
            this._activePanel = null;
        }
        defaultTopicPanel.clearDocumentStack();
        this._workingPanels.removeElement(defaultTopicPanel);
        this._cachedPanels.addElement(defaultTopicPanel);
        if (window instanceof Dialog && !this._javaVersionEqualOrGreater(1, 4, 1)) {
            this._windowTracker.unregisterWindow(window);
            defaultTopicPanel.disposeTopicDialog();
        }
        this._checkStandAloneExit();
    }

    public void registerCustomProtocolHandler(String string, CustomProtocolHandler customProtocolHandler) {
        this._cpr.registerCustomProtocolHandler(string, customProtocolHandler);
    }

    public void setFavoritesModel(FavoritesModel favoritesModel) {
        this._favoritesModel = favoritesModel;
    }

    public FavoritesModel getFavoritesModel() {
        return this._favoritesModel;
    }

    private int _getVisibleTopicWindowCount() {
        int n = 0;
        for (int i = 0; i < this._workingPanels.size(); ++i) {
            DefaultTopicPanel defaultTopicPanel = (DefaultTopicPanel)this._workingPanels.elementAt(i);
            Window window = defaultTopicPanel.getCurrentTopicWindow();
            if (window == null || !window.isVisible()) continue;
            ++n;
        }
        return n;
    }

    private void _checkDisplayHomeIDPage() {
        if (!this._homeIDDisplayAlreadyChecked) {
            SimpleTopic simpleTopic;
            String string = null;
            SimpleTopic simpleTopic2 = null;
            if (this._library != null && (simpleTopic = this._library.getBooks()) != null) {
                for (int i = 0; i < ((SimpleTopic)simpleTopic).length; ++i) {
                    SimpleTopic simpleTopic3 = simpleTopic[i];
                    if (!(simpleTopic3 instanceof HelpSet) || (string = ((HelpSet)simpleTopic3).getHomeID()) == null) continue;
                    simpleTopic2 = simpleTopic3;
                    break;
                }
            }
            if (string != null) {
                simpleTopic = new SimpleTopic();
                simpleTopic.setTarget((Target)new IndirectTarget(simpleTopic2, string));
                this._dockedPanel.displayTopic((Topic)simpleTopic);
            }
            this._homeIDDisplayAlreadyChecked = true;
        }
    }

    private void _checkModalMode() {
        Dialog dialog = this._getActiveModalOwnerDialog();
        boolean bl = false;
        if (dialog != null) {
            bl = true;
        }
        if (bl && !this._modalMode) {
            this._disposeHelpFrames();
            this._modalMode = true;
        } else if (this._modalMode) {
            if (!bl) {
                this._disposeHelpDialogs();
                this._modalMode = false;
            } else if (dialog != this._modalOwner) {
                this._disposeHelpDialogs();
            }
        }
        this._modalOwner = dialog;
    }

    private DefaultTopicPanel _setupTopicWindow(boolean bl) {
        Window window = null;
        DefaultTopicPanel defaultTopicPanel = null;
        this._checkModalMode();
        defaultTopicPanel = bl ? this.createTopicPanel() : this.getActivePanel();
        if (defaultTopicPanel == this._dockedPanel) {
            window = null;
        } else {
            window = defaultTopicPanel.getCurrentTopicWindow();
            if (window == null) {
                if (this._modalMode) {
                    JDialog jDialog = defaultTopicPanel.createTopicWindowDialog(this._getActiveModalOwnerDialog());
                    window = jDialog;
                } else {
                    window = defaultTopicPanel.createTopicWindowFrame();
                }
                this._setInitialPosition(window);
                this._windowTracker.registerWindow(window, defaultTopicPanel);
            }
        }
        return defaultTopicPanel;
    }

    private Window _setupNavigatorWindow() {
        this._checkModalMode();
        Window window = this._navigatorPanel.getCurrentNavigatorWindow();
        if (window == null) {
            if (this._modalMode) {
                JDialog jDialog = this._navigatorPanel.createNavigatorDialog(this._getActiveModalOwnerDialog());
                window = jDialog;
            } else {
                window = this._navigatorPanel.createNavigatorFrame();
            }
        }
        return window;
    }

    private void _disposeHelpFrames() {
        this.hideAllWindows();
        this._navigatorPanel.disposeNavigatorFrame();
        for (int i = this._cachedPanels.size() - 1; i >= 0; --i) {
            DefaultTopicPanel defaultTopicPanel = (DefaultTopicPanel)this._cachedPanels.elementAt(i);
            Window window = defaultTopicPanel.getCurrentTopicWindow();
            if (window == null || !(window instanceof Frame)) continue;
            this._windowTracker.unregisterWindow(window);
            defaultTopicPanel.disposeTopicFrame();
        }
    }

    private void _disposeHelpDialogs() {
        this.hideAllWindows();
        this._navigatorPanel.disposeNavigatorDialog();
        for (int i = this._cachedPanels.size() - 1; i >= 0; --i) {
            DefaultTopicPanel defaultTopicPanel = (DefaultTopicPanel)this._cachedPanels.elementAt(i);
            Window window = defaultTopicPanel.getCurrentTopicWindow();
            if (!(window instanceof Dialog)) continue;
            this._windowTracker.unregisterWindow(window);
            defaultTopicPanel.disposeTopicDialog();
        }
    }

    private void _setInitialPosition(Window window) {
        Toolkit toolkit = window.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = window.getSize();
        int n = dimension.width - dimension2.width - 10;
        int n2 = 10;
        Window window2 = this._navigatorPanel.getCurrentNavigatorWindow();
        if (window2 != null && window2.isVisible()) {
            Dimension dimension3 = window2.getSize();
            Point point = window2.getLocation();
            n = point.x + dimension3.width;
            n2 = point.y;
        }
        int n3 = this._workingPanels.size();
        n2 += 24 * (n3 - 1);
        if (dimension.width < (n += 24 * (n3 - 1 + 1)) + dimension2.width) {
            n = dimension.width - dimension2.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (dimension.height < n2 + dimension2.height) {
            n2 = dimension.height - dimension2.height;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        window.setLocation(n, n2);
    }

    private void _ensureNotMinimized(Window window) {
        Frame frame;
        if (window instanceof Frame && (frame = (Frame)window).getState() == 1) {
            frame.setState(0);
        }
    }

    private void _synchronizeNavigators(URL uRL) {
        final URL uRL2 = uRL;
        if (SwingUtilities.isEventDispatchThread()) {
            this._navigatorPanel.synchronizeNavigators(uRL2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultWindowManager.this._navigatorPanel.synchronizeNavigators(uRL2);
                }
            });
        }
    }

    private void _checkStandAloneExit() {
        if (this._standAloneMode && !this._navigatorPanel.isShowing() && this._workingPanels.size() == 0) {
            System.exit(0);
        }
    }

    private Dialog _getActiveModalOwnerDialog() {
        Serializable serializable;
        Window window = WindowUtils.getActiveWindow();
        if (window == null) {
            try {
                if (this._shouldTryLoadingEwtWindowUtils) {
                    this._shouldTryLoadingEwtWindowUtils = false;
                    serializable = Thread.currentThread().getContextClassLoader().loadClass(_EWT_WINDOWUTILS);
                    if (serializable != null) {
                        _ewtActiveWindowMethod = serializable.getMethod(_GET_ACTIVE_WINDOW_METHOD, null);
                    }
                }
                if (_ewtActiveWindowMethod != null) {
                    window = (Window)_ewtActiveWindowMethod.invoke(null, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        serializable = null;
        while (window != null) {
            Dialog dialog;
            if (window instanceof Dialog && (dialog = (Dialog)window).isModal()) {
                serializable = dialog;
                break;
            }
            window = (Window)window.getParent();
        }
        return serializable;
    }

    private boolean _javaVersionEqualOrGreater(int n, int n2, int n3) {
        boolean bl = false;
        String string = null;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        try {
            string = System.getProperty("java.version");
        }
        catch (Throwable throwable) {
            return false;
        }
        try {
            int n7 = string.indexOf(".");
            n4 = Integer.parseInt(string.substring(0, n7));
            string = string.substring(n7 + 1);
            n7 = string.indexOf(".");
            n5 = Integer.parseInt(string.substring(0, n7));
            string = string.substring(n7 + 1);
            n7 = string.indexOf(".");
            if (n7 != -1) {
                string = string.substring(0, n7);
            }
            n6 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n4 > n) {
            bl = true;
        } else if (n4 == n) {
            if (n5 > n2) {
                bl = true;
            } else if (n5 == n2 && n6 >= n3) {
                bl = true;
            }
        }
        return bl;
    }

    private class HelpWindowTracker
    extends WindowAdapter {
        private Hashtable _windowTable = new Hashtable();

        public void windowActivated(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            DefaultTopicPanel defaultTopicPanel = (DefaultTopicPanel)this._windowTable.get(window);
            if (defaultTopicPanel != null) {
                DefaultWindowManager.this._synchronizeNavigators(defaultTopicPanel.getCurrentURL());
            }
        }

        public void registerWindow(Window window, DefaultTopicPanel defaultTopicPanel) {
            if (window != null && defaultTopicPanel != null) {
                this._windowTable.put(window, defaultTopicPanel);
                window.addWindowListener(this);
            }
        }

        public void unregisterWindow(Window window) {
            if (window != null) {
                window.removeWindowListener(this);
                this._windowTable.remove(window);
            }
        }
    }
}

