/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Target;
import oracle.help.common.util.Canonicalizer;
import oracle.help.library.helpset.HelpSet;
import oracle.help.library.helpset.HelpSetParseException;

public class HelpSetSection {
    private HelpSet _helpSet;
    private String _helpSetDir;
    private String _identifier;
    private String _descriptiveTypeName;
    private String _typeClass;
    private String _descriptiveEngineName;
    private String _engineClass;
    private String _engineParams;
    private String _dataLocationString;
    private String _classAttribute;
    private String _viewBasePath;
    private String _viewTitle;
    private String _viewLabel;
    private String _viewName;
    private String _titleImageString;
    private String _labelImageString;
    private boolean _completed = false;

    public HelpSetSection(HelpSet helpSet, String string) {
        this._helpSet = helpSet;
        this._helpSetDir = string;
        this._identifier = null;
        this._viewTitle = null;
        this._viewLabel = null;
        this._viewName = null;
        this._descriptiveTypeName = null;
        this._typeClass = null;
        this._descriptiveEngineName = null;
        this._engineClass = null;
        this._dataLocationString = null;
        this._classAttribute = null;
        this._titleImageString = null;
        this._labelImageString = null;
        this._completed = false;
    }

    public HelpSet getHelpSet() {
        return this._helpSet;
    }

    public String getHelpSetDir() {
        return this._helpSetDir;
    }

    public String getHelpSetEncoding() {
        return this._helpSet.getHelpSetEncoding();
    }

    public void setIdentifier(String string) {
        this._identifier = string;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public void setDescriptiveTypeName(String string) {
        this._descriptiveTypeName = string;
    }

    public String getDescriptiveTypeName() {
        return this._descriptiveTypeName;
    }

    public void setTypeClass(String string) {
        this._typeClass = string;
    }

    public String getTypeClass() {
        return this._typeClass;
    }

    public void setDescriptiveEngineName(String string) {
        this._descriptiveEngineName = string;
    }

    public String getDescriptiveEngineName() {
        return this._descriptiveEngineName;
    }

    public void setEngineClass(String string) {
        this._engineClass = string;
    }

    public void setEngineParams(String string) {
        this._engineParams = string;
    }

    public String getEngineParams() {
        return this._engineParams;
    }

    public String getEngineClass() {
        return this._engineClass;
    }

    public void setDataLocationString(String string) {
        this._dataLocationString = string;
    }

    public String getDataLocationString() {
        return this._dataLocationString;
    }

    public URL getDataLocationURL() throws HelpSetParseException {
        URL uRL = null;
        try {
            if (this._dataLocationString != null) {
                uRL = this._classAttribute != null && !this._classAttribute.equals("") ? Class.forName(this._classAttribute).getResource(this._dataLocationString) : Canonicalizer.getAbsoluteURL(this._helpSetDir, this._dataLocationString);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new HelpSetParseException("Bad URL: " + malformedURLException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HelpSetParseException("Class not found: " + this._classAttribute);
        }
        if (uRL != null) {
            this._viewBasePath = uRL.toString();
            Canonicalizer.fixSeparators(this._viewBasePath);
            this._viewBasePath = this._viewBasePath.substring(0, this._viewBasePath.lastIndexOf(47) + 1);
        }
        return uRL;
    }

    public void setClassAttribute(String string) {
        this._classAttribute = string;
    }

    public String getClassAttribute() {
        return this._classAttribute;
    }

    public void setViewBasePath(String string) {
        this._viewBasePath = string;
    }

    public String getViewBasePath() {
        return this._viewBasePath;
    }

    public void setViewTitle(String string) {
        this._viewTitle = string;
    }

    public String getViewTitle() {
        return this._viewTitle;
    }

    public void setViewLabel(String string) {
        this._viewLabel = string;
    }

    public String getViewLabel() {
        return this._viewLabel;
    }

    public void setViewName(String string) {
        this._viewName = string;
    }

    public String getViewName() {
        return this._viewName;
    }

    public void setTitleImageString(String string) {
        this._titleImageString = string;
    }

    public String getTitleImageString() {
        return this._titleImageString;
    }

    public Target getTitleImageTarget() {
        IndirectTarget indirectTarget = null;
        if (this._titleImageString != null) {
            indirectTarget = new IndirectTarget(this._helpSet, this._titleImageString);
        }
        return indirectTarget;
    }

    public void setLabelImageString(String string) {
        this._labelImageString = string;
    }

    public String getLabelImageString() {
        return this._labelImageString;
    }

    public Target getLabelImageTarget() {
        IndirectTarget indirectTarget = null;
        if (this._labelImageString != null) {
            indirectTarget = new IndirectTarget(this._helpSet, this._labelImageString);
        }
        return indirectTarget;
    }

    public boolean isCompleted() {
        return this._completed;
    }

    public void setCompleted(boolean bl) {
        this._completed = bl;
    }
}

