/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.AssociativeLink;
import oracle.help.common.AssociativeLinkRepository;
import oracle.help.common.View;
import oracle.help.common.WindowType;
import oracle.help.common.WindowTypeRepository;
import oracle.help.library.Book;
import oracle.help.library.LibraryEvent;
import oracle.help.library.LibraryException;
import oracle.help.library.LibraryListener;

public class Library {
    private ArrayList _books = new ArrayList();
    private ListenerManager _listeners = new ListenerManager();
    private WindowTypeRepository _windowTypes = new WindowTypeRepository();
    private AssociativeLinkRepository _associativeLinks = new AssociativeLinkRepository();

    public void addLibraryListener(LibraryListener libraryListener) {
        if (libraryListener != null) {
            this._listeners.addListener((EventListener)libraryListener);
        }
    }

    public void removeLibraryListener(LibraryListener libraryListener) {
        if (libraryListener != null) {
            this._listeners.removeListener((EventListener)libraryListener);
        }
    }

    public void addBook(Book book) throws LibraryException {
        if (book != null) {
            if (this._books.contains(book)) {
                throw new LibraryException("Library: Cannot add the same book twice.");
            }
        } else {
            throw new LibraryException("Library: Cannot add a NULL book");
        }
        this._books.add(book);
        this._windowTypes.addWindowTypesInBook(book);
        this._associativeLinks.addLinksInBook(book);
        this._fireLibraryChanged(new LibraryEvent(this, 2001, book));
    }

    public int getBookCount() {
        return this._books.size();
    }

    public Book[] getBooks() {
        Book[] bookArray = null;
        if (this._books.size() > 0) {
            bookArray = new Book[this._books.size()];
            this._books.toArray(bookArray);
        }
        return bookArray;
    }

    public Book getBookByName(String string) {
        if (string != null) {
            for (Book book : this._books) {
                if (!string.equals(book.getBookTitle())) continue;
                return book;
            }
        }
        return null;
    }

    public void removeBook(Book book) throws LibraryException {
        if (book != null) {
            if (!this._books.contains(book)) {
                throw new LibraryException("Library: Attempted to remove a book not in the library.");
            }
        } else {
            throw new LibraryException("Library: Cannot remove a NULL book");
        }
        this._books.remove(book);
        this._windowTypes.removeWindowTypesInBook(book);
        this._associativeLinks.removeLinksInBook(book);
        this._fireLibraryChanged(new LibraryEvent(this, 2002, book));
    }

    public View[] getAllViews() {
        return this._createViewArray(false, null);
    }

    public View[] getViewsByType(String string) {
        if (string == null) {
            return null;
        }
        return this._createViewArray(true, string);
    }

    public WindowType getDefaultWindowType() {
        return this._windowTypes.getDefaultWindowType();
    }

    public WindowType getWindowType(String string) {
        return this._windowTypes.getWindowType(string);
    }

    public AssociativeLink getAssociativeLink(String string) {
        return this._associativeLinks.getLink(string);
    }

    public URL mapIDToURL(String string) {
        URL uRL = null;
        for (int i = 0; uRL == null && i < this._books.size(); ++i) {
            Book book = (Book)this._books.get(i);
            if (book == null) continue;
            uRL = book.mapIDToURL(string);
        }
        return uRL;
    }

    public String mapURLToWindowTypeName(URL uRL) {
        String string = null;
        for (int i = 0; string == null && i < this._books.size(); ++i) {
            Book book = (Book)this._books.get(i);
            if (book == null) continue;
            string = book.mapURLToWindowTypeName(uRL);
        }
        return string;
    }

    public WindowType mapURLToWindowType(URL uRL) {
        WindowType windowType = null;
        String string = this.mapURLToWindowTypeName(uRL);
        if (string != null) {
            windowType = this.getWindowType(string);
        }
        if (windowType == null) {
            windowType = this.getDefaultWindowType();
        }
        return windowType;
    }

    private void _fireLibraryChanged(LibraryEvent libraryEvent) {
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                LibraryListener libraryListener = (LibraryListener)enumeration.nextElement();
                libraryListener.libraryChanged(libraryEvent);
            }
        }
    }

    private View[] _createViewArray(boolean bl, String string) {
        View[] viewArray;
        int n = 0;
        int n2 = 0;
        ArrayList<View> arrayList = new ArrayList<View>();
        if (bl && string == null) {
            return null;
        }
        for (n = 0; n < this._books.size(); ++n) {
            viewArray = (View[])this._books.get(n);
            View[] viewArray2 = null;
            viewArray2 = bl ? viewArray.getViewsByType(string) : viewArray.getAllViews();
            if (viewArray2 == null) continue;
            for (n2 = 0; n2 < viewArray2.length; ++n2) {
                if (arrayList.contains(viewArray2[n2])) continue;
                arrayList.add(viewArray2[n2]);
            }
        }
        viewArray = null;
        if (arrayList.size() > 0) {
            viewArray = new View[arrayList.size()];
            arrayList.toArray(viewArray);
        }
        return viewArray;
    }
}

