/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.TocFileTreeNode;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class XMLTOCEngine
extends DataEngine {
    private Book _book;
    private String _basePath;
    private static final String TAG_TOC = "toc";
    private static final String TAG_TOCITEM = "tocitem";
    private static final String TAG_TOCFILE = "tocfile";
    private static final String PROP_ID = "target";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_LOC = "location";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        Object object = null;
        try {
            object = this.createDataObject(view, string, bufferedReader);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        this._book = null;
        this._basePath = string;
        if (view != null) {
            this._book = view.getBook();
        }
        TopicTree topicTree = new TopicTree(this._book, string);
        TopicTreeNode topicTreeNode = topicTree.getRoot();
        Parser parser = ParserFactory.createParser(bufferedReader, string);
        XMLNode xMLNode = parser.getRoot();
        this._handleToc(xMLNode.getFirstChild(), topicTreeNode, view);
        return topicTree;
    }

    private void _handleToc(XMLNode xMLNode, TopicTreeNode topicTreeNode, View view) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOC)) {
            throw new XMLParseException("Toplevel tag is not TOC: " + xMLNode.getTokenValue());
        }
        int n = 0;
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOCFILE)) {
                view.setMasterView(true);
                n = this._handleTocFile(xMLNode, topicTreeNode, n);
                continue;
            }
            this._handleTocItem(xMLNode, topicTreeNode, view, n++);
        }
    }

    private void _handleTocItem(XMLNode xMLNode, TopicTreeNode topicTreeNode, View view, int n) throws XMLParseException {
        Object object;
        String string = xMLNode.getTokenValue();
        if (!string.equalsIgnoreCase(TAG_TOCITEM)) {
            throw new XMLParseException("Tag is not tocitem: " + string);
        }
        String string2 = xMLNode.getTokenProperty(PROP_ID);
        String string3 = xMLNode.getTokenProperty(PROP_IMAGE);
        SimpleTopic simpleTopic = new SimpleTopic(xMLNode.getTokenProperty(PROP_TEXT));
        if (string3 != null) {
            object = new IndirectTarget(this._book, string3);
            simpleTopic.setDefaultIcon((Target)object);
        }
        if (string2 != null) {
            object = new IndirectTarget(this._book, string2);
            simpleTopic.setTarget((Target)object);
        }
        object = new TopicTreeNode(view, simpleTopic);
        ((TopicTreeNode)object).setSortValue(n);
        topicTreeNode.addChild((TopicTreeNode)object);
        n = 0;
        for (xMLNode = xMLNode.getFirstChild(); xMLNode != null; xMLNode = xMLNode.getNextSibling()) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOCFILE)) {
                view.setMasterView(true);
                n = this._handleTocFile(xMLNode, (TopicTreeNode)object, n);
                continue;
            }
            this._handleTocItem(xMLNode, (TopicTreeNode)object, view, n++);
        }
    }

    private int _handleTocFile(XMLNode xMLNode, TopicTreeNode topicTreeNode, int n) {
        TocFileTreeNode tocFileTreeNode = new TocFileTreeNode(xMLNode.getTokenProperty(PROP_LOC));
        tocFileTreeNode.setSortValue(n);
        topicTreeNode.getChildren().add(tocFileTreeNode);
        return n + tocFileTreeNode.getLocation().split(";").length;
    }
}

