/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.KeywordIndexItem;
import oracle.help.common.util.IndexedListListener;
import oracle.help.common.util.java.StaticLocaleContext;

public class KeywordModel {
    public static String SUB_ITEM_INDENT = "    ";
    private ListenerManager _listenerManager = null;
    private Locale _locale;
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String WORD_LIST_SEPARATOR = "navigator.keywordNavigator.wordListSeparator";
    private ArrayList _keyViews = new ArrayList();
    private ArrayList _listItems = new ArrayList();
    private int _itemCount = 0;
    private Collator _localColl;
    private int _insertionCompareValue = -1;
    private boolean _leftToRight;
    private String _subItemSeparator;

    public KeywordModel(Locale locale, String string) {
        this(null, locale, string);
    }

    public KeywordModel(View[] viewArray, String string) {
        this(viewArray, StaticLocaleContext.getLocale(), string);
    }

    public KeywordModel(View[] viewArray, Locale locale, String string) {
        this._locale = locale;
        this._localColl = Collator.getInstance(locale);
        this._subItemSeparator = string;
        this._leftToRight = true;
        if (viewArray != null) {
            for (int i = 0; i < viewArray.length; ++i) {
                if (this._keyViews.contains(viewArray[i])) continue;
                this._keyViews.add(viewArray[i]);
            }
        }
        if (this._keyViews.size() > 0) {
            View[] viewArray2 = new View[this._keyViews.size()];
            this._keyViews.toArray(viewArray2);
            this._mergeKeywordIndices(viewArray2, true);
        }
    }

    public void addIndexedListListener(IndexedListListener indexedListListener) {
        ListenerManager listenerManager = this.getListenerManager();
        listenerManager.addListener((EventListener)indexedListListener);
    }

    public void removeIndexedListListener(IndexedListListener indexedListListener) {
        ListenerManager listenerManager = this.getListenerManager();
        listenerManager.removeListener((EventListener)indexedListListener);
    }

    protected ListenerManager getListenerManager() {
        if (this._listenerManager == null) {
            this._listenerManager = new ListenerManager();
        }
        return this._listenerManager;
    }

    public void addView(View view) {
        if (view != null && !this._keyViews.contains(view)) {
            this._keyViews.add(view);
            View[] viewArray = new View[]{view};
            this._mergeKeywordIndices(viewArray, true);
        }
    }

    public void removeView(View view) {
        if (view != null && this._keyViews.contains(view)) {
            this._keyViews.remove(view);
            View[] viewArray = new View[]{view};
            this._mergeKeywordIndices(viewArray, false);
        }
    }

    public KeywordIndexItem getKeywordIndexItemForIndex(int n) {
        KeywordIndexItem keywordIndexItem = null;
        if (n < this._listItems.size()) {
            keywordIndexItem = (KeywordIndexItem)this._listItems.get(n);
        }
        return keywordIndexItem;
    }

    public String getSortingLabelForIndex(int n) {
        String string = null;
        if (n < this._listItems.size()) {
            KeywordIndexItem keywordIndexItem = (KeywordIndexItem)this._listItems.get(n);
            string = keywordIndexItem.sortingLabel;
        }
        return string;
    }

    private void _mergeKeywordIndices(View[] viewArray, boolean bl) {
        if (viewArray != null) {
            for (int i = 0; i < viewArray.length; ++i) {
                if (bl) {
                    this._addViewItems(viewArray[i]);
                    continue;
                }
                this._removeViewItems(viewArray[i]);
            }
        }
    }

    private void _addViewItems(View view) {
        if (view != null) {
            ArrayList arrayList;
            TopicTree topicTree = this._getTopicTree(view);
            if (topicTree != null && (arrayList = topicTree.getRoot().getChildren()) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    this._addNodeItems((TopicTreeNode)arrayList.get(i), view, null);
                }
            }
            this._fireCurrentEvent();
        }
    }

    private void _removeViewItems(View view) {
        int n = 0;
        if (view != null) {
            for (n = this._listItems.size() - 1; n >= 0; --n) {
                KeywordIndexItem keywordIndexItem = (KeywordIndexItem)this._listItems.get(n);
                keywordIndexItem.removeNode(view);
                if (keywordIndexItem.getNodeCount() != 0) continue;
                this._listItems.remove(n);
                this._fireRemoveEvent(n);
            }
            this._fireCurrentEvent();
        }
    }

    private void _addNodeItems(TopicTreeNode topicTreeNode, View view, String string) {
        Object object;
        this._fixNodeWithSeparators(topicTreeNode);
        Topic topic = topicTreeNode.getTopic();
        String string2 = topic.getLabel();
        boolean bl = false;
        String string3 = string2;
        if (string != null) {
            bl = true;
            string3 = this._leftToRight ? string + this._subItemSeparator + " " + string3 : string3 + " " + this._subItemSeparator + string;
        }
        String string4 = this._convertForCollate(string3);
        int n = this._findInsertionPoint(string4) + 1;
        if (this._insertionCompareValue == 0 && this._listItems.size() > 0) {
            object = (KeywordIndexItem)this._listItems.get(n - 1);
            ((KeywordIndexItem)object).addNode(topicTreeNode);
        } else {
            object = new KeywordIndexItem(string2, string3, string4, bl);
            ((KeywordIndexItem)object).addNode(topicTreeNode);
            this._listItems.add(n, object);
        }
        this._fireAddEvent(n);
        object = topicTreeNode.getChildren();
        if (object != null) {
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                if (string == null) {
                    String string5 = string3;
                    this._addNodeItems((TopicTreeNode)((ArrayList)object).get(i), view, string5);
                    continue;
                }
                this._addNodeItems((TopicTreeNode)((ArrayList)object).get(i), view, string);
            }
        }
    }

    private void _fixNodeWithSeparators(TopicTreeNode topicTreeNode) {
        Topic topic = topicTreeNode.getTopic();
        Target target = topic.getTarget();
        String string = topic.getLabel();
        int n = string.indexOf(this._subItemSeparator);
        if (n != -1) {
            KeywordTopicTreeNode keywordTopicTreeNode;
            ArrayList arrayList;
            String string2 = null;
            String string3 = null;
            if (this._leftToRight) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            } else {
                n = string.lastIndexOf(this._subItemSeparator);
                string2 = string.substring(n + 1);
                string3 = string.substring(0, n);
            }
            SimpleTopic simpleTopic = new SimpleTopic(string2);
            SimpleTopic simpleTopic2 = new SimpleTopic(string3, target);
            topicTreeNode.setTopic(simpleTopic);
            KeywordTopicTreeNode keywordTopicTreeNode2 = new KeywordTopicTreeNode(topicTreeNode.getView(), simpleTopic2, topicTreeNode);
            if (topicTreeNode instanceof KeywordTopicTreeNode && (arrayList = (keywordTopicTreeNode = (KeywordTopicTreeNode)topicTreeNode).getEntries()) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    keywordTopicTreeNode2.addEntry((KeywordTopicTreeNode)arrayList.get(i));
                }
                keywordTopicTreeNode.removeAllEntries();
            }
            topicTreeNode.addChild(keywordTopicTreeNode2);
        }
    }

    public int findClosestKeywordIndexItem(String string) {
        if (this._listItems.size() == 0) {
            return -1;
        }
        String string2 = this._convertForCollate(string);
        int n = this._findInsertionPoint(string2);
        if (n == -1) {
            n = 0;
        } else {
            KeywordIndexItem keywordIndexItem = (KeywordIndexItem)this._listItems.get(n);
            if (this._localColl.compare(keywordIndexItem.convertedLabel.toLowerCase(), string2.toLowerCase()) != 0 && n + 1 < this._listItems.size()) {
                keywordIndexItem = (KeywordIndexItem)this._listItems.get(n + 1);
                if (this._leftToRight) {
                    if (keywordIndexItem.sortingLabel.toLowerCase().startsWith(string.toLowerCase())) {
                        ++n;
                    }
                } else if (keywordIndexItem.sortingLabel.toLowerCase().endsWith(string.toLowerCase())) {
                    ++n;
                }
            }
        }
        return n;
    }

    public List getIndexItems() {
        return this._listItems;
    }

    public List getIndexItems(int n, int n2) {
        KeywordIndexItem keywordIndexItem;
        List list = this.getIndexItems();
        if (n > list.size()) {
            n = 0;
        }
        int n3 = n + n2 < list.size() ? n + n2 : list.size();
        ArrayList<KeywordIndexItem> arrayList = new ArrayList<KeywordIndexItem>();
        Iterator iterator = list.subList(n, n3).iterator();
        int n4 = n;
        while (iterator.hasNext()) {
            keywordIndexItem = (KeywordIndexItem)iterator.next();
            keywordIndexItem.setTopicId(n4++);
            arrayList.add(keywordIndexItem);
        }
        if (n > 0 && (keywordIndexItem = (KeywordIndexItem)arrayList.get(0)).getIndent()) {
            int n5 = n - 1;
            KeywordIndexItem keywordIndexItem2 = null;
            do {
                keywordIndexItem2 = this.getKeywordIndexItemForIndex(n5--);
            } while (n5 > 0 && keywordIndexItem2 != null && keywordIndexItem2.getIndent());
            if (keywordIndexItem2 != null) {
                arrayList.add(0, keywordIndexItem2);
            }
        }
        return arrayList;
    }

    public List getIndexItems(int n, int n2, List list) {
        if (n > list.size()) {
            n = 0;
        }
        int n3 = n + n2 < list.size() ? n + n2 : list.size();
        return list.subList(n, n3);
    }

    public String getNodeTitle(int n) {
        KeywordIndexItem keywordIndexItem = this.getKeywordIndexItemForIndex(n);
        if (keywordIndexItem != null) {
            return keywordIndexItem.getText();
        }
        return null;
    }

    public List getEntries(int n) {
        KeywordIndexItem keywordIndexItem = this.getKeywordIndexItemForIndex(n);
        if (keywordIndexItem != null) {
            return keywordIndexItem.getEntries();
        }
        return null;
    }

    public int getSize() {
        return this._listItems.size();
    }

    private void _fireAddEvent(int n) {
        ListenerManager listenerManager = this.getListenerManager();
        Enumeration enumeration = listenerManager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                IndexedListListener indexedListListener = (IndexedListListener)enumeration.nextElement();
                indexedListListener.queueItemAdded(n);
            }
        }
    }

    private void _fireRemoveEvent(int n) {
        ListenerManager listenerManager = this.getListenerManager();
        Enumeration enumeration = listenerManager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                IndexedListListener indexedListListener = (IndexedListListener)enumeration.nextElement();
                indexedListListener.queueItemRemoved(n);
            }
        }
    }

    private void _fireCurrentEvent() {
        ListenerManager listenerManager = this.getListenerManager();
        Enumeration enumeration = listenerManager.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                IndexedListListener indexedListListener = (IndexedListListener)enumeration.nextElement();
                indexedListListener.fireCurrentEvent();
            }
        }
    }

    private int _findInsertionPoint(String string) {
        if (string == null) {
            return -1;
        }
        int n = 0;
        int n2 = this._listItems.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            KeywordIndexItem keywordIndexItem = (KeywordIndexItem)this._listItems.get(n3);
            this._insertionCompareValue = this._localColl.compare(string, keywordIndexItem.convertedLabel);
            if (this._insertionCompareValue == 0) {
                return n3;
            }
            if (this._insertionCompareValue < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        return n2;
    }

    private String _convertForCollate(String string) {
        int n = string.length();
        char[] cArray = new char[]{'\'', ' ', '\''};
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                cArray[1] = c;
                stringBuffer.append(cArray);
                continue;
            }
            stringBuffer.append(c);
        }
        if (this._leftToRight) {
            stringBuffer.append(this._subItemSeparator);
        } else {
            stringBuffer.insert(0, this._subItemSeparator);
        }
        return stringBuffer.toString();
    }

    private TopicTree _getTopicTree(View view) {
        TopicTree topicTree = null;
        if (view != null) {
            try {
                topicTree = (TopicTree)view.getViewData();
            }
            catch (Exception exception) {
                System.err.println("View passed to KeywordModel does not contain data in TopicTree format.");
                exception.printStackTrace();
                topicTree = null;
            }
        }
        return topicTree;
    }
}

