/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.awt.Color;
import java.awt.Rectangle;
import oracle.help.common.WindowCoordinate;
import oracle.help.common.WindowToolbar;
import oracle.help.library.Book;

public class WindowType {
    private Book _book = null;
    private String _name = null;
    private WindowCoordinate _height = null;
    private WindowCoordinate _width = null;
    private WindowCoordinate _x = null;
    private WindowCoordinate _y = null;
    private Color _textFG = null;
    private Color _linkFG = null;
    private Color _pageBG = null;
    private String _title = null;
    private WindowToolbar _toolbar = null;
    private boolean _isDefault = false;

    public WindowType(Book book) {
        this._book = book;
        this._toolbar = new WindowToolbar(0);
    }

    public void setName(String string) {
        if (string != null && string.length() > 0) {
            this._name = string;
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public void setDefault(boolean bl) {
        this._isDefault = bl;
    }

    public void setHeight(String string) {
        WindowCoordinate windowCoordinate = this._stringToCoordinate(string, false);
        if (windowCoordinate != null) {
            this._height = windowCoordinate;
        }
    }

    public WindowCoordinate getHeight() {
        return this._height;
    }

    public void setWidth(String string) {
        WindowCoordinate windowCoordinate = this._stringToCoordinate(string, true);
        if (windowCoordinate != null) {
            this._width = windowCoordinate;
        }
    }

    public WindowCoordinate getWidth() {
        return this._width;
    }

    public void setX(String string) {
        WindowCoordinate windowCoordinate = this._stringToCoordinate(string, true);
        if (windowCoordinate != null) {
            this._x = windowCoordinate;
        }
    }

    public WindowCoordinate getX() {
        return this._x;
    }

    public void setY(String string) {
        WindowCoordinate windowCoordinate = this._stringToCoordinate(string, false);
        if (windowCoordinate != null) {
            this._y = windowCoordinate;
        }
    }

    public WindowCoordinate getY() {
        return this._y;
    }

    public void setTextFG(String string) {
        Color color = this._stringToColor(string);
        this.setTextFG(color);
    }

    public void setTextFG(Color color) {
        if (color != null) {
            this._textFG = color;
        }
    }

    public Color getTextFG() {
        return this._textFG;
    }

    public void setLinkFG(String string) {
        Color color = this._stringToColor(string);
        this.setLinkFG(color);
    }

    public void setLinkFG(Color color) {
        if (color != null) {
            this._linkFG = color;
        }
    }

    public Color getLinkFG() {
        return this._linkFG;
    }

    public void setPageBG(String string) {
        Color color = this._stringToColor(string);
        this.setPageBG(color);
    }

    public void setPageBG(Color color) {
        if (color != null) {
            this._pageBG = color;
        }
    }

    public Color getPageBG() {
        return this._pageBG;
    }

    public void setTitle(String string) {
        if (string != null && string.length() > 0) {
            this._title = string;
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setToolbar(String string) {
        if (string != null) {
            string = string.trim();
            try {
                int n = Integer.parseInt(string, 16);
                this._toolbar = new WindowToolbar(n);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException);
            }
        }
    }

    public void setToolbar(WindowToolbar windowToolbar) {
        this._toolbar = windowToolbar;
    }

    public WindowToolbar getToolbar() {
        return this._toolbar;
    }

    public void setBounds(Rectangle rectangle) {
        this._height = new WindowCoordinate(rectangle.height, false, false, false);
        this._width = new WindowCoordinate(rectangle.width, false, false, true);
        this._x = new WindowCoordinate(rectangle.x, false, false, true);
        this._y = new WindowCoordinate(rectangle.y, false, false, false);
    }

    public Book getBook() {
        return this._book;
    }

    private Color _stringToColor(String string) {
        Color color = null;
        if (string != null) {
            if ((string = string.trim()).charAt(0) == '#') {
                string = string.substring(1);
            }
            try {
                int n = Integer.parseInt(string, 16);
                color = new Color(n);
            }
            catch (NumberFormatException numberFormatException) {
                color = null;
            }
        }
        return color;
    }

    private WindowCoordinate _stringToCoordinate(String string, boolean bl) {
        WindowCoordinate windowCoordinate = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null) {
            if ((string = string.trim()).charAt(0) == '-') {
                string = string.substring(1);
                bl2 = true;
            }
            if (string.charAt(string.length() - 1) == '%') {
                string = string.substring(0, string.length() - 1);
                bl3 = true;
            }
            try {
                int n = Integer.parseInt(string);
                windowCoordinate = new WindowCoordinate(n, bl2, bl3, bl);
            }
            catch (NumberFormatException numberFormatException) {
                windowCoordinate = null;
            }
        }
        return windowCoordinate;
    }
}

