/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.ArrayList;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;

public class KeywordTopicTreeNode
extends TopicTreeNode {
    private ArrayList _entries = null;

    public KeywordTopicTreeNode(View view, Topic topic) {
        this(view, topic, null);
    }

    public KeywordTopicTreeNode(View view, Topic topic, TopicTreeNode topicTreeNode) {
        super(view, topic, topicTreeNode);
    }

    public ArrayList getEntries() {
        return this._entries;
    }

    public KeywordTopicTreeNode getEntryByIndex(int n) throws IndexOutOfBoundsException {
        KeywordTopicTreeNode keywordTopicTreeNode = null;
        if (n >= this.getNumEntries()) {
            throw new IndexOutOfBoundsException("Entry Index out of Bounds");
        }
        keywordTopicTreeNode = (KeywordTopicTreeNode)this._entries.get(n);
        return keywordTopicTreeNode;
    }

    public final int getNumEntries() {
        if (this._entries == null) {
            return 0;
        }
        return this._entries.size();
    }

    public KeywordTopicTreeNode addEntry(Topic topic) {
        return this.addEntry(new KeywordTopicTreeNode(this.getView(), topic));
    }

    public KeywordTopicTreeNode addEntry(KeywordTopicTreeNode keywordTopicTreeNode) {
        keywordTopicTreeNode.setParent(this);
        if (this._entries == null) {
            this._entries = new ArrayList(5);
        }
        this._entries.add(keywordTopicTreeNode);
        return keywordTopicTreeNode;
    }

    public void removeAllEntries() {
        if (this._entries != null) {
            this._entries.clear();
        }
    }
}

